/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.novell.gw.ab.AddressBook;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;

class ABListModel
extends DefaultListModel {
    private List books;

    public void setData(List books) {
        this.books = books;
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public int getSize() {
        return this.books.size();
    }

    public Object getElementAt(int index) {
        return ((AddressBook)this.books.get(index)).getName();
    }

    public List getData() {
        return Collections.unmodifiableList(this.books);
    }

    public void moveUp(int index) {
        Collections.swap(this.books, index - 1, index);
        this.fireContentsChanged(this, index - 1, index);
    }

    public void moveDown(int index) {
        Collections.swap(this.books, index, index + 1);
        this.fireContentsChanged(this, index, index + 1);
    }

    public void addItem(AddressBook theAddressBook) {
        this.books.add(theAddressBook);
        this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
    }

    public void removeItem(AddressBook theAddressBook) {
        int index = this.books.indexOf(theAddressBook);
        boolean result = this.books.remove(theAddressBook);
        if (result && index != -1) {
            this.fireIntervalRemoved(this, index, index);
        }
    }
}

