/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.ComponentBorder;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsPane;
import com.novell.gw.jclient.application.controls.gwcomponent.GWComboBox;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

class ContactPane
extends UserContactDetailsPane {
    public static final String ENTER_NAME = "<<" + StringResources.ENTER_NAME + ">>";
    private static final int FIRST = EngineCommandManager.getAddressBookManager().getSystemAddressBook().getNameFormat();
    private static final int SECOND = FIRST == 50091 ? 50093 : 50091;
    private static final int CUSTOM_NAME = 2;
    private JPanel pnlEmail = new OrientablePanel(new GridBagLayout());
    private JPanel pnlInstMessanger = new OrientablePanel(new GridBagLayout());
    private JPanel pnlPhone = new OrientablePanel(new BorderLayout());
    private AbstractButton rbOfficePhone = new JMnemonicRadioButton(StringResources.OFFICE);
    private AbstractButton rbHomePhone = new JMnemonicRadioButton(StringResources.HOME);
    private AbstractButton rbMobilPhone = new JMnemonicRadioButton(StringResources.MOBILE);
    private AbstractButton rbFax = new JMnemonicRadioButton(StringResources.FAX);
    private AbstractButton rbPager = new JMnemonicRadioButton(StringResources.PAGER);
    private JTextField tfFirstName = new GWTextField();
    private JTextField tfMidleName = new GWTextField();
    private JTextField tfLastName = new GWTextField();
    private DefaultComboBoxModel displayNameModel = new CPModel();
    private JTextField tfIMAdress = new GWTextField();
    private JTextField tfEmail = new GWTextField();
    private JComboBox cmbDisplayName = new GWComboBox();
    private JTextField tfOfficePhone = new GWTextField();
    private JTextField tfHomePhone = new GWTextField();
    private JTextField tfMobilPhone = new GWTextField();
    private JTextField tfPager = new GWTextField();
    private JTextField tfFax = new GWTextField();
    private JComboBox cmbNamePrefix = new OrientableComboBox(new String[]{"", StringResources.PREFIX_DR, StringResources.PREFIX_MISS, StringResources.PREFIX_MR, StringResources.PREFIX_MRS, StringResources.PREFIX_MS, StringResources.PREFIX_PROF});
    private JComboBox cmbNameSufix = new OrientableComboBox(new String[]{"", StringResources.SUFFIX_I, StringResources.SUFFIX_II, StringResources.SUFFIX_III, StringResources.SUFFIX_JUNIOR, StringResources.SUFFIX_SENIOR});
    private EmailsTableModel emailsTableModel = new EmailsTableModel();
    private JTable tableEmails = new ExtendedGWTable(this.emailsTableModel);
    private ImAddressesModel imAddressesModel = new ImAddressesModel();
    private JTable tableIMAddresses = new ExtendedGWTable(this.imAddressesModel);
    private AbstractButton btnRemoveEmail;
    private AbstractButton btnRemoveIMAddress;
    private AbstractButton btnEditEmail;
    private AbstractButton btnEditIMAddress;
    private AbstractAction actionAddEmail;
    private AbstractAction actionAddIM;

    public ContactPane(IUserContact theContact) {
        super(theContact);
        this.tfFirstName.setName("ContactPane_tfFirstName");
        this.tfMidleName.setName("ContactPane_tfMiddleName");
        this.tfLastName.setName("ContactPane_tfLastName");
        this.cmbDisplayName.setName("ContactPane_cmbDisplayName");
        this.tfEmail.setName("ContactPane_tfEmail");
        this.cmbNamePrefix.setName("ContactPane_cmbNamePrefix");
        this.cmbNameSufix.setName("ContactPane_cmbNameSufix");
        this.tfOfficePhone.setName("ContactPane_tfOfficePhone");
        this.tfHomePhone.setName("ContactPane_tfHomePhone");
        this.tfMobilPhone.setName("ContactPane_tfMobilPhone");
        this.tfPager.setName("ContactPane_tfPager");
        this.tfFax.setName("ContactPane_tfFax");
        this.setName(StringResources.CONTACT);
        this.buildContactTab();
        this.displayNameModel.addElement(ENTER_NAME);
        this.cmbDisplayName.setModel(this.displayNameModel);
        if (PLAFChanger.isMetalLAF()) {
            JTextComponent textComponent = (JTextComponent)this.cmbDisplayName.getEditor().getEditorComponent();
            textComponent.setBorder(new CPBorder(textComponent.getBorder()));
            if ("steel".equals(System.getProperty("swing.metalTheme"))) {
                textComponent.setBorder(this.tfFirstName.getBorder());
            }
        }
        this.tfFirstName.getDocument().addDocumentListener(new DNDocumentListener());
        this.tfLastName.getDocument().addDocumentListener(new DNDocumentListener());
    }

    private void addPropertiesChangeListener() {
        if (!this.isReadOnly) {
            this.tfEmail.addKeyListener(this.getPropertiesChangeListener());
            this.tfFax.addKeyListener(this.getPropertiesChangeListener());
            this.tfFirstName.addKeyListener(this.getPropertiesChangeListener());
            this.tfHomePhone.addKeyListener(this.getPropertiesChangeListener());
            this.tfIMAdress.addKeyListener(this.getPropertiesChangeListener());
            this.tfLastName.addKeyListener(this.getPropertiesChangeListener());
            this.tfMidleName.addKeyListener(this.getPropertiesChangeListener());
            this.tfMobilPhone.addKeyListener(this.getPropertiesChangeListener());
            this.tfOfficePhone.addKeyListener(this.getPropertiesChangeListener());
            this.tfPager.addKeyListener(this.getPropertiesChangeListener());
            this.cmbDisplayName.addItemListener(this.getPropertiesChangeListener());
            this.cmbNamePrefix.addItemListener(this.getPropertiesChangeListener());
            this.cmbNameSufix.addItemListener(this.getPropertiesChangeListener());
        }
    }

    private int getNameFormat() {
        int size = this.displayNameModel.getSize();
        int selectedIndex = this.cmbDisplayName.getSelectedIndex();
        if (size == 1) {
            return FIRST;
        }
        if (size == 2) {
            if (this.tfFirstName.getText().equals("")) {
                return SECOND;
            }
            if (this.tfLastName.getText().equals("")) {
                return FIRST;
            }
            return 2;
        }
        if (selectedIndex == 0) {
            return FIRST;
        }
        if (selectedIndex == 1) {
            return SECOND;
        }
        return 2;
    }

    private void updateDisplayName() {
        int displayNameFormat;
        String displayName;
        if ((this.tfFirstName.getText().equals("") || this.tfLastName.getText().equals("")) && this.displayNameModel.getSize() == 3) {
            this.displayNameModel.removeElementAt(0);
        }
        if (this.tfFirstName.getText().equals("") && this.tfLastName.getText().equals("") && this.displayNameModel.getSize() == 2) {
            this.displayNameModel.removeElementAt(0);
        }
        if ((displayName = this.getDisplayName(displayNameFormat = this.getNameFormat())).length() != 0 && this.displayNameModel.getSize() == 1) {
            this.displayNameModel.insertElementAt("", 0);
            this.cmbDisplayName.setSelectedIndex(0);
        } else if (displayName.length() == 0 && this.displayNameModel.getSize() == 2 && !this.tfFirstName.getText().equals("") && !this.tfLastName.getText().equals("")) {
            this.displayNameModel.insertElementAt("", 0);
            this.cmbDisplayName.setSelectedIndex(0);
        }
        if (displayNameFormat != 2) {
            this.cmbDisplayName.setSelectedItem(displayName);
        } else {
            ((CPModel)this.cmbDisplayName.getModel()).refreshDisplayNames();
            this.cmbDisplayName.setSelectedIndex(0);
        }
    }

    private String getDisplayName(int displayNameFormat) {
        if (displayNameFormat != 2) {
            String firstName = this.tfFirstName.getText();
            String lastName = this.tfLastName.getText();
            String displayName = EngineCommandManager.getAddressBookManager().buildDisplayName(firstName, lastName, displayNameFormat);
            return displayName;
        }
        return "";
    }

    private void buildContactTab() {
        this.setLayout(new BorderLayout());
        OrientablePanel pnlName = new OrientablePanel(new GridBagLayout());
        TitleValueContainer container = new TitleValueContainer(pnlName);
        container.buildRow(new JMnemonicLabel(StringResources.FIRST_C, this.tfFirstName), this.tfFirstName, new JMnemonicLabel(StringResources.PREFIX_C, this.cmbNamePrefix), this.cmbNamePrefix, 0);
        container.buildRow(new JMnemonicLabel(StringResources.MIDDLE_C, this.tfMidleName), this.tfMidleName, new JMnemonicLabel(StringResources.SUFFIX_C, this.cmbNameSufix), this.cmbNameSufix, 1);
        this.cmbNamePrefix.setSelectedItem(0);
        this.cmbNameSufix.setSelectedItem(0);
        this.cmbDisplayName.setEditable(true);
        this.cmbDisplayName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JComboBox cmb = (JComboBox)e.getSource();
                JTextField field = (JTextField)cmb.getEditor().getEditorComponent();
                field.selectAll();
            }
        });
        container.buildRow(new JMnemonicLabel(StringResources.LAST_C, this.tfLastName), this.tfLastName, new JMnemonicLabel(StringResources.DISPLAY_C, this.cmbDisplayName), this.cmbDisplayName, 2);
        pnlName.setBorder(BorderFactory.createTitledBorder(StringResources.NAME));
        this.add((Component)pnlName, "North");
        ComponentOrientation co = UIUtils.getComponentOrientation();
        this.tableIMAddresses.setComponentOrientation(co);
        this.tableIMAddresses.setDefaultRenderer(Object.class, new OrientableTableCellRenderer());
        this.tableEmails.setComponentOrientation(co);
        this.setComponentOrientation(co);
        this.buildEmailPanel();
        this.buildPhonePanel();
        this.buildInstMessangerPanel();
        OrientablePanel pnlTemp = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 4, 4, 4);
        constraints.weightx = 50.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.gridx = 0;
        constraints.gridy = 0;
        pnlTemp.add((Component)this.pnlEmail, constraints);
        constraints.weightx = 50.0;
        constraints.gridheight = 2;
        constraints.gridx = 1;
        constraints.gridy = 0;
        pnlTemp.add((Component)this.pnlPhone, constraints);
        constraints.weightx = 60.0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 1;
        pnlTemp.add((Component)this.pnlInstMessanger, constraints);
        this.add((Component)pnlTemp, "Center");
    }

    private void buildEmailPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 3, 5, 5);
        constraints.anchor = 21;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.pnlEmail.add((Component)this.tfEmail, constraints);
        constraints.weightx = 0.0;
        this.actionAddEmail = new AddElementToTableAction(this.tfEmail, this.emailsTableModel, this.tableEmails, StringResources.ADD);
        constraints.anchor = 22;
        JMnemonicButton btnAddEmail = new JMnemonicButton(this.actionAddEmail);
        this.tfEmail.getDocument().addDocumentListener(new AddButtonsEnabledAction(this.tfEmail, btnAddEmail));
        btnAddEmail.setEnabled(false);
        this.pnlEmail.add((Component)btnAddEmail, constraints);
        constraints.anchor = 21;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridy = 1;
        constraints.fill = 1;
        this.tableEmails.setTableHeader(null);
        TableColumn column = this.tableEmails.getColumnModel().getColumn(0);
        column.setResizable(false);
        column.setMaxWidth(16);
        column.setMinWidth(16);
        this.tableEmails.setShowGrid(false);
        this.tableEmails.getSelectionModel().setSelectionMode(0);
        this.tableEmails.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
                if (ContactPane.this.tableEmails.getRowCount() > 0) {
                    boolean isSelectionEmpty = model.isSelectionEmpty();
                    ContactPane.this.btnEditEmail.setEnabled(!isSelectionEmpty);
                    ContactPane.this.btnRemoveEmail.setEnabled(!isSelectionEmpty);
                } else {
                    ContactPane.this.btnEditEmail.setEnabled(false);
                    ContactPane.this.btnRemoveEmail.setEnabled(false);
                }
            }
        });
        this.tableEmails.getColumnModel().getColumn(1).setCellEditor(new MyTableCellEditor(new GWTextField()));
        ColoredScrollPane scrollPane = new ColoredScrollPane(this.tableEmails);
        scrollPane.setPreferredSize(new Dimension(280, 100));
        this.pnlEmail.add((Component)scrollPane, constraints);
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(0, 1, 0, 5));
        this.btnRemoveEmail = new JMnemonicButton(new RemoveElementFromTableAction(this.tableEmails, this.emailsTableModel));
        this.btnEditEmail = new JButton(new EditTableElementAction(this.tableEmails));
        pnlButtons.add(this.btnRemoveEmail);
        pnlButtons.add(this.btnEditEmail);
        constraints.anchor = 24;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        this.pnlEmail.add((Component)pnlButtons, constraints);
        JMnemonicLabel lbTitle = new JMnemonicLabel(StringResources.EMAIL_ADDRESS_C, this.tfEmail);
        constraints.gridy = 0;
        constraints.gridx = 0;
        this.pnlEmail.add((Component)lbTitle, constraints);
        ComponentBorder componentBorder = new ComponentBorder(lbTitle);
        this.pnlEmail.setBorder(BorderFactory.createCompoundBorder(componentBorder, BorderFactory.createEmptyBorder(10, 0, 0, 0)));
        this.tableEmails.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    ContactPane.this.btnEditEmail.getAction().actionPerformed(null);
                }
            }
        });
    }

    private void buildInstMessangerPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 3, 5, 5);
        constraints.anchor = 21;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        OrientableComboBox cmbInst = new OrientableComboBox();
        this.pnlInstMessanger.add((Component)cmbInst, constraints);
        this.pnlInstMessanger.add((Component)this.tfIMAdress, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 2;
        constraints.anchor = 22;
        this.actionAddIM = new AddElementToTableAction(this.tfIMAdress, this.imAddressesModel, this.tableIMAddresses, StringResources.ADD);
        JMnemonicButton btnAddInstM = new JMnemonicButton(this.actionAddIM);
        this.tfIMAdress.getDocument().addDocumentListener(new AddButtonsEnabledAction(this.tfIMAdress, btnAddInstM));
        btnAddInstM.setEnabled(false);
        UIUtils.setMnemonic(btnAddInstM, 1);
        this.pnlInstMessanger.add((Component)btnAddInstM, constraints);
        constraints.anchor = 21;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        this.tableIMAddresses.setTableHeader(null);
        this.tableIMAddresses.setShowGrid(false);
        this.tableIMAddresses.getSelectionModel().setSelectionMode(0);
        ColoredScrollPane scrollPane = new ColoredScrollPane(this.tableIMAddresses);
        scrollPane.setPreferredSize(new Dimension(280, 100));
        this.pnlInstMessanger.add((Component)scrollPane, constraints);
        this.tableIMAddresses.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
                if (ContactPane.this.tableIMAddresses.getRowCount() > 0) {
                    boolean isSelectionEmpty = model.isSelectionEmpty();
                    ContactPane.this.btnEditIMAddress.setEnabled(!isSelectionEmpty);
                    ContactPane.this.btnRemoveIMAddress.setEnabled(!isSelectionEmpty);
                } else {
                    ContactPane.this.btnEditIMAddress.setEnabled(false);
                    ContactPane.this.btnRemoveIMAddress.setEnabled(false);
                }
            }
        });
        this.tableIMAddresses.getColumnModel().getColumn(0).setCellEditor(new MyTableCellEditor(new GWTextField()));
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(0, 1, 0, 5));
        this.btnRemoveIMAddress = new JMnemonicButton(new RemoveElementFromTableAction(this.tableIMAddresses, this.imAddressesModel));
        this.btnEditIMAddress = new JButton(new EditTableElementAction(this.tableIMAddresses));
        pnlButtons.add(this.btnRemoveIMAddress);
        pnlButtons.add(this.btnEditIMAddress);
        constraints.anchor = 11;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        constraints.gridy = 1;
        this.pnlInstMessanger.add((Component)pnlButtons, constraints);
        JMnemonicLabel lbTitle = new JMnemonicLabel(StringResources.INSTANT_MESSAGING, cmbInst);
        constraints.gridy = 0;
        constraints.gridx = 0;
        this.pnlInstMessanger.add((Component)lbTitle, constraints);
        ComponentBorder componentBorder = new ComponentBorder(lbTitle);
        this.pnlInstMessanger.setBorder(BorderFactory.createCompoundBorder(componentBorder, BorderFactory.createEmptyBorder(10, 0, 0, 0)));
        this.tableIMAddresses.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    ContactPane.this.btnEditIMAddress.getAction().actionPerformed(null);
                }
            }
        });
    }

    private void buildPhonePanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbFax);
        buttonGroup.add(this.rbHomePhone);
        buttonGroup.add(this.rbMobilPhone);
        buttonGroup.add(this.rbOfficePhone);
        buttonGroup.add(this.rbPager);
        OrientablePanel pnlPhone = new OrientablePanel(new GridBagLayout());
        TitleValueContainer container = new TitleValueContainer(pnlPhone);
        container.buildRow(this.rbOfficePhone, this.tfOfficePhone, 0);
        this.tfOfficePhone.setColumns(6);
        container.buildRow(this.rbHomePhone, this.tfHomePhone, 1);
        container.buildRow(this.rbMobilPhone, this.tfMobilPhone, 2);
        container.buildRow(this.rbFax, this.tfFax, 3);
        container.buildRow(this.rbPager, this.tfPager, 4);
        this.pnlPhone.add((Component)pnlPhone, "North");
        this.pnlPhone.setBorder(BorderFactory.createTitledBorder(StringResources.PHONE));
    }

    public boolean loadProperties() {
        this.tfFirstName.setText(this.contact.getFirstName());
        this.tfLastName.setText(this.contact.getLastName());
        this.tfMidleName.setText(this.contact.getMiddleName());
        this.cmbDisplayName.setSelectedItem(this.contact.getDisplayName());
        this.cmbNamePrefix.setSelectedItem(this.contact.getNamePrefix());
        this.cmbNameSufix.setSelectedItem(this.contact.getNameSuffix());
        this.tfOfficePhone.setText(this.contact.getOfficePhone());
        this.tfHomePhone.setText(this.contact.getHomePhone());
        this.tfMobilPhone.setText(this.contact.getMobilePhone());
        this.tfPager.setText(this.contact.getPager());
        this.tfFax.setText(this.contact.getFax());
        this.emailsTableModel.setEmails(this.contact.getEmailAddresses());
        this.emailsTableModel.setDefaultEmail(this.contact.getEmailAddress());
        this.imAddressesModel.setIMAddresses(this.contact.getImAddresses());
        this.selectDefaultPhone();
        this.addPropertiesChangeListener();
        return true;
    }

    private void selectDefaultPhone() {
        String defaultPhone = this.contact.getDefaultPhone();
        if (defaultPhone.equals(this.contact.getOfficePhone())) {
            this.rbOfficePhone.setSelected(true);
        } else if (defaultPhone.equals(this.contact.getHomePhone())) {
            this.rbHomePhone.setSelected(true);
        } else if (defaultPhone.equals(this.contact.getMobilePhone())) {
            this.rbMobilPhone.setSelected(true);
        } else if (defaultPhone.equals(this.contact.getPager())) {
            this.rbPager.setSelected(true);
        } else if (defaultPhone.equals(this.contact.getFax())) {
            this.rbFax.setSelected(true);
        }
    }

    private String getDefaultPhone() {
        if (this.rbOfficePhone.isSelected()) {
            return this.tfOfficePhone.getText();
        }
        if (this.rbHomePhone.isSelected()) {
            return this.tfHomePhone.getText();
        }
        if (this.rbMobilPhone.isSelected()) {
            return this.tfMobilPhone.getText();
        }
        if (this.rbPager.isSelected()) {
            return this.tfPager.getText();
        }
        return this.tfFax.getText();
    }

    public boolean saveProperties() {
        this.actionAddEmail.actionPerformed(null);
        this.actionAddIM.actionPerformed(null);
        this.contact.setFirstName(this.tfFirstName.getText());
        this.contact.setMiddleName(this.tfMidleName.getText());
        this.contact.setLastName(this.tfLastName.getText());
        Object selectedItem = this.cmbNamePrefix.getSelectedItem();
        String namePrefix = selectedItem.toString();
        this.contact.setNamePrefix(namePrefix);
        selectedItem = this.cmbNameSufix.getSelectedItem();
        String nameSuffix = selectedItem.toString();
        this.contact.setNameSuffix(nameSuffix);
        String displayName = this.cmbDisplayName.getSelectedItem().toString();
        if (displayName.equals(ENTER_NAME) || displayName.trim().length() == 0) {
            displayName = this.displayNameModel.getSize() > 1 ? this.displayNameModel.getElementAt(0).toString() : "";
        }
        this.contact.setDisplayName(displayName);
        this.contact.setOfficePhone(this.tfOfficePhone.getText());
        this.contact.setHomePhone(this.tfHomePhone.getText());
        this.contact.setMobilePhone(this.tfMobilPhone.getText());
        this.contact.setPager(this.tfPager.getText());
        this.contact.setFax(this.tfFax.getText());
        this.contact.setDefaultPhone(this.getDefaultPhone());
        this.contact.setEmailAddresses(this.emailsTableModel.getValues());
        this.contact.setEmailAddress(this.emailsTableModel.getDefaultEmail());
        this.contact.setImAddresses(this.imAddressesModel.getValues());
        this.imAddressesModel.setIMAddresses(this.contact.getImAddresses());
        this.selectDefaultPhone();
        return true;
    }

    public JComponent getDefaultComponent() {
        return this.tfFirstName;
    }

    private static class CPBorder
    implements Border {
        private Border border;
        private Insets insets = new Insets(0, 0, 0, 0);

        public CPBorder(Border border) {
            this.border = border;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.border.paintBorder(c, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c) {
            Insets bI = this.border.getBorderInsets(c);
            this.insets.top = bI.top;
            this.insets.left = bI.left;
            this.insets.bottom = bI.bottom;
            this.insets.right = bI.right + 1;
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return this.border.isBorderOpaque();
        }
    }

    private class CPModel
    extends DefaultComboBoxModel {
        private String displayNameFirstLast;
        private String displayNameLastFirst;

        private CPModel() {
            this.displayNameFirstLast = ContactPane.this.getDisplayName(FIRST);
            this.displayNameLastFirst = ContactPane.this.getDisplayName(SECOND);
        }

        public void setSelectedItem(Object anObject) {
            super.setSelectedItem(anObject);
            this.refreshDisplayNames();
        }

        public void refreshDisplayNames() {
            String nameFirstLast = "";
            String nameLastFirst = "";
            if (!ContactPane.this.tfFirstName.getText().equals("")) {
                nameFirstLast = ContactPane.this.getDisplayName(FIRST);
            }
            if (!ContactPane.this.tfLastName.getText().equals("")) {
                nameLastFirst = ContactPane.this.getDisplayName(SECOND);
            }
            this.displayNameFirstLast = nameFirstLast;
            this.displayNameLastFirst = nameLastFirst;
        }

        public Object getElementAt(int index) {
            if (this.getSize() == 1) {
                return super.getElementAt(index);
            }
            if (this.getSize() == 2) {
                String displayName = "";
                if (ContactPane.this.tfFirstName.getText().equals("")) {
                    displayName = this.displayNameLastFirst;
                }
                if (ContactPane.this.tfLastName.getText().equals("")) {
                    displayName = this.displayNameFirstLast;
                }
                switch (index) {
                    case 0: {
                        return displayName;
                    }
                }
                return super.getElementAt(index);
            }
            switch (index) {
                case 0: {
                    return this.displayNameFirstLast;
                }
                case 1: {
                    return this.displayNameLastFirst;
                }
            }
            return super.getElementAt(index);
        }
    }

    private static class RemoveElementFromTableAction
    extends AbstractAction {
        private JTable table;
        private MutableTableModel tableModel;

        public RemoveElementFromTableAction(JTable theTable, MutableTableModel tableModel) {
            super(StringResources.REMOVE);
            this.table = theTable;
            this.tableModel = tableModel;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.tableModel.removeElementAt(this.table.getSelectedRow());
        }
    }

    private static class MyTableCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        JTextField tf;
        private boolean isCellEditable;

        public boolean isCellEditable(EventObject anEvent) {
            return this.isCellEditable;
        }

        public void setCellEditable(boolean cellEditable) {
            this.isCellEditable = cellEditable;
        }

        public MyTableCellEditor(JTextField tf) {
            super(tf);
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                tf.setBorder(BorderFactory.createEmptyBorder());
            } else if (OS.isNimbusLAF()) {
                tf.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            }
            this.tf = tf;
            this.tf.setComponentOrientation(UIUtils.getComponentOrientation());
            tf.addFocusListener(this);
            this.addCellEditorListener(new CellEditorListener(){

                public void editingStopped(ChangeEvent e) {
                    MyTableCellEditor.this.isCellEditable = false;
                }

                public void editingCanceled(ChangeEvent e) {
                    MyTableCellEditor.this.isCellEditable = false;
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf.setText(value.toString());
            this.tf.setCaretPosition(0);
            this.tf.selectAll();
            return this.tf;
        }

        public void focusGained(FocusEvent e) {
            this.tf.selectAll();
        }

        public void focusLost(FocusEvent e) {
            this.stopCellEditing();
        }
    }

    private static class EditTableElementAction
    extends AbstractAction {
        private JTable table;

        public EditTableElementAction(JTable theTable) {
            super(StringResources.EDIT);
            this.table = theTable;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            MyTableCellEditor cellEditor = (MyTableCellEditor)this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).getCellEditor();
            cellEditor.setCellEditable(true);
            this.table.editCellAt(this.table.getSelectedRow(), this.table.getColumnCount() - 1);
            this.table.repaint();
            cellEditor.tf.requestFocus();
        }
    }

    private static class AddElementToTableAction
    extends AbstractAction {
        private JTextField tfElement;
        private MutableTableModel tableModel;
        private JTable table;

        public AddElementToTableAction(JTextField tfElement, MutableTableModel tableModel, JTable theTable, String caption) {
            super(caption);
            this.tfElement = tfElement;
            this.tableModel = tableModel;
            this.table = theTable;
        }

        public void actionPerformed(ActionEvent e) {
            String element = this.tfElement.getText().trim();
            if (element.length() != 0) {
                this.tableModel.addElement(element);
                this.tfElement.setText("");
                int index = this.table.getRowCount() - 1;
                this.table.scrollRectToVisible(new Rectangle(0, this.table.getRowHeight() * index, 1, this.table.getRowHeight()));
            }
        }
    }

    private static interface MutableTableModel {
        public void addElement(String var1);

        public void removeElementAt(int var1);

        public String[] getValues();
    }

    private static class ImAddressesModel
    extends AbstractTableModel
    implements MutableTableModel {
        private List<String> imAddresses = new ArrayList<String>();

        public ImAddressesModel() {
        }

        public ImAddressesModel(String[] theImAddresses) {
            this.imAddresses.addAll(Arrays.asList(theImAddresses));
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public int getRowCount() {
            return this.imAddresses.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.imAddresses.set(rowIndex, (String)aValue);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.imAddresses.get(rowIndex);
        }

        public void addElement(String theElement) {
            this.imAddresses.add(theElement);
            this.fireTableDataChanged();
        }

        public void removeElementAt(int theIndex) {
            this.imAddresses.remove(theIndex);
            this.fireTableRowsDeleted(theIndex, theIndex);
        }

        public String[] getValues() {
            String[] result = new String[this.imAddresses.size()];
            int nSize = this.imAddresses.size();
            for (int i = 0; i < nSize; ++i) {
                result[i] = this.imAddresses.get(i);
            }
            return result;
        }

        public void setIMAddresses(String[] theEmails) {
            this.imAddresses.addAll(Arrays.asList(theEmails));
            this.fireTableDataChanged();
        }
    }

    private static class EmailsTableModel
    extends AbstractTableModel
    implements MutableTableModel {
        private List<String> emails = new ArrayList<String>();
        private String defaultEmail;

        public EmailsTableModel() {
        }

        public EmailsTableModel(String[] emails, String theDefaultEmail) {
            this.emails.addAll(Arrays.asList(emails));
            this.defaultEmail = theDefaultEmail;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public int getRowCount() {
            return this.emails.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                String email = this.emails.get(rowIndex);
                if (!email.equals(this.defaultEmail)) {
                    this.defaultEmail = email;
                    this.fireTableDataChanged();
                }
            } else {
                if (this.getValueAt(rowIndex, 0).equals(Boolean.TRUE)) {
                    this.defaultEmail = (String)aValue;
                }
                this.emails.set(rowIndex, (String)aValue);
            }
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (this.emails.get(rowIndex).equals(this.defaultEmail)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return this.emails.get(rowIndex);
        }

        public void setEmails(String[] theEmails) {
            this.emails.addAll(Arrays.asList(theEmails));
            this.fireTableDataChanged();
        }

        public String getItemAt(int index) {
            return this.emails.get(index);
        }

        public String[] getValues() {
            String[] result = new String[this.emails.size()];
            int nSize = this.emails.size();
            for (int i = 0; i < nSize; ++i) {
                result[i] = this.emails.get(i);
            }
            return result;
        }

        public String getDefaultEmail() {
            return this.defaultEmail;
        }

        public void setDefaultEmail(String defaultEmail) {
            this.defaultEmail = defaultEmail;
            this.fireTableDataChanged();
        }

        public void addElement(String theElement) {
            this.emails.add(theElement);
            int size = this.emails.size();
            if (size == 1) {
                this.defaultEmail = theElement;
            }
            this.fireTableRowsInserted(size - 1, size - 1);
        }

        public void removeElementAt(int theIndex) {
            String remove = this.emails.get(theIndex);
            this.emails.remove(theIndex);
            if (this.defaultEmail.equals(remove)) {
                this.defaultEmail = !this.emails.isEmpty() ? this.emails.get(0) : "";
            }
            this.fireTableRowsDeleted(theIndex, theIndex);
        }
    }

    private class AddButtonsEnabledAction
    implements DocumentListener {
        private JTextField textField;
        private JMnemonicButton addButton;

        public AddButtonsEnabledAction(JTextField textField, JMnemonicButton addButton) {
            this.textField = textField;
            this.addButton = addButton;
        }

        public void insertUpdate(DocumentEvent event) {
            this.action();
        }

        public void removeUpdate(DocumentEvent event) {
            this.action();
        }

        public void changedUpdate(DocumentEvent event) {
        }

        private void action() {
            if (this.textField.getText().equals("")) {
                this.addButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(true);
            }
        }
    }

    private class DNDocumentListener
    implements DocumentListener {
        private DNDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            ContactPane.this.updateDisplayName();
        }

        public void removeUpdate(DocumentEvent e) {
            ContactPane.this.updateDisplayName();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

