/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class MembersListRenderer
implements ListCellRenderer {
    private JLabel lbTo = new OrientableLabel(StringResources.TO_C);
    private JLabel lbCc = new OrientableLabel(StringResources.CC_C);
    private JLabel lbBc = new OrientableLabel(StringResources.BC_C);
    private int titleWidth;
    private JLabel lbLeft;
    private JPanel pnlItem;
    private JLabel lbRight;

    public MembersListRenderer() {
        this.titleWidth = Math.max(Math.max(this.lbTo.getPreferredSize().width, this.lbCc.getPreferredSize().width), this.lbBc.getPreferredSize().width) + 5;
        this.lbLeft = new OrientableLabel();
        this.pnlItem = new JPanel(new GridBagLayout());
        this.lbRight = new OrientableLabel();
        this.pnlItem.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        ComponentOrientation co = UIUtils.getComponentOrientation();
        this.pnlItem.setComponentOrientation(co);
        this.lbLeft.setComponentOrientation(co);
        this.lbRight.setComponentOrientation(co);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        IRecipient recipient = (IRecipient)value;
        this.setTitle(recipient);
        this.lbLeft.setPreferredSize(new Dimension(this.titleWidth, this.lbLeft.getPreferredSize().height));
        this.setText(recipient);
        this.setIcon(recipient);
        this.pnlItem.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.fill = 0;
        this.pnlItem.add((Component)this.lbLeft, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        this.pnlItem.add((Component)this.lbRight, constraints);
        if (isSelected) {
            this.pnlItem.setBackground(list.getSelectionBackground());
            this.pnlItem.setForeground(list.getSelectionForeground());
        } else {
            this.pnlItem.setBackground(list.getBackground());
            this.pnlItem.setForeground(list.getForeground());
        }
        return this.pnlItem;
    }

    private void setTitle(IRecipient recipient) {
        if (recipient.getCopyType().hasTo()) {
            this.lbLeft.setText(StringResources.TO_C);
        } else if (recipient.getCopyType().hasCc()) {
            this.lbLeft.setText(StringResources.CC_C);
        } else if (recipient.getCopyType().hasBc()) {
            this.lbLeft.setText(StringResources.BC_C);
        }
    }

    private void setText(IRecipient value) {
        IAddressable address = value.getAddressable();
        this.lbRight.setText(address.getDisplayName());
    }

    private void setIcon(IRecipient value) {
        IAddressable recipient = value.getAddressable();
        this.lbRight.setIcon(ABUtils.getIcon(recipient));
    }
}

