/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.ApplicationFrame;
import com.appframework.components.EmptyStringDocumentListener;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class NewDirectoryDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(NewDirectoryDialog.class);
    private JTextField tfDirectoryName = new GWTextField();

    public NewDirectoryDialog(ApplicationFrame theOwner) throws HeadlessException {
        super(theOwner);
        this.setTitle(StringResources.CREATE_NEW_ADDRESS_BOOK);
        this.buildUI();
    }

    private void buildUI() {
        this.btnOK = new JButton(new OkAction());
        this.setDefaultButton(this.btnOK);
        this.tfDirectoryName.getDocument().addDocumentListener(new EmptyStringDocumentListener(this.btnOK.getAction()));
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(pnlContent);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setRowCount(2);
        gridBagAdapter.setInsets(new Insets(10, 5, 10, 5));
        gridBagAdapter.setFill(0);
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.addComponent(new JMnemonicLabel(StringResources.CREATE_ADDRESS_BOOK_C, this.tfDirectoryName));
        gridBagAdapter.setWidthX(1);
        gridBagAdapter.setFill(2);
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.addComponent(this.tfDirectoryName);
        gridBagAdapter.setWidthY(1);
        gridBagAdapter.addComponent(new OrientableLabel());
        this.getContentPane().add((Component)pnlContent, "Center");
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        gridBagAdapter = new GridBagAdapter(pnlButtons);
        gridBagAdapter.setColumnCount(1);
        gridBagAdapter.setRowCount(2);
        gridBagAdapter.setInsets(new Insets(10, 5, 10, 5));
        gridBagAdapter.addComponent(this.btnOK);
        gridBagAdapter.addComponent(this.btnCancel);
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)pnlButtons, "North");
        this.getContentPane().setComponentOrientation(UIUtils.getComponentOrientation());
        this.getContentPane().add((Component)pnlTemp, "After");
    }

    public String getDirectoryName() {
        return this.tfDirectoryName.getText();
    }

    private boolean createAddressBook() {
        String name = this.tfDirectoryName.getText();
        try {
            EngineCommandManager.createAddressBook(name);
            return true;
        }
        catch (EngineException ex) {
            if (ex.getErrorCode() == 59154) {
                JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.AN_ADDRESS_BOOK_ALREADY_EXIST, name), StringResources.ADDRESS_BOOK_ERROR, -1);
                this.tfDirectoryName.selectAll();
            } else {
                logger.error((Object)ex, (Throwable)ex);
            }
            return false;
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (NewDirectoryDialog.this.createAddressBook()) {
                NewDirectoryDialog.this.setVisible(false);
            }
        }
    }
}

