/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IOrganizationContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsPane;
import com.novell.gw.jclient.application.controls.contactsearch.FilteredContactSearchTextField;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

class OfficePane
extends UserContactDetailsPane {
    private static Logger logger = Logger.getLogger(OfficePane.class);
    private IOrganizationContact organization;
    private JTextField tfState = new GWTextField();
    private JTextField tfCountry = new GWTextField();
    private JTextField tfTitle = new GWTextField();
    private JTextField tfDepartment = new GWTextField();
    private FilteredContactSearchTextField tfOrganization;
    private JTextField tfMailStop = new GWTextField();
    private JTextField tfCity = new GWTextField();
    private JTextField tfZip = new GWTextField();
    private JTextField tfWebSite = new GWTextField("http://");
    private JTextArea taAddress = new GWTextArea(4, 1);
    private JButton btnWebSite = new JButton(new ContactDetailsPane.LaunchWebSiteAction(this.tfWebSite, this));
    private AbstractAddressBook addressBook;

    public OfficePane(IUserContact theContact, AbstractAddressBook addressBook) {
        super(theContact);
        this.tfTitle.setName("OfiicePane_tfTitle");
        this.tfDepartment.setName("OfiicePane_tfDepartment");
        this.tfState.setName("OfiicePane_tfState");
        this.tfCountry.setName("OfiicePane_tfCountry");
        this.tfMailStop.setName("OfiicePane_tfMailStop");
        this.tfCity.setName("OfiicePane_tfCity");
        this.tfZip.setName("OfiicePane_tfZip");
        this.tfWebSite.setName("OfiicePane_tfWebSite");
        this.taAddress.setName("OfiicePane_taAddress");
        this.addressBook = addressBook;
        this.tfOrganization = new FilteredContactSearchTextField(ContactType.ORGANIZATION);
        this.tfOrganization.setName("OfiicePane_tfOrganization");
        this.setName(StringResources.OFFICE);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createTitledBorder(StringResources.OFFICE));
        ComponentOrientation co = UIUtils.getComponentOrientation();
        this.setComponentOrientation(co);
        this.taAddress.setComponentOrientation(co);
    }

    private void addPropertiesChangeListener() {
        if (!this.isReadOnly) {
            this.taAddress.addKeyListener(this.getPropertiesChangeListener());
            this.tfCity.addKeyListener(this.getPropertiesChangeListener());
            this.tfCountry.addKeyListener(this.getPropertiesChangeListener());
            this.tfDepartment.addKeyListener(this.getPropertiesChangeListener());
            this.tfMailStop.addKeyListener(this.getPropertiesChangeListener());
            this.tfOrganization.addKeyListener(this.getPropertiesChangeListener());
            this.tfState.addKeyListener(this.getPropertiesChangeListener());
            this.tfTitle.addKeyListener(this.getPropertiesChangeListener());
            this.tfWebSite.addKeyListener(this.getPropertiesChangeListener());
            this.tfZip.addKeyListener(this.getPropertiesChangeListener());
        }
    }

    private void buildUI() {
        int width = this.btnWebSite.getIcon().getIconWidth() + 8;
        this.btnWebSite.setPreferredSize(new Dimension(width, this.tfCountry.getPreferredSize().height));
        TitleValueContainer container = new TitleValueContainer(this);
        container.buildRow(new JMnemonicLabel(StringResources.TITLE_C, this.tfTitle), this.tfTitle, 0);
        container.buildRow(new JMnemonicLabel(StringResources.DEPARTMENT_C, this.tfDepartment), this.tfDepartment, 1);
        container.buildRow(new OrientableLabel(StringResources.ORGANIZATION_C), this.tfOrganization, 2);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 3, 5, 5);
        constraints.fill = 0;
        constraints.gridy = 3;
        this.add((Component)new JMnemonicLabel(StringResources.ADDRESS_C, this.taAddress), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 3;
        this.add((Component)new OrientableScrollPane(this.taAddress), constraints);
        constraints.gridwidth = 1;
        container.buildRow(new JMnemonicLabel(StringResources.MAIL_STOP_C, this.tfMailStop), this.tfMailStop, 4);
        container.buildRow(new JMnemonicLabel(StringResources.CITY_C, this.tfCity), this.tfCity, 5);
        container.buildRow(new JMnemonicLabel(StringResources.STATE_PROVINCE_C, this.tfState), this.tfState, new JMnemonicLabel(StringResources.ZIP_POSTAL_CODE_C, this.tfZip), this.tfZip, 6);
        container.buildRow(new JMnemonicLabel(StringResources.COUNTRY_C, this.tfCountry), this.tfCountry, new OrientableLabel(), new OrientableLabel(), 7);
        container.buildRow((JComponent)new JMnemonicLabel(StringResources.WEB_SITE_C, this.tfWebSite), (JComponent)this.tfWebSite, this.btnWebSite, 8);
        constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridy = 9;
        constraints.gridx = 1;
        this.add((Component)new OrientableLabel(), constraints);
        this.tfCountry.setSize(this.tfState.getSize());
    }

    public boolean loadProperties() {
        this.tfState.setText(this.contact.getOfficeState());
        this.tfCountry.setText(this.contact.getOfficeCountry());
        this.tfTitle.setText(this.contact.getTitle());
        this.tfDepartment.setText(this.contact.getDepartment());
        this.organization = this.contact.getOrganization();
        this.tfOrganization.setInitialValue(this.contact.getOrganization());
        this.tfMailStop.setText(this.contact.getOfficeLocation());
        this.tfCity.setText(this.contact.getOfficeCity());
        this.tfZip.setText(this.contact.getOfficePostalCode());
        this.tfWebSite.setText(this.contact.getOfficeWebsite());
        this.taAddress.setText(this.contact.getOfficeStreetAddress());
        this.addPropertiesChangeListener();
        return true;
    }

    public boolean saveProperties() {
        IContact foundContact = this.tfOrganization.getContact();
        String text = this.tfOrganization.getText();
        if (foundContact == null && !text.equals("")) {
            foundContact = GWEngineUtils.createContact((PersonalAddressBook)this.addressBook, ContactType.ORGANIZATION);
            foundContact.setDisplayName(this.tfOrganization.getText());
        }
        if (foundContact != null) {
            this.organization = (IOrganizationContact)foundContact;
            try {
                this.organization.save(0);
            }
            catch (EngineException e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else {
            this.organization = null;
        }
        return this.contact.setOfficeState(this.tfState.getText()) & this.contact.setOfficeCountry(this.tfCountry.getText()) & this.contact.setTitle(this.tfTitle.getText()) & this.contact.setDepartment(this.tfDepartment.getText()) & this.contact.setOrganization(this.organization) & this.contact.setOfficeLocation(this.tfMailStop.getText()) & this.contact.setOfficeCity(this.tfCity.getText()) & this.contact.setOfficePostalCode(this.tfZip.getText()) & this.contact.setOfficeWebsite(this.tfWebSite.getText()) & this.contact.setOfficeStreetAddress(this.taAddress.getText());
    }

    public JComponent getDefaultComponent() {
        return this.tfTitle;
    }
}

