/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IResourceContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.contactsearch.FilteredContactSearchTextField;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

class ResourceDetailsPane
extends ContactDetailsPane {
    private static Logger logger = Logger.getLogger(ResourceDetailsPane.class);
    private IResourceContact contact;
    private IUserContact owner;
    private JTextComponent tfName = new GWTextField();
    private JTextField tfPhone = new GWTextField();
    private JTextField tfType = new GWTextField();
    private JTextField tfEmailAddress = new GWTextField();
    private FilteredContactSearchTextField tfOwner;
    private JTextArea taComments = new GWTextArea(4, 1);
    private AbstractAddressBook addressBook;

    public ResourceDetailsPane(IResourceContact contact, AbstractAddressBook addressBook) {
        this.tfName.setName("ResourceDetailsPane_tfName");
        this.tfPhone.setName("ResourceDetailsPane_tfPhone");
        this.tfType.setName("ResourceDetailsPane_tfType");
        this.tfEmailAddress.setName("ResourceDetailsPane_tfEmailAddress");
        this.taComments.setName("ResourceDetailsPane_taComments");
        this.addressBook = addressBook;
        this.contact = contact;
        this.tfOwner = new FilteredContactSearchTextField(ContactType.USER);
        this.tfOwner.setName("ResourceDetailsPane_tfOwner");
        this.setName(StringResources.DETAILS);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (!this.contact.isReadOnly()) {
            this.taComments.addKeyListener(this.getPropertiesChangeListener());
        }
    }

    private void addPropertiesChangeListener() {
        if (!this.contact.isReadOnly()) {
            this.taComments.addKeyListener(this.getPropertiesChangeListener());
            this.tfEmailAddress.addKeyListener(this.getPropertiesChangeListener());
            this.tfName.addKeyListener(this.getPropertiesChangeListener());
            this.tfOwner.addKeyListener(this.getPropertiesChangeListener());
            this.tfPhone.addKeyListener(this.getPropertiesChangeListener());
            this.tfType.addKeyListener(this.getPropertiesChangeListener());
        }
    }

    private void buildUI() {
        TitleValueContainer container = new TitleValueContainer(this);
        container.buildRow(new JMnemonicLabel(StringResources.NAME_C, this.tfName), this.tfName, 0);
        container.buildRow(new JMnemonicLabel(StringResources.PHONE_C, this.tfPhone), this.tfPhone, 1);
        container.buildRow(new JMnemonicLabel(StringResources.TYPE_C, this.tfType), this.tfType, 2);
        container.buildRow(new JMnemonicLabel(StringResources.EMAIL_ADDRESS_C, this.tfEmailAddress), this.tfEmailAddress, 3);
        container.buildRow(new JMnemonicLabel(StringResources.OWNER_C, this.tfOwner), this.tfOwner, 4);
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.taComments);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(280, 180));
        container.buildRow((JComponent)new JMnemonicLabel(StringResources.COMMENTS_C, this.taComments), (JComponent)scrollPane, 5, true);
    }

    public boolean loadProperties() {
        this.owner = this.contact.getOwner();
        this.tfName.setText(this.contact.getDisplayName());
        this.tfPhone.setText(this.contact.getPhone());
        this.tfType.setText(this.contact.getResourceType());
        this.tfEmailAddress.setText(this.contact.getEmailAddress());
        this.tfOwner.setInitialValue(this.owner);
        this.taComments.setText(this.contact.getComments());
        this.addPropertiesChangeListener();
        return true;
    }

    public boolean saveProperties() {
        if (this.isChangedProperties()) {
            boolean needSaveUserContact = false;
            IContact foundContact = this.tfOwner.getContact();
            String text = this.tfOwner.getText();
            if (foundContact == null && !((foundContact = ContactUtils.findContactByName(text, this.addressBook.getNativeAddressBook())) instanceof IUserContact)) {
                foundContact = null;
            }
            if (foundContact == null && !text.equals("")) {
                foundContact = GWEngineUtils.createContact((PersonalAddressBook)this.addressBook, ContactType.USER);
                foundContact.setDisplayName(text);
                needSaveUserContact = true;
            }
            if (foundContact != null) {
                this.owner = (IUserContact)foundContact;
                if (needSaveUserContact) {
                    try {
                        this.owner.save(0);
                    }
                    catch (EngineException e) {
                        this.owner = null;
                        if (e.getErrorCode() != 59154 && e.getErrorCode() != 59142) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                }
            } else {
                this.owner = null;
            }
            return this.contact.setDisplayName(this.tfName.getText()) & this.contact.setPhone(this.tfPhone.getText()) & this.contact.setResourceType(this.tfType.getText()) & this.contact.setEmailAddress(this.tfEmailAddress.getText()) & this.contact.setOwner(this.owner) & this.contact.setComments(this.taComments.getText());
        }
        return false;
    }

    public JComponent getDefaultComponent() {
        return this.tfName;
    }
}

