/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.list;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.list.RLPopupMenu;
import com.novell.gw.jclient.application.controls.addressbook.list.RecipientsListController;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.impl.SelectedContactsInfoImpl;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientsList
extends OrientableList
implements MVCView {
    private boolean isDragging = false;
    private static Logger logger = Logger.getLogger(RecipientsList.class);
    private RecipientsListController controller;
    protected DefaultListModel model;

    public RecipientsList(MVCController theParentController) {
        this.controller = new RecipientsListController(this, theParentController);
        this.model = new DefaultListModel();
        this.setModel(this.model);
        this.addMouseListener(new MouseListener());
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RecipientsList.this.updateActionsModel();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (e.getKeyCode() == itemDeleteKey) {
                    RecipientsList.this.getController().getActionList().performAction(ActionKey.REMOVE_ENTRY_FROM_RECIPIENTS_LIST);
                }
                super.keyPressed(e);
            }
        });
        this.setTransferHandler(new RecipientsTransferHandler());
        this.setDragEnabled(true);
    }

    private void handleMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.isDragging = false;
        } else if (e.getID() == 506) {
            this.isDragging = true;
        } else if (e.getID() == 502) {
            this.isDragging = false;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this.handleMouseEvent(e);
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this.handleMouseEvent(e);
        super.processMouseMotionEvent(e);
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        if (this.isDragging) {
            return new DnDListSelectionModelProxy(super.getSelectionModel());
        }
        return super.getSelectionModel();
    }

    public void updateList(IContact contact) {
        if (contact == null) {
            return;
        }
        logger.debug((Object)("Updated Contact# id: " + contact.getId() + ", name: " + contact.getDisplayName()));
        IRecipient[] selectedEntries = (IRecipient[])Utils.castArray(this.getRecipientList().toArray(), IRecipient[].class);
        ArrayList<IRecipient> updatedRecipients = new ArrayList<IRecipient>();
        for (IRecipient r : selectedEntries) {
            if (!(r.getAddressable() instanceof IContact)) continue;
            if (((IContact)r.getAddressable()).getId() == contact.getId()) {
                updatedRecipients.add(APIAbWrapperManager.createRecipient(contact, RecipientCopyType.getDefault()));
                continue;
            }
            updatedRecipients.add(r);
        }
        this.setMVCModel(updatedRecipients);
    }

    private void updateActionsModel() {
        IRecipient[] selectedEntries = (IRecipient[])Utils.castArray(this.getSelectedValues(), IRecipient[].class);
        ActionList actionList = this.getController().getActionList();
        if (selectedEntries.length > 0) {
            actionList.getAction(ActionKey.REMOVE_ENTRY_FROM_RECIPIENTS_LIST).setEnabled(true);
            actionList.getAction(ActionKey.REMOVE_ENTRY_FROM_RECIPIENTS_LIST).setMVCModel(Arrays.asList(selectedEntries));
            ArrayList<IAddressable> addressables = new ArrayList<IAddressable>(selectedEntries.length);
            for (IRecipient o : selectedEntries) {
                addressables.add(o.getAddressable());
            }
            Command command = new Command(240, new SelectedContactsInfoImpl(null, addressables));
            this.getController().processCommand(command);
        } else {
            actionList.getAction(ActionKey.REMOVE_ENTRY_FROM_RECIPIENTS_LIST).setEnabled(false);
        }
    }

    public List<IRecipient> getRecipientList() {
        return Arrays.asList(Utils.castArray(this.model.toArray(), IRecipient[].class));
    }

    public void removeRecipients(List theRecipients) {
        int index = this.getMaxSelectionIndex();
        int nCount = theRecipients.size();
        for (int i = 0; i < nCount; ++i) {
            this.model.removeElement(theRecipients.get(i));
        }
        if (this.getModel().getSize() == 0) {
            this.getController().processCommand(new Command(250, null));
        } else if (index != -1) {
            this.selectNearestIndex(index);
        }
    }

    public void setController(MVCController theController) {
        if (!(theController instanceof RecipientsListController)) {
            throw new IllegalArgumentException();
        }
        this.controller = (RecipientsListController)theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    private int getRecipientsCountByCopyType(RecipientCopyType theCopyType) {
        int count = 0;
        for (int i = 0; i < this.model.size(); ++i) {
            IRecipient recipient = (IRecipient)this.model.get(i);
            if (!recipient.getCopyType().hasRecipientCopyType(theCopyType)) continue;
            ++count;
        }
        return count;
    }

    private void addRecipient(IRecipient theRecipient) {
        int index = this.getRecipientsCountByCopyType(RecipientCopyType.getTo());
        RecipientCopyType copyType = theRecipient.getCopyType();
        if (copyType.hasCc()) {
            index += this.getRecipientsCountByCopyType(RecipientCopyType.getCc());
        } else if (copyType.hasBc()) {
            index = this.model.getSize();
        }
        this.model.add(index, theRecipient);
        this.clearSelection();
    }

    private boolean removeRecipient(IRecipient recipientToRemove) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            IRecipient recipient = (IRecipient)this.model.getElementAt(i);
            IAddressable addressableToRemove = recipientToRemove.getAddressable();
            IAddressable addressable = recipient.getAddressable();
            if (!(addressableToRemove instanceof IContact && addressable instanceof IContact ? addressable.equals(addressableToRemove) && this.model.removeElement(recipient) : recipientToRemove.isSameAddress(recipient.getAddressable()) && this.model.removeElement(recipient))) continue;
            return true;
        }
        return false;
    }

    private void selectNearestIndex(int index) {
        int size = this.getModel().getSize();
        if (size == 0) {
            return;
        }
        int selectionIndex = index >= size ? size - 1 : index;
        this.setSelectedIndex(selectionIndex);
    }

    public void setMVCModel(Object model) {
        if (model instanceof List) {
            List recipients = (List)model;
            int nSize = recipients.size();
            for (int i = 0; i < nSize; ++i) {
                IRecipient recipient = (IRecipient)recipients.get(i);
                this.removeRecipient(recipient);
                this.addRecipient(recipient);
            }
            if (this.model.getSize() > 0) {
                this.getController().processCommand(new Command(260, new ArrayList(Arrays.asList(Utils.castArray(this.model.toArray(), IRecipient[].class)))));
            }
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private class DnDListSelectionModelProxy
    implements ListSelectionModel {
        private ListSelectionModel model;

        public DnDListSelectionModelProxy(ListSelectionModel theModel) {
            this.model = theModel;
        }

        public void setSelectionInterval(int index0, int index1) {
            if (!RecipientsList.this.isDragging) {
                this.model.setSelectionInterval(index0, index1);
            }
        }

        public void addSelectionInterval(int index0, int index1) {
            if (!RecipientsList.this.isDragging) {
                this.model.addSelectionInterval(index0, index1);
            }
        }

        public void removeSelectionInterval(int index0, int index1) {
            if (!RecipientsList.this.isDragging) {
                this.model.removeSelectionInterval(index0, index1);
            }
        }

        public int getMinSelectionIndex() {
            return this.model.getMinSelectionIndex();
        }

        public int getMaxSelectionIndex() {
            return this.model.getMaxSelectionIndex();
        }

        public boolean isSelectedIndex(int index) {
            return this.model.isSelectedIndex(index);
        }

        public int getAnchorSelectionIndex() {
            return this.model.getAnchorSelectionIndex();
        }

        public void setAnchorSelectionIndex(int index) {
            if (!RecipientsList.this.isDragging) {
                this.model.setAnchorSelectionIndex(index);
            }
        }

        public int getLeadSelectionIndex() {
            return this.model.getLeadSelectionIndex();
        }

        public void setLeadSelectionIndex(int index) {
            if (!RecipientsList.this.isDragging) {
                this.model.setLeadSelectionIndex(index);
            }
        }

        public void clearSelection() {
            if (!RecipientsList.this.isDragging) {
                this.model.clearSelection();
            }
        }

        public boolean isSelectionEmpty() {
            return this.model.isSelectionEmpty();
        }

        public void insertIndexInterval(int index, int length, boolean before) {
            if (!RecipientsList.this.isDragging) {
                this.model.insertIndexInterval(index, length, before);
            }
        }

        public void removeIndexInterval(int index0, int index1) {
            if (!RecipientsList.this.isDragging) {
                this.model.removeIndexInterval(index0, index1);
            }
        }

        public void setValueIsAdjusting(boolean valueIsAdjusting) {
            if (!RecipientsList.this.isDragging) {
                this.model.setValueIsAdjusting(valueIsAdjusting);
            }
        }

        public boolean getValueIsAdjusting() {
            return this.model.getValueIsAdjusting();
        }

        public void setSelectionMode(int selectionMode) {
            if (!RecipientsList.this.isDragging) {
                this.model.setSelectionMode(selectionMode);
            }
        }

        public int getSelectionMode() {
            return this.model.getSelectionMode();
        }

        public void addListSelectionListener(ListSelectionListener x) {
            this.model.addListSelectionListener(x);
        }

        public void removeListSelectionListener(ListSelectionListener x) {
            this.model.removeListSelectionListener(x);
        }
    }

    private class RecipientsTransferHandler
    extends TransferHandler {
        private final Transferable transferableData;

        private RecipientsTransferHandler() {
            this.transferableData = new TransferableData();
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        protected Transferable createTransferable(JComponent c) {
            return this.transferableData;
        }

        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return Arrays.asList(transferFlavors).contains(GWFlavors.contactsFlavor);
        }

        public boolean importData(JComponent comp, Transferable t) {
            boolean successfulDrop = false;
            try {
                if (t.getTransferData(GWFlavors.contactsFlavor) instanceof IContact[]) {
                    IContact[] transferList = (IContact[])t.getTransferData(GWFlavors.contactsFlavor);
                    if (transferList != null && transferList.length > 0) {
                        ArrayList<IRecipient> recipients = new ArrayList<IRecipient>();
                        for (IContact addressable : transferList) {
                            recipients.add(APIAbWrapperManager.createRecipient(addressable, RecipientCopyType.getDefault()));
                        }
                        Command command = new Command(380, recipients);
                        RecipientsList.this.getController().processCommand(command);
                    }
                } else {
                    successfulDrop = true;
                }
            }
            catch (UnsupportedFlavorException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            return successfulDrop;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
            RecipientsList.this.setSelectionModel(new DefaultListSelectionModel());
        }
    }

    private class TransferableData
    implements Transferable {
        private DataFlavor[] dataFlavors = new DataFlavor[]{GWFlavors.recipientsFlavor};

        private TransferableData() {
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(this.dataFlavors).contains(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(GWFlavors.recipientsFlavor)) {
                Object[] selectedValues = RecipientsList.this.getSelectedValues();
                IRecipient[] recipients = new IRecipient[selectedValues.length];
                for (int index = 0; index < selectedValues.length; ++index) {
                    recipients[index] = (IRecipient)selectedValues[index];
                }
                return recipients;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private RLPopupMenu popupMenu;

        private MouseListener() {
            this.popupMenu = new RLPopupMenu(RecipientsList.this.getController().getActionList());
        }

        public void mouseClicked(MouseEvent e) {
            int index;
            if (OS.isDoubleClick(e) && (index = RecipientsList.this.locationToIndex(e.getPoint())) != -1 && RecipientsList.this.getCellBounds(index, index).contains(e.getPoint())) {
                RecipientsList.this.getController().getActionList().performAction(ActionKey.REMOVE_ENTRY_FROM_RECIPIENTS_LIST);
            }
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                RecipientsList.this.updateActionsModel();
                int index = RecipientsList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    if (RecipientsList.this.getSelectedIndices().length <= 1) {
                        RecipientsList.this.setSelectedIndex(index);
                    }
                    this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

