/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.properties;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public abstract class AbstractShareListTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(AbstractShareListTableModel.class);
    private MVCController ownerController;

    protected AbstractShareListTableModel(MVCController controller) {
        this.ownerController = controller;
    }

    private boolean isProxyMode() {
        return GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.ownerController)).isProxyDataStore();
    }

    public void addContact(IAddressable addressable) {
        if (addressable instanceof IUserContact) {
            IUserContact contact = (IUserContact)addressable;
            if (EngineCommandManager.getUserInfo().getID().equals(contact.getUserName()) && !this.isProxyMode()) {
                JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.YOU_CANNOT_SHARE_A_FOLDER_WITH_YOUR, addressable.getDisplayName()), StringResources.ADDRESS_BOOK_ERROR, 2);
                return;
            }
            this.addContactToShareList(contact);
        } else if (addressable instanceof IGroupContact) {
            this.addGroup((IGroupContact)addressable);
        } else {
            JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.THE_ADDRESS_BOOK_CANNOT_BE_SHARED_WITH, addressable.getDisplayName()), StringResources.ADDRESS_BOOK_ERROR, 2);
        }
    }

    private void addGroup(IGroupContact group) {
        int result = JOptionPane.showConfirmDialog(null, StringResources.formatString(StringResources.THE_GROUP_IS_BEING_EXPANDED, group.getDisplayName()), StringResources.ADDRESS_BOOK_QUESTION, 2);
        if (result != 0) {
            return;
        }
        try {
            IItemList members = group.getMembers();
            int nSize = members.getSize();
            for (int i = 0; i < nSize; ++i) {
                IContact contact = (IContact)members.getItemAt(i);
                this.addContact(contact);
            }
        }
        catch (EngineException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    protected abstract void addContactToShareList(IUserContact var1);
}

