/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.properties;

import com.appframework.mvc.MVCController;
import com.novell.gw.ab.AddressBookAccessRights;
import com.novell.gw.ab.AddressBookSharedEntry;
import com.novell.gw.ab.AddressBookSharedList;
import com.novell.gw.ab.Addressable;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.controls.addressbook.properties.AbstractShareListTableModel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

class ShareListTableModel
extends AbstractShareListTableModel {
    private static Logger logger = Logger.getLogger(ShareListTableModel.class);
    private AddressBookSharedList accessList = new AddressBookSharedList();
    public Vector columns = new Vector();

    public ShareListTableModel(AddressBookSharedList accessList, MVCController controller) {
        super(controller);
        this.columns.add(StringResources.NAME);
        this.columns.add(StringResources.STATUS);
        this.columns.add(StringResources.ACCESS);
        if (accessList != null) {
            this.accessList = accessList;
        }
        this.fireTableDataChanged();
    }

    protected void addContactToShareList(IUserContact contact) {
        AddressBookAccessRights accessRights = new AddressBookAccessRights(false);
        AddressBookSharedEntry addressBookSharedEntry = new AddressBookSharedEntry((Addressable)contact.getNativeContact(), accessRights);
        this.accessList.add(addressBookSharedEntry);
        int index = this.accessList.getSize() - 1;
        this.fireTableRowsInserted(index, index);
    }

    public void addContacts(List theUsers) {
        int nSize = theUsers.size();
        for (int i = 0; i < nSize; ++i) {
            this.addContact((IAddressable)theUsers.get(i));
        }
    }

    public void removeUser(int index) {
        this.accessList.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public String getColumnName(int column) {
        return (String)this.columns.get(column);
    }

    public int getRowCount() {
        return this.accessList.getSize();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    private static String getUserRights(AddressBookSharedEntry theEntry) {
        AddressBookAccessRights rights = theEntry.getAccessRights();
        String textRights = "";
        textRights = rights.hasAllAccess() ? StringResources.ALL : StringResources.READ_ONLY;
        return textRights;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String retValue;
        AddressBookSharedEntry accessEntry = this.accessList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                retValue = accessEntry.getName();
                break;
            }
            case 1: {
                retValue = accessEntry.getStatus();
                break;
            }
            case 2: {
                retValue = ShareListTableModel.getUserRights(accessEntry);
                break;
            }
            default: {
                retValue = "";
            }
        }
        return retValue;
    }

    public AddressBookSharedList getAccessList() {
        return this.accessList;
    }
}

