/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.table;

import com.novell.gw.jclient.application.GWTable;
import com.novell.gw.jclient.application.controls.addressbook.table.SortHeaderListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableHeader;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DraggableHeader
extends OrientableTableHeader {
    private boolean dragging = false;
    protected SortHeaderListener headerCallBack;

    public DraggableHeader(TableColumnModel model, SortHeaderListener sortable) {
        this.headerCallBack = sortable;
        this.addMouseListener(new SortHeaderMouseListener());
        this.addMouseMotionListener(new SortHeaderMouseMotionListener());
        this.setReorderingAllowed(true);
        this.setColumnModel(model);
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.setSize(new Dimension(preferredSize.width, GWTable.TABLE_DEFAULT_HEIGHT));
        return preferredSize;
    }

    public TableColumn getDraggedColumn() {
        if (this.draggedColumn != null && this.draggedColumn.getModelIndex() >= 0) {
            return this.draggedColumn;
        }
        return null;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        if (this.dragging != dragging) {
            this.dragging = dragging;
        }
    }

    private class SortHeaderMouseMotionListener
    extends MouseMotionAdapter {
        private SortHeaderMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            DraggableHeader.this.setDragging(true);
            int columnIndex = DraggableHeader.this.getTable().columnAtPoint(e.getPoint());
            DraggableHeader.this.headerCallBack.columnBeginDrag(columnIndex);
        }
    }

    private class SortHeaderMouseListener
    extends MouseAdapter {
        private SortHeaderMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            int columnIndex = DraggableHeader.this.getTable().columnAtPoint(p);
            if (DraggableHeader.this.isDragging()) {
                columnIndex = DraggableHeader.this.getTable().columnAtPoint(e.getPoint());
                DraggableHeader.this.headerCallBack.columnEndDrag(columnIndex);
            } else if (columnIndex != 0 && e.isPopupTrigger()) {
                DraggableHeader.this.headerCallBack.columnShowPopUpMenu(columnIndex, e);
            }
            DraggableHeader.this.setDragging(false);
        }

        public void mouseExited(MouseEvent e) {
            if (DraggableHeader.this.isDragging()) {
                DraggableHeader.this.dispatchEvent(new MouseEvent(DraggableHeader.this, 502, e.getWhen(), 0, e.getX(), e.getY(), 1, false));
            }
        }

        public void mouseReleased(MouseEvent e) {
            DraggableHeader.this.setDragging(false);
        }
    }
}

