/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.bl.impl.StreamHandler;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AttachmentSaver {
    private static Logger logger = Logger.getLogger(AttachmentSaver.class);
    HashMap objectsToSave = new HashMap();

    public void addToSave(String theObjectID, String theSavePath) {
        this.objectsToSave.put(theObjectID, theSavePath);
    }

    private boolean doSave(String theObjectID, String thePath) {
        if (this.objectsToSave.containsKey(theObjectID)) {
            String pathToSave = (String)this.objectsToSave.get(theObjectID);
            AttachmentSaver.callCopy(thePath, pathToSave);
            this.objectsToSave.remove(theObjectID);
            return true;
        }
        return false;
    }

    public void save(String thePath, String theSavePath) {
        AttachmentSaver.callCopy(thePath, theSavePath);
    }

    private static void callCopy(String thePath, String theSavePath) {
        logger.debug((Object)"callCopy entered");
        File file = new File(thePath);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(thePath);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            GWException e1 = new GWException();
            e1.setExplanation("Error while saving file : " + file.getName() + " download was not completed successfully.");
            ErrorDialog.processGWException(e1);
            return;
        }
        try {
            out = new FileOutputStream(theSavePath);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            GWException e1 = new GWException();
            e1.setExplanation("Error while saving file : " + file.getName() + " can not create/modify target file : " + theSavePath);
            ErrorDialog.processGWException(e1);
            logger.debug((Object)"callCopy exited");
            return;
        }
        try {
            StreamHandler.getInstance().copyStream(in, out);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            GWException e1 = new GWException();
            e1.setExplanation("Error while saving file : " + file.getName() + " Unexpected internal error");
            ErrorDialog.processGWException(e1);
            logger.debug((Object)"callCopy exited");
            return;
        }
        logger.debug((Object)"callCopy exited");
    }
}

