/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.DnDUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentView;
import com.novell.gw.jclient.application.controls.attachmentlist.ComposeAttachmentView;
import com.novell.gw.jclient.application.controls.attachmentlist.OpenAttachmentView;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

public class AttachmentViewTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(AttachmentViewTransferHandler.class);
    protected final AttachmentView attachmentView;
    private int[] selectedIndices;

    public AttachmentViewTransferHandler(AttachmentView attachmentView) {
        this.attachmentView = attachmentView;
    }

    public boolean importData(JComponent comp, Transferable transferable) {
        AttachmentView view;
        boolean result = false;
        try {
            List<DataFlavor> dataFlavors = Arrays.asList(transferable.getTransferDataFlavors());
            if (dataFlavors.contains(GWFlavors.transferItemsFlavor)) {
                result = this.attachItems(transferable);
            } else if (dataFlavors.contains(GWFlavors.attachmentsFlavor)) {
                result = this.attachAttachments(transferable);
            } else if (dataFlavors.contains(DataFlavor.javaFileListFlavor)) {
                result = this.attachFiles(transferable);
            } else if (dataFlavors.contains(GWFlavors.uriListFlavor)) {
                String files = (String)transferable.getTransferData(GWFlavors.uriListFlavor);
                result = this.attachFiles(files);
            } else if (dataFlavors.contains(DataFlavor.stringFlavor)) {
                String files = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                result = this.attachFiles(files);
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)e);
            return false;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
        if (result && (view = this.getAttachmentView()) instanceof ComposeAttachmentView) {
            ((ComposeAttachmentView)view).reloadAttachments();
            return true;
        }
        return false;
    }

    protected Transferable createTransferable(JComponent c) {
        this.selectedIndices = this.getAttachmentView().getSelectedIndices();
        return new AttachmentsTransferable();
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        AttachmentView attachmentView = this.getAttachmentView();
        if (action == 2 && attachmentView instanceof ComposeAttachmentView && this.selectedIndices != null) {
            ((ComposeAttachmentView)attachmentView).deleteAttachments(this.selectedIndices);
        }
        this.selectedIndices = null;
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        AttachmentView attachmentView = this.getAttachmentView();
        if (!(attachmentView instanceof ComposeAttachmentView)) {
            return false;
        }
        List<DataFlavor> flavors = Arrays.asList(transferFlavors);
        return flavors.contains(GWFlavors.transferItemsFlavor) || flavors.contains(DataFlavor.javaFileListFlavor) || flavors.contains(GWFlavors.attachmentsFlavor) || OS.isLinuxOS() && (flavors.contains(GWFlavors.uriListFlavor) || flavors.contains(DataFlavor.stringFlavor));
    }

    AttachmentView getAttachmentView() {
        return this.attachmentView;
    }

    private boolean attachFiles(String files) {
        List<File> result = Utils.getFileList(files);
        if (!result.isEmpty()) {
            this.getAttachmentView().getController().processCommand(new Command(760, result));
            return true;
        }
        return false;
    }

    private boolean attachItems(Transferable data) throws UnsupportedFlavorException, IOException {
        TransferItems transferData = (TransferItems)data.getTransferData(GWFlavors.transferItemsFlavor);
        return (this.getAttachmentView().getItem().getTransferOptions(transferData) & 4) > 0 && this.getAttachmentView().getItem().getNativeItem().transfer(transferData, 4);
    }

    private boolean attachFiles(Transferable data) throws UnsupportedFlavorException, IOException {
        List fileList = (List)data.getTransferData(DataFlavor.javaFileListFlavor);
        if (fileList != null && !fileList.isEmpty()) {
            this.getAttachmentView().getController().processCommand(new Command(760, fileList));
            return true;
        }
        return false;
    }

    private boolean attachAttachments(Transferable transferable) throws UnsupportedFlavorException, IOException {
        TransferAttachments transferData = (TransferAttachments)transferable.getTransferData(GWFlavors.attachmentsFlavor);
        Object message = this.getAttachmentView().getItem().getNativeItem();
        if ((message.getTransferOptions(transferData) & 4) > 0 && this.selectedIndices == null) {
            return message.transfer(transferData, 4);
        }
        return false;
    }

    private List getFileList() {
        Object[] attachments = this.attachmentView.getSelectedObjects();
        ArrayList<File> result = new ArrayList<File>(attachments.length);
        int nCount = attachments.length;
        for (int i = 0; i < nCount; ++i) {
            File file;
            String fileName = "";
            if (attachments[i] instanceof GWAttachment) {
                GWAttachment attachment = (GWAttachment)attachments[i];
                if (!attachment.isLocalFile()) {
                    String absolutePath = ControlsUtils.getAttachmentFilePath(attachment).getAbsolutePath();
                    MessageUtils.saveAttachment(attachment, absolutePath);
                }
                fileName = attachment.getLocalFilePath();
            } else if (attachments[i] instanceof AbstractItem) {
                AbstractItem item = (AbstractItem)attachments[i];
                fileName = DnDUtils.saveItem(item);
            }
            if ("".equals(fileName) || !(file = new File(fileName)).isFile()) continue;
            result.add(file);
        }
        return result;
    }

    private static List getTempFilesIfMac(List files) {
        ArrayList<File> newFiles = new ArrayList<File>();
        try {
            for (Object o : files) {
                int c;
                File file = (File)o;
                File temp = new File(File.createTempFile("novell", ".dir", null).getParent(), file.getName());
                FileReader reader = new FileReader(file);
                FileWriter writer = new FileWriter(temp);
                while ((c = reader.read()) != -1) {
                    writer.write(c);
                }
                reader.close();
                writer.close();
                file.deleteOnExit();
                newFiles.add(temp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newFiles;
    }

    class AttachmentsTransferable
    implements Transferable {
        private final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, GWFlavors.attachmentsFlavor, GWFlavors.uriListFlavor, DataFlavor.stringFlavor};

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(this.flavors).contains(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                if (OS.isMacOS()) {
                    return AttachmentViewTransferHandler.getTempFilesIfMac(AttachmentViewTransferHandler.this.getFileList());
                }
                return AttachmentViewTransferHandler.this.getFileList();
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return DnDUtils.getUrlFromFileList(AttachmentViewTransferHandler.this.getFileList());
            }
            if (flavor.equals(GWFlavors.uriListFlavor)) {
                return DnDUtils.getUrlFromFileList(AttachmentViewTransferHandler.this.getFileList());
            }
            if (flavor.equals(GWFlavors.attachmentsFlavor)) {
                AttachmentView av = AttachmentViewTransferHandler.this.getAttachmentView();
                if (av instanceof OpenAttachmentView) {
                    int nCount = AttachmentViewTransferHandler.this.selectedIndices.length;
                    int i = 0;
                    while (i < nCount) {
                        int[] nArray = AttachmentViewTransferHandler.this.selectedIndices;
                        int n = i++;
                        nArray[n] = nArray[n] - 1;
                    }
                }
                return av.getItem().getNativeItem().getTransferAttachments(AttachmentViewTransferHandler.this.selectedIndices);
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

