/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.appframework.cache.IdentifiedObject;
import com.appframework.components.htmleditor.DirtyStateManager;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentView;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentViewTransferHandler;
import com.novell.gw.jclient.application.controls.attachmentlist.TableView;
import com.novell.gw.jclient.application.controls.attachmentlist.ViewContent;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.GWItemAttachment;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposeAttachmentView
extends AttachmentView {
    private static Logger logger = Logger.getLogger(ComposeAttachmentView.class);
    private AVKeyListener listKeyListener = new AVKeyListener();
    private DirtyStateManager dirtyStateManager;

    public ComposeAttachmentView(MVCController theParentController, DirtyStateManager theDirtyStateManager) {
        super(false, theParentController);
        this.dirtyStateManager = theDirtyStateManager;
        this.listContent.addKeyListener(this.listKeyListener);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.listContent.removeKeyListener(this.listKeyListener);
        this.listContent.addKeyListener(this.listKeyListener);
    }

    @Override
    protected void unRegisterListeners() {
        super.unRegisterListeners();
        this.listContent.removeKeyListener(this.listKeyListener);
    }

    @Override
    protected void parseGWItem() {
    }

    @Override
    protected JPopupMenu appendDefaultActions(JPopupMenu thePopupMenu) {
        JPopupMenu popup = super.appendDefaultActions(thePopupMenu);
        JMenuItem menuItem = this.controller.getActionList().getAction(ActionKey.ATTACH_FILE).getMenuItem();
        popup.insert(menuItem, 0);
        popup.insert(new JPopupMenu.Separator(), 1);
        return popup;
    }

    @Override
    protected JPopupMenu getAttachmentPopupMenu(Object itemAtPoint) {
        JPopupMenu popup = super.getAttachmentPopupMenu(itemAtPoint);
        popup.addSeparator();
        popup.add(MenuItemFactory.createMenuItem(new DeleteAttachmentsAction()));
        return popup;
    }

    @Override
    protected JPopupMenu getItemPopupMenu(AbstractItem theItem) {
        JPopupMenu popup = super.getItemPopupMenu(theItem);
        popup.addSeparator();
        popup.add(MenuItemFactory.createMenuItem(new DeleteAttachmentsAction()));
        return popup;
    }

    @Override
    protected JPopupMenu getMultipleObjectsPopupMenu(Object[] theSelectedItems) {
        JPopupMenu popup = super.getMultipleObjectsPopupMenu(theSelectedItems);
        popup.addSeparator();
        popup.add(MenuItemFactory.createMenuItem(new DeleteAttachmentsAction()));
        return popup;
    }

    public void addFileAttachments(Collection<GWAttachment> attachments) {
        for (GWAttachment attactment : attachments) {
            this.item.addAttachment(attactment.getLocalFilePath());
        }
        this.readAttachments(this.item.getAttachments());
        this.listContent.selectItems(attachments.toArray());
    }

    public void setAttachmentsCompositions(List<GWAttachment> theAttachments) {
        this.readAttachments(theAttachments);
    }

    void reloadAttachments() {
        this.item.clearAttachments();
        this.setAttachmentsCompositions(this.item.getAttachments());
    }

    private void readAttachments(List<GWAttachment> attachments) {
        int oldCount = this.listContent.getItemsCount();
        for (GWAttachment attachment : attachments) {
            if (attachment.isHTMLMessageBody()) continue;
            if (attachment.isMessageAttachment()) {
                try {
                    String userGuid = ControlsUtils.getUserGuid(this.controller);
                    AbstractItem item = GWCommandManager.getInstance(userGuid).getEnclosedItem(attachment);
                    if (this.listContent.containsObject(item)) continue;
                    this.listContent.addElement(item);
                }
                catch (GWCommandException e) {
                    logger.error((Object)e, (Throwable)e);
                    ErrorDialog.processGWException(e);
                }
                continue;
            }
            if (this.listContent.containsObject(attachment) || attachment.isSystemAttachment()) continue;
            this.listContent.addElement(attachment);
        }
        int newCount = this.listContent.getItemsCount();
        if (newCount != oldCount) {
            this.dirtyStateManager.setDirty(true, this.dirtyStateManager.isDirtyHTML());
        }
    }

    @Override
    protected void createContent(ViewContent theViewContent) {
        super.createContent(theViewContent);
        if (this.listContent instanceof TableView) {
            this.sp.setTransferHandler(new AttachmentViewTransferHandler(this));
        }
    }

    public List<GWAttachment> getAttachmentsCompositions() {
        ArrayList<GWAttachment> result = new ArrayList<GWAttachment>();
        for (int i = 0; i < this.listContent.getItemsCount(); ++i) {
            Object model = this.listContent.getElementAt(i);
            if (model instanceof GWAttachment) {
                result.add((GWAttachment)model);
                continue;
            }
            if (!(model instanceof AbstractItem)) continue;
            AbstractItem item = (AbstractItem)model;
            GWItemAttachment attachment = new GWItemAttachment((IMessage)item.getNativeItem());
            result.add(attachment);
        }
        return result;
    }

    public void deleteAttachments(int[] indeces) {
        Object[] objects = new Object[indeces.length];
        for (int i = 0; i < indeces.length; ++i) {
            objects[i] = this.listContent.getElementAt(indeces[i]);
        }
        this.deleteAttachments(objects);
    }

    public void deleteAttachments(Object[] elements) {
        int nCount = elements.length;
        for (int i = 0; i < nCount; ++i) {
            IdentifiedObject attachment;
            Object element = elements[i];
            if (element instanceof GWAttachment) {
                attachment = (GWAttachment)element;
                this.item.deleteAttachment((GWAttachment)attachment);
            } else if (element instanceof AbstractItem) {
                attachment = (AbstractItem)element;
                this.item.deleteAttachment((AbstractItem)attachment);
            } else {
                throw new IllegalStateException("Unknown attachment type");
            }
            this.listContent.removeElement(elements[i]);
        }
        if (this.listContent.getItemsCount() > 0) {
            this.listContent.selectItems(new Object[]{this.listContent.getElementAt(0)});
        }
        this.reloadAttachments();
    }

    public void deleteSelectedAttachments() {
        this.deleteAttachments(this.listContent.getSelectedValues());
    }

    public void setItem(AbstractItem theNewItem) {
        this.listContent.removeAllElements();
        this.item = theNewItem;
    }

    private class AVKeyListener
    extends KeyAdapter {
        private AVKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
            if (e.getKeyCode() == itemDeleteKey) {
                ComposeAttachmentView.this.deleteSelectedAttachments();
            }
        }
    }

    private class DeleteAttachmentsAction
    extends AbstractAction {
        public DeleteAttachmentsAction() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            ComposeAttachmentView.this.deleteSelectedAttachments();
        }
    }
}

