/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextArea;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class FileSizeWarnDialog
extends GWDialog {
    private int allowedFileSize;
    private long currentFileSize;
    private final int DONT_WARN = -1;
    private JCheckBox cbDontDisplayThisPromtAgain;
    public boolean allowToView = true;

    public FileSizeWarnDialog(JFrame theFrame, int allowedFileSize, long currentFileSize) {
        super(theFrame);
        this.allowedFileSize = allowedFileSize / 1024;
        this.currentFileSize = currentFileSize / 1024L;
        this.init();
        this.buildUI();
    }

    private void init() {
        this.setTitle(StringResources.WARNING);
        this.btnOK.setText(StringResources.YES);
        this.btnCancel.setText(StringResources.NO);
        this.cbDontDisplayThisPromtAgain = new JMnemonicCheckBox(StringResources.DONT_DISPLAY_THIS_PROMPT_AGAIN);
        this.btnOK.addActionListener(new SaveSettingsAction());
        this.btnCancel.addActionListener(new SaveSettingsAction());
        this.btnCancel.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FileSizeWarnDialog.this.allowToView = false;
            }
        });
    }

    private void buildUI() {
        this.panTopPanel.setLayout(new GridBagLayout());
        this.panTopPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        String message = StringResources.formatString(StringResources.THIS_ATTACHMENT_IS_LARGER_THAN, String.valueOf(this.allowedFileSize), String.valueOf(this.currentFileSize));
        OrientableTextArea ta = new OrientableTextArea(message);
        ta.setBackground(this.getBackground());
        this.panTopPanel.add((Component)ta, constraints);
        this.panLeftPanel.add(new OrientableLabel(ImageResources.ICON_ALERT));
        this.panBottomPanel.add(this.btnOK);
        this.panBottomPanel.add(this.btnCancel);
        this.panCenterPanel.add(this.cbDontDisplayThisPromtAgain);
        this.panCenterPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setResizable(false);
    }

    private class SaveSettingsAction
    extends AbstractAction {
        private SaveSettingsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (FileSizeWarnDialog.this.cbDontDisplayThisPromtAgain.isSelected()) {
                EngineCommandManager.getAccountSettings().setAttachmentSizeWarningThreshold(-1);
            }
        }
    }
}

