/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.appframework.utils.Day;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.MonthlyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class SetDateDialog
extends OkCancelDialog {
    private MonthlyCalendar dayCalendar;
    private JTextField tfDate;
    private Day startDay;

    public SetDateDialog(Frame owner, Day startDay) throws HeadlessException {
        super(owner);
        if (startDay == null) {
            throw new IllegalArgumentException("startDay is null");
        }
        this.startDay = startDay;
        this.buildUI();
    }

    private void buildUI() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.removeAll();
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 23;
        contentPane.add((Component)this.buildCalendarPanel(), c);
        c.gridx = 1;
        c.insets = new Insets(0, 10, 0, 0);
        c.anchor = 24;
        contentPane.add((Component)this.buildButtonsPanel(), c);
        this.refreshUI();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void refreshUI() {
        this.tfDate.setText(OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(this.dayCalendar.getDate().getTime()));
    }

    private JComponent buildButtonsPanel() {
        JButton btnToday = new JButton(new ActionToday());
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 7, 0);
        c.gridy = 0;
        result.add((Component)this.getBtnOk(), c);
        c.gridy = 1;
        result.add((Component)this.getBtnCancel(), c);
        c.gridy = 2;
        c.weighty = 1.0;
        c.anchor = 23;
        result.add((Component)btnToday, c);
        return result;
    }

    private JPanel buildCalendarPanel() {
        assert (this.startDay != null) : "startDay is null";
        this.dayCalendar = new MonthlyCalendar(GWCalendarUtils.convertDayToCalendar(this.startDay), true, false);
        this.dayCalendar.getCalendarComponent().updateSelection();
        this.dayCalendar.addValueChangeListener(new CalendarDateChangeListener());
        this.tfDate = new GWTextField();
        this.tfDate.setEditable(false);
        JPanel result = new JPanel(new GridBagLayout());
        Border outside = BorderFactory.createEtchedBorder(0);
        Border inside = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        result.setBorder(BorderFactory.createCompoundBorder(outside, inside));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.insets = new Insets(0, 0, 10, 0);
        c.gridy = 0;
        result.add((Component)this.dayCalendar, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 1;
        result.add((Component)this.tfDate, c);
        return result;
    }

    public Day getSelectedDay() {
        return new Day(this.dayCalendar.getDate());
    }

    private class CalendarDateChangeListener
    implements DateValueChangeListener {
        private CalendarDateChangeListener() {
        }

        public void valueChanged(DateChangeEvent e) {
            SetDateDialog.this.refreshUI();
        }
    }

    private class ActionToday
    extends AbstractAction {
        public ActionToday() {
            super(StringResources.TODAY);
        }

        public void actionPerformed(ActionEvent e) {
            SetDateDialog.this.dayCalendar.gotoToday();
            SetDateDialog.this.refreshUI();
        }
    }
}

