/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.TimeGridPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DayLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.HourLabelsPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableTimeGrid
extends TimeGridPanel
implements MVCView {
    public static int MINUTES_PER_ROW = 15;
    private static final Color GRID_COLOR = new Color(170, 170, 170);
    private static final int ROW_COUNT = 96;
    public static final int CELL_HEIGHT = PLAFChanger.getFontSize() / 4 + 1;

    public AvailableTimeGrid(GWBusySearch theBusySearch, MVCController theParentController) {
        super(theParentController);
        this.busySearch = theBusySearch;
        this.addKeyListener(new ATGKeyListener());
    }

    @Override
    protected void buildView() {
        this.setColumnCount(this.daysCount);
        this.setRowCount(this.rowCount);
        this.setMinimumCellSize(26, CELL_HEIGHT);
        this.setHorizontallyResizible(false);
    }

    @Override
    protected boolean isDayEnd() {
        return (float)(this.recDragged.y + this.recDragged.height) / this.rowHeight % 96.0f == 0.0f;
    }

    @Override
    protected boolean isDayStart() {
        return this.selectedRow == 0;
    }

    @Override
    protected boolean nextRow() {
        boolean result;
        float row = (float)(this.recDragged.y + this.recDragged.height) / this.rowHeight;
        boolean bl = result = row * this.rowHeight <= (float)this.getHeight();
        if (result) {
            if (this.isDayEnd()) {
                if (this.selectedColumn < this.columnCount - 1) {
                    this.selectedRow = (int)row;
                }
            } else {
                ++this.selectedRow;
            }
        }
        return result;
    }

    @Override
    protected boolean prevRow() {
        boolean result;
        boolean bl = result = this.selectedColumn != 0 || !this.isDayStart();
        if (result) {
            if (this.isDayStart()) {
                if (this.selectedColumn > 0) {
                    this.selectedRow = (int)((float)this.rowCount - (float)this.recDragged.height / this.rowHeight);
                    --this.selectedColumn;
                }
            } else {
                --this.selectedRow;
            }
        }
        return result;
    }

    @Override
    protected boolean prevColumn() {
        boolean result;
        boolean bl = result = this.selectedColumn > 0;
        if (result) {
            --this.selectedColumn;
        }
        return result;
    }

    @Override
    protected boolean nextColumn() {
        boolean result;
        boolean bl = result = this.recDragged.x + this.recDragged.width < this.getWidth();
        if (result) {
            ++this.selectedColumn;
        }
        return result;
    }

    @Override
    protected void drawRectangles(Graphics g, Map<String, List<TimeGridPanel.VisibleIndividualInfo>> map, Color color, boolean drawBorder) {
        Rectangle rr = new Rectangle();
        Rectangle r = new Rectangle();
        int insetX = 1;
        int insetW = 0;
        if (drawBorder) {
            insetX = 3;
            insetW = 3;
        }
        boolean bLeftToRight = this.getComponentOrientation().isLeftToRight();
        for (List<TimeGridPanel.VisibleIndividualInfo> visibleIndividualInfos : map.values()) {
            for (TimeGridPanel.VisibleIndividualInfo visibleIndividualInfo : visibleIndividualInfos) {
                r = visibleIndividualInfo.getVisibleRectangle();
                rr.x = Math.round(this.fromLogicalXToPthysical(r.x)) + insetX;
                rr.y = Math.round(this.fromLogicalYToPthysical(r.y));
                rr.width = Math.round(this.fromLogicalXToPthysical(r.width)) - insetW * 2;
                rr.height = Math.round(this.fromLogicalYToPthysical(r.height));
                if (!bLeftToRight) {
                    rr.x = this.getWidth() - rr.x - rr.width + 1;
                }
                g.setColor(color);
                g.fillRect(rr.x, rr.y, rr.width, rr.height);
                if (!drawBorder) continue;
                g.setColor(Color.BLACK);
                g.drawRect(rr.x, rr.y, rr.width, rr.height);
            }
        }
    }

    @Override
    protected void drawGrid(Graphics g) {
        int i;
        g.setColor(GRID_COLOR);
        for (i = 1; i < this.rowCount; ++i) {
            if (i % 4 != 0) continue;
            g.drawLine(0, Math.round((float)i * this.rowHeight), this.getWidth(), Math.round((float)i * this.rowHeight));
        }
        for (i = 0; i < this.columnCount; ++i) {
            g.drawLine(Math.round((float)i * this.columnWidth), 0, Math.round((float)i * this.columnWidth), this.getHeight());
        }
    }

    @Override
    public void setDaysCount(int daysCount) {
        this.daysCount = daysCount;
        this.setColumnCount(this.daysCount);
    }

    @Override
    protected void setAppointmentTime(TimeInterval theAppointmentTime) {
        this.initCalendar();
        int minInDay = 1440;
        this.gcAppointmentTime.setTime(theAppointmentTime.getStartDateAsDate());
        long diffInMinutes = (this.gcAppointmentTime.getTimeInMillis() - this.gcStartDay.getTimeInMillis()) / 60000L;
        int x = (int)(diffInMinutes += (long)(this.calculateShiftHours(theAppointmentTime) * 60)) / minInDay;
        int y = (int)(diffInMinutes % (long)minInDay) / MINUTES_PER_ROW;
        int h = (int)(theAppointmentTime.getEndDate() - theAppointmentTime.getStartDate()) / (MINUTES_PER_ROW * 60000);
        this.setLogicalPosition(x, y);
        this.setLogicalHeight(h);
        this.setLogicalWidth(1);
    }

    @Override
    protected Rectangle getLogicalRectangle(TimeInterval theTimeInterval, int index) {
        int minInDay = 1440;
        long diffInMinutes = 0L;
        int x = 0;
        int y = 0;
        int h = 0;
        float hh = 0.0f;
        diffInMinutes = (theTimeInterval.getStartDate() - this.gcStartDay.getTimeInMillis()) / 60000L;
        x = (int)(diffInMinutes += (long)(this.calculateShiftHours(theTimeInterval) * 60)) / minInDay;
        hh = diffInMinutes % (long)minInDay;
        y = Math.round(hh / (float)MINUTES_PER_ROW);
        hh = theTimeInterval.getEndDate() - theTimeInterval.getStartDate();
        h = Math.round(hh / (float)(60000 * MINUTES_PER_ROW));
        return new Rectangle(x, y, 1, h);
    }

    @Override
    protected TimeInterval getAppointmentTimeInterval() {
        this.gcAppointmentTime.setTime(this.gcStartDay.getTime());
        this.gcAppointmentTime.add(5, this.getSelectedColumn());
        this.gcAppointmentTime.add(12, this.getSelectedRow() * MINUTES_PER_ROW);
        TimeInterval theTimeInterval = new TimeInterval(this.gcAppointmentTime.getTimeInMillis(), this.gcAppointmentTime.getTimeInMillis() + (long)(this.getSelectedHeight() * MINUTES_PER_ROW * 60000));
        return theTimeInterval;
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    private class ATGKeyListener
    extends KeyAdapter {
        private ATGKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                if (e.isShiftDown()) {
                    if (AvailableTimeGrid.this.isDayEnd() && !AvailableTimeGrid.this.isDayStart()) {
                        AvailableTimeGrid.this.prevRow();
                        AvailableTimeGrid.this.updateRecPosition();
                    }
                    if (!AvailableTimeGrid.this.isDayStart() || !AvailableTimeGrid.this.isDayEnd()) {
                        AvailableTimeGrid.this.recDragged.height = (int)((float)AvailableTimeGrid.this.recDragged.height + AvailableTimeGrid.this.rowHeight);
                        AvailableTimeGrid.this.convertPhysicalXYToLogical(AvailableTimeGrid.this.recDragged);
                    }
                }
                if (AvailableTimeGrid.this.recDragged.x + AvailableTimeGrid.this.recDragged.width <= AvailableTimeGrid.this.getWidth() && (float)AvailableTimeGrid.this.selectedColumn * AvailableTimeGrid.this.columnWidth < (float)AvailableTimeGrid.this.getWidth()) {
                    AvailableTimeGrid.this.updateRecPosition();
                    AvailableTimeGrid.this.getController().processCommand(new Command(1370));
                }
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                if (e.isShiftDown()) {
                    AvailableTimeGrid.this.recDragged.height = (int)((float)AvailableTimeGrid.this.recDragged.height - AvailableTimeGrid.this.rowHeight);
                    AvailableTimeGrid.this.convertPhysicalXYToLogical(AvailableTimeGrid.this.recDragged);
                }
                AvailableTimeGrid.this.updateRecPosition();
                AvailableTimeGrid.this.getController().processCommand(new Command(1370));
            }
        }
    }

    private static class BusyHourLabelBorder
    extends AbstractBorder {
        private BusyHourLabelBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.BLACK);
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(0, 0, 0, height - 1);
            g.drawLine(width - 1, height - 1, width - 1, 0);
            g.setColor(Color.DARK_GRAY);
            g.drawLine(width - 1, height - 1, 0, height - 1);
            g.setColor(Color.WHITE);
            g.drawLine(1, 1, 1, height - 2);
            g.drawLine(1, 1, width - 2, 1);
        }
    }

    public static class BusyDayLabelBorder
    extends AbstractBorder {
        private boolean isLast;

        public BusyDayLabelBorder(boolean last) {
            this.isLast = last;
        }

        public BusyDayLabelBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.DARK_GRAY);
            g.drawLine(0, 0, 0, height);
            g.setColor(Color.WHITE);
            g.drawLine(1, 1, 1, height);
            g.drawLine(1, 1, width, 1);
            g.setColor(Color.BLACK);
            g.drawLine(0, 0, width, 0);
            g.drawLine(0, height - 1, width, height - 1);
            if (this.isLast) {
                g.setColor(Color.BLACK);
                g.drawLine(width - 1, 0, width - 1, height);
            }
        }
    }

    static class HourLabels
    extends HourLabelsPanel {
        public static final int ROW_WIDTH = PLAFChanger.getFontSize() * 2 + 11;

        public HourLabels() {
            super(new BusyHourLabelBorder());
            Dimension dim = new Dimension(ROW_WIDTH, 96 * CELL_HEIGHT);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
            this.setOpaque(true);
            this.setBackground(UIManager.getColor("Frame.background"));
        }

        protected void init() {
        }

        protected DateFormat getTimeFormat() {
            return DateAndTimeFormattingUtils.getHoursFormat();
        }

        protected JComponent getLabel(Calendar gc, DateFormat theTimeFormat) {
            OrientableLabel label = new OrientableLabel(theTimeFormat.format(gc.getTime()));
            label.setHorizontalAlignment(0);
            return label;
        }
    }

    static class DayLabels
    extends DayLabelsPanel {
        protected SimpleDateFormat sdf;
        private int minCellWidth = 10;

        public DayLabels() {
            this(7);
        }

        public DayLabels(int theDaysCount) {
            super(theDaysCount);
            this.setLayout(null);
            this.setDaysCount(theDaysCount);
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(EngineCommandManager.getLocale());
            String[] days = new String[8];
            System.arraycopy(GWCalendarUtils.dayShortestNames, 0, days, 1, GWCalendarUtils.dayShortestNames.length);
            days[0] = "";
            dateFormatSymbols.setShortWeekdays(days);
            this.sdf = new SimpleDateFormat("E", dateFormatSymbols);
            this.sdf.setTimeZone(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        }

        protected void init() {
            super.init();
            this.labelBorder = new BusyDayLabelBorder();
            this.height = PLAFChanger.getFontSize() * 2 + 10;
        }

        protected void setTextToLabel(JLabel lbl, Calendar day, boolean isShortText) {
            lbl.setText("<html> <P ALIGN=CENTER>" + this.sdf.format(day.getTime()) + "<br>" + day.get(5) + "</P> </html>");
        }

        public void setDaysCount(int daysCount) {
            super.setDaysCount(daysCount);
            Dimension dim = new Dimension(26 * daysCount, this.height);
            this.setPreferredSize(dim);
        }

        public void doLayout() {
            Component comp = null;
            float width = this.getWidth();
            if ((width /= (float)this.getComponentCount()) < (float)this.minCellWidth) {
                width = this.minCellWidth;
            }
            int n = this.getComponentCount();
            boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < n; ++i) {
                comp = this.getComponent(isLeftToRight ? i : n - i - 1);
                comp.setBounds(Math.round(width * (float)i), 0, Math.round(width * (float)(i + 1)) - Math.round(width * (float)i), this.getHeight());
            }
        }

        public void setMinimumCellWidth(int cellWidth) {
            this.minCellWidth = cellWidth;
        }
    }
}

