/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.Tested;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.AddressableType;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddress;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.busysearch.PositionInterval;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.util.BitSet;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusySearchUtils {
    private static Logger logger = Logger.getLogger(BusySearchUtils.class);

    @Tested(completely=false)
    public static PositionInterval convertAbsoluteToVisibleInterval(BitSet visibilityMap, PositionInterval absoluteInterval) {
        int endPosition;
        if (visibilityMap == null) {
            throw new IllegalArgumentException("visibilityMap is null");
        }
        if (absoluteInterval == null) {
            throw new IllegalArgumentException("absoluteInterval is null");
        }
        if (absoluteInterval.getLength() == 0) {
            return new PositionInterval(absoluteInterval.getStartPosition(), absoluteInterval.getEndPosition());
        }
        assert (absoluteInterval.getLength() > 0) : "unexpected interval length: " + absoluteInterval.getLength();
        int startPosition = absoluteInterval.getStartPosition();
        int visibleColumnsInInterval = visibilityMap.get(startPosition, endPosition = absoluteInterval.getEndPosition()).cardinality();
        if (visibleColumnsInInterval == 0) {
            return new PositionInterval(0, 0);
        }
        int visibleColumnsBeforeStartPosition = visibilityMap.get(0, startPosition).cardinality();
        return new PositionInterval(visibleColumnsBeforeStartPosition, visibleColumnsBeforeStartPosition + visibleColumnsInInterval);
    }

    public static boolean hasValidRecipient(DistributionList distributionList) {
        if (distributionList == null) {
            return false;
        }
        int nSize = distributionList.getSize();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = APIAbWrapperManager.getRecipient(distributionList.getRecipient(i));
            if (recipient.isUnresolved()) continue;
            return true;
        }
        return false;
    }

    public static void addRecipientDescriptionToList(List<RecipientDescription> list, IRecipient recipient, int state, boolean isSelected) {
        RecipientDescription rdNew = null;
        IAddressable addressable = recipient.getAddressable();
        RecipientCopyType copyType = recipient.getCopyType();
        if (addressable instanceof IAddress && (addressable.getAddressableType() == AddressableType.PERSONAL_GROUP || addressable.getAddressableType() == AddressableType.SYSTEM_GROUP)) {
            try {
                List<IItem> foundContacts = ControlsUtils.itemListToList(APIWrapperManager.getItemList(EngineCommandManager.getAddressBookManager().findContactsByName(addressable.getDisplayName())));
                addressable = (IContact)foundContacts.get(0);
            }
            catch (EngineException e) {
                logger.error((Object)e);
            }
        }
        if (addressable instanceof IGroupContact) {
            IGroupContact gc = (IGroupContact)addressable;
            try {
                IItemList itemList = gc.canRefresh() ? gc.refresh() : gc.getMembers();
                int size = itemList.getSize();
                for (int i = 0; i < size; ++i) {
                    IItem item = itemList.getItemAt(i);
                    if (!(item instanceof IContact)) continue;
                    rdNew = new RecipientDescription(APIAbWrapperManager.createRecipient((IContact)item, copyType), state, isSelected);
                    list.add(rdNew);
                }
            }
            catch (EngineException e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else {
            rdNew = new RecipientDescription(recipient, state, isSelected);
            list.add(rdNew);
        }
    }
}

