/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

class DragRectanglePanel
extends OrientablePanel
implements MouseListener,
MouseMotionListener,
ComponentListener {
    protected static final int DRAGGING_NO = 0;
    protected static final int DRAGGING_RECTANGLE = 1;
    protected static final int DRAGGING_UPPER_SIDE = 2;
    protected static final int DRAGGING_LOWER_SIDE = 3;
    protected static final int DRAGGING_LEFT_SIDE = 4;
    protected static final int DRAGGING_RIGHT_SIDE = 5;
    protected int draggingMode = 0;
    private Rectangle recSelectedTime;
    protected Rectangle recDragged;
    private Color colorSelectedRectangle = Color.BLACK;
    protected int columnCount = 7;
    protected int rowCount = 24;
    protected float columnWidth = 30.0f;
    protected float rowHeight = 30.0f;
    private Dimension minimumCellSize = new Dimension(30, 30);
    protected ArrayList rowY = new ArrayList(this.rowCount);
    protected ArrayList colX = new ArrayList(this.columnCount);
    protected int selectedColumn = 0;
    protected int selectedRow = 0;
    protected int selectedWidth = 1;
    protected int selectedHeight = 1;
    private Dimension panelDimension;
    private boolean isHorizontallyResizible = true;
    private boolean isVerticallyResizible = true;
    private boolean isGridDrawing = false;
    private BasicStroke rectStroke = new BasicStroke(2.0f);
    protected int dx;
    protected int dy;
    private Rectangle recDragging = new Rectangle();
    private Rectangle recUpperSide = new Rectangle();
    private Rectangle recLowerSide = new Rectangle();
    private Rectangle recLeftSide = new Rectangle();
    private Rectangle recRightSide = new Rectangle();
    protected static final int RESIZE_HEIGHT = 3;

    public DragRectanglePanel(int theColumnCount, int theRowCount) {
        this.columnCount = theColumnCount;
        this.rowCount = theRowCount;
        this.updatePhysicalCoordinates();
        this.buildUI();
        Rectangle rec = new Rectangle(0, this.recSelectedTime.y - (int)this.rowHeight * 4, 1, this.recSelectedTime.height);
        this.scrollRectToVisible(rec);
        this.addComponentListener(this);
    }

    public DragRectanglePanel() {
        this(20, 10);
    }

    private void buildUI() {
        this.updateSize();
        this.setOpaque(false);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.calculateGrid();
    }

    protected void calculateGrid() {
        int i;
        this.colX.clear();
        for (i = 0; i < this.columnCount; ++i) {
            this.colX.add(new Integer(Math.round(this.columnWidth * (float)i)));
        }
        this.rowY.clear();
        for (i = 0; i < this.rowCount; ++i) {
            this.rowY.add(new Integer(Math.round(this.rowHeight * (float)i)));
        }
    }

    protected void updatePhysicalCoordinates() {
        if (this.selectedHeight <= 0) {
            this.selectedHeight = 1;
        }
        if (this.selectedWidth <= 0) {
            this.selectedWidth = 1;
        }
        int x = Math.round(this.columnWidth * (float)this.selectedColumn) + 1;
        int y = Math.round(this.rowHeight * (float)this.selectedRow) + 1;
        int width = Math.round(this.columnWidth * (float)this.selectedWidth) - 1;
        int height = Math.round(this.rowHeight * (float)this.selectedHeight) - 1;
        this.recSelectedTime = new Rectangle(x, y, width, height);
        this.recDragged = new Rectangle(this.recSelectedTime);
    }

    public float fromLogicalXToPthysical(int theX) {
        return this.columnWidth * (float)theX;
    }

    public int fromPhysicalXToLogical(int x) {
        return (int)((float)x / this.columnWidth);
    }

    public float fromLogicalYToPthysical(int theY) {
        return this.rowHeight * (float)theY;
    }

    public void setLogicalPosition(int column, int row) {
        this.selectedRow = row > this.rowCount - 1 ? this.rowCount - 1 : (row < 0 ? 0 : row);
        this.selectedColumn = column > this.columnCount - 1 ? this.columnCount - 1 : (column < 0 ? 0 : column);
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    public void setLogicalHeight(int height) {
        this.selectedHeight = height > this.rowCount ? this.rowCount : (height < 0 ? 1 : height);
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    public void setLogicalWidth(int width) {
        this.selectedWidth = width > this.columnCount ? this.columnCount : (width < 0 ? 0 : width);
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    protected void convertPhysicalXYToLogical(Rectangle theRectangle) {
        this.selectedColumn = (int)((float)(theRectangle.x + 1) / this.columnWidth);
        this.selectedRow = (int)((float)(theRectangle.y + 1) / this.rowHeight);
        this.selectedWidth = Math.round((float)(theRectangle.width + 1) / this.columnWidth);
        this.selectedHeight = Math.round((float)(theRectangle.height + 1) / this.rowHeight);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.isGridDrawing) {
            this.drawGridLines(g);
        }
        this.paintSelectedTime(g2);
    }

    private void drawGridLines(Graphics g) {
        int i;
        g.setColor(ColorConstants.HEADER_BORDER_COLOR);
        int step = this.getHeight() / this.rowCount;
        for (i = 0; i < this.rowCount; ++i) {
            g.drawLine(0, i * step, this.getWidth(), i * step);
        }
        step = this.getWidth() / this.columnCount;
        for (i = 0; i < this.columnCount; ++i) {
            g.drawLine(i * step, 0, i * step, this.getHeight());
        }
    }

    private void paintSelectedTime(Graphics2D g2) {
        g2.setStroke(this.rectStroke);
        g2.setColor(this.colorSelectedRectangle);
        Rectangle tmpRect = this.draggingMode != 0 ? new Rectangle(this.recDragged) : new Rectangle(this.recSelectedTime);
        if (!this.getComponentOrientation().isLeftToRight()) {
            tmpRect.x = this.getWidth() - tmpRect.x - tmpRect.width + 1;
        }
        g2.draw(tmpRect);
    }

    public void setHorizontallyResizible(boolean horizontallyResizible) {
        this.isHorizontallyResizible = horizontallyResizible;
    }

    public void setVerticallyResizible(boolean verticallyResizible) {
        this.isVerticallyResizible = verticallyResizible;
    }

    public void setMinimumCellSize(int theCellWidth, int theCellHeigth) {
        this.minimumCellSize.width = theCellWidth;
        this.minimumCellSize.height = theCellHeigth;
        this.updateSize();
        this.doComponentResized();
    }

    private void updateSize() {
        this.panelDimension = new Dimension(this.minimumCellSize.width * this.columnCount, this.minimumCellSize.height * this.rowCount);
        this.setPreferredSize(this.panelDimension);
        this.setMinimumSize(this.panelDimension);
    }

    public void setGridDrawing(boolean gridDrawing) {
        this.isGridDrawing = gridDrawing;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
        this.updateSize();
        this.doComponentResized();
        this.updateUI();
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
        this.updateSize();
        this.doComponentResized();
        this.updateUI();
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int selectedRow) {
        this.selectedRow = selectedRow;
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    public int getSelectedWidth() {
        return this.selectedWidth;
    }

    public int getSelectedHeight() {
        return this.selectedHeight;
    }

    protected void refreshRects() {
        this.recDragging.x = this.recSelectedTime.x + 3;
        this.recDragging.width = this.recSelectedTime.width - 6;
        this.recDragging.y = this.recSelectedTime.y + 3;
        this.recDragging.height = this.recSelectedTime.height - 6;
        this.recUpperSide.x = this.recSelectedTime.x + 3;
        this.recUpperSide.width = this.recSelectedTime.width - 6;
        this.recUpperSide.y = this.recSelectedTime.y;
        this.recUpperSide.height = 3;
        this.recLowerSide.x = this.recSelectedTime.x + 3;
        this.recLowerSide.width = this.recSelectedTime.width - 6;
        this.recLowerSide.y = this.recSelectedTime.y + this.recSelectedTime.height - 3;
        this.recLowerSide.height = 3;
        this.recLeftSide.x = this.recSelectedTime.x;
        this.recLeftSide.width = 3;
        this.recLeftSide.y = this.recSelectedTime.y;
        this.recLeftSide.height = this.recSelectedTime.height;
        this.recRightSide.x = this.recSelectedTime.x + this.recSelectedTime.width - 3;
        this.recRightSide.width = 3;
        this.recRightSide.y = this.recSelectedTime.y;
        this.recRightSide.height = this.recSelectedTime.height;
    }

    public void mouseMoved(MouseEvent e) {
        if (this.recDragging.contains(e.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else if (this.recUpperSide.contains(e.getPoint()) && this.isVerticallyResizible) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.recLowerSide.contains(e.getPoint()) && this.isVerticallyResizible) {
            this.setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.recLeftSide.contains(e.getPoint()) && this.isHorizontallyResizible) {
            this.setCursor(Cursor.getPredefinedCursor(10));
        } else if (this.recRightSide.contains(e.getPoint()) && this.isHorizontallyResizible) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.recDragging.contains(e.getPoint())) {
            this.dx = e.getX() - this.recSelectedTime.x;
            this.dy = e.getY() - this.recSelectedTime.y;
            this.draggingMode = 1;
        } else if (this.recLowerSide.contains(e.getPoint()) && this.isVerticallyResizible) {
            this.dy = this.recSelectedTime.y + this.recSelectedTime.height - e.getY();
            this.draggingMode = 3;
        } else if (this.recUpperSide.contains(e.getPoint()) && this.isVerticallyResizible) {
            this.dy = e.getY() - this.recSelectedTime.y;
            this.draggingMode = 2;
        } else if (this.recRightSide.contains(e.getPoint()) && this.isHorizontallyResizible) {
            this.dx = this.recSelectedTime.x + this.recSelectedTime.width - e.getX();
            this.draggingMode = 5;
        } else if (this.recLeftSide.contains(e.getPoint()) && this.isHorizontallyResizible) {
            this.dx = e.getX() - this.recSelectedTime.x;
            this.draggingMode = 4;
        } else {
            this.selectedColumn = (int)((float)e.getX() / this.columnWidth);
            this.selectedRow = (int)((float)e.getY() / this.rowHeight);
            this.updatePhysicalCoordinates();
            this.refreshRects();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.draggingMode != 0) {
            this.draggingMode = 0;
            this.recSelectedTime = (Rectangle)this.recDragged.clone();
            this.refreshRects();
            this.convertPhysicalXYToLogical(this.recSelectedTime);
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        switch (this.draggingMode) {
            case 1: {
                this.doRectangleDragging(e);
                break;
            }
            case 2: {
                this.doUpperSideDragging(e);
                break;
            }
            case 3: {
                this.doLowerSideDragging(e);
                break;
            }
            case 5: {
                this.doRightSideDragging(e);
                break;
            }
            case 4: {
                this.doLeftSideDragging(e);
            }
        }
        if (this.draggingMode != 0) {
            this.convertPhysicalXYToLogical(this.recDragged);
            this.repaint();
            this.scrollRectToVisible(new Rectangle(e.getX(), e.getY(), 1, 1));
        }
    }

    protected void doRectangleDragging(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        int xx = this.getSnappedRectanglePosition(e.getX() - this.dx, this.colX);
        if (xx < 0) {
            return;
        }
        if (xx + this.recDragged.width > this.getWidth()) {
            return;
        }
        this.recDragged.x = xx;
        int yy = this.getSnappedRectanglePosition(e.getY() - this.dy, this.rowY);
        if (yy < 0) {
            return;
        }
        if (yy + this.recDragged.height > this.getHeight()) {
            return;
        }
        this.recDragged.y = yy;
    }

    protected void doLowerSideDragging(MouseEvent e) {
        int y = this.getSnappedRectanglePosition(e.getY() - this.dy, this.rowY);
        this.recDragged.height = y - this.recDragged.y - 1;
        if (this.recDragged.height < 3) {
            this.recDragged.height = (int)this.rowHeight - 1;
        }
    }

    protected void doRightSideDragging(MouseEvent e) {
        int x = this.getSnappedRectanglePosition(e.getX() - this.dx, this.colX);
        this.recDragged.width = x - this.recDragged.x - 1;
        if (this.recDragged.width < 3) {
            this.recDragged.width = (int)this.columnWidth - 1;
        }
    }

    protected void doUpperSideDragging(MouseEvent e) {
        int lowerY = this.recDragged.y + this.recDragged.height;
        int y = this.getSnappedRectanglePosition(e.getY() - this.dy, this.rowY);
        if ((float)(lowerY - y) > this.rowHeight - 1.0f) {
            this.recDragged.y = y;
            this.recDragged.height = lowerY - y;
        }
    }

    protected void doLeftSideDragging(MouseEvent e) {
        int lowerX = this.recDragged.x + this.recDragged.width;
        int x = this.getSnappedRectanglePosition(e.getX() - this.dx, this.colX);
        if ((float)(lowerX - x) >= this.columnWidth) {
            this.recDragged.x = x;
            this.recDragged.width = lowerX - x;
        }
    }

    protected int getSnappedRectanglePosition(int cornerPosition, ArrayList theList) {
        int yS = 0;
        int minY = Integer.MAX_VALUE;
        int dY = 0;
        int nSize = theList.size();
        for (int i = 0; i < nSize; ++i) {
            dY = Math.abs(cornerPosition - (Integer)theList.get(i));
            if (minY <= dY) continue;
            minY = dY;
            yS = (Integer)theList.get(i);
            this.selectedRow = i;
        }
        return yS;
    }

    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    protected void doComponentResized() {
        float w = this.getWidth();
        this.columnWidth = w / (float)this.columnCount;
        float h = this.getHeight();
        this.rowHeight = h / (float)this.rowCount;
        this.calculateGrid();
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    public void componentResized(ComponentEvent e) {
        this.doComponentResized();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }
}

