/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.busysearch.AvailableTimeGrid;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchUtils;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.PositionInterval;
import com.novell.gw.jclient.application.controls.busysearch.TimeGridPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.options.WeekDayMarks;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividShedules
extends TimeGridPanel {
    private static Logger logger = Logger.getLogger(IndividShedules.class);
    private static final Color GRID_COLOR = new Color(170, 170, 170);
    public static int MINUTES_PER_ROW = 15;
    public static int COLUMN_IN_HOUR = 4;
    private static final int HOURS_IN_DAY = 24;
    public static int CELL_WIDTH = PLAFChanger.getFontSize() / 2;
    private static int cellHeight = 16;
    private static int hoursCount = 10;
    private static int startHour = 8;
    private WeekDayMarks weekDayMarks;
    private BitSet columnVisibilityFlags;

    public IndividShedules(MVCController theParent, int startHour, int hoursCount, WeekDayMarks weekDayMarks) {
        super(theParent);
        if (weekDayMarks == null) {
            throw new IllegalArgumentException("weekDayMarks is null");
        }
        this.weekDayMarks = weekDayMarks;
        IndividShedules.startHour = startHour;
        IndividShedules.hoursCount = hoursCount;
        this.isOnlySelectedRecipientShowing = false;
        this.setDaysCount(7);
        this.addKeyListener(new ISKeyListener());
    }

    @Override
    protected void buildView() {
        this.setColumnCount(this.daysCount);
        this.setRowCount(this.rowCount);
        this.rowHeight = this.getFontMetrics(new Font(PLAFChanger.getFontName(), 0, PLAFChanger.getFontSize())).getHeight();
        this.setMinimumCellSize(CELL_WIDTH, cellHeight);
        this.setVerticallyResizible(false);
    }

    public static int getCellHeight() {
        return cellHeight;
    }

    @Override
    protected boolean prevColumn() {
        boolean result;
        boolean bl = result = this.selectedColumn != 0;
        if (result) {
            this.selectedColumn = this.selectedColumn % (hoursCount * COLUMN_IN_HOUR) == 0 ? (int)((float)this.selectedColumn - (float)this.recDragged.width / this.columnWidth) : --this.selectedColumn;
        }
        return result;
    }

    @Override
    protected boolean isDayEnd() {
        return (float)(this.recDragged.x + this.recDragged.width) / this.columnWidth % (float)(hoursCount * COLUMN_IN_HOUR) == 0.0f;
    }

    @Override
    protected boolean isDayStart() {
        return this.selectedColumn % (hoursCount * COLUMN_IN_HOUR) == 0;
    }

    @Override
    protected boolean nextColumn() {
        boolean result;
        float column = (float)(this.recDragged.x + this.recDragged.width) / this.columnWidth;
        boolean bl = result = column * this.columnWidth < (float)this.getWidth();
        if (result) {
            this.selectedColumn = this.isDayEnd() ? (int)column : ++this.selectedColumn;
        }
        return result;
    }

    @Override
    protected boolean prevRow() {
        boolean result;
        boolean bl = result = this.selectedRow > 0;
        if (result) {
            --this.selectedRow;
        }
        return result;
    }

    @Override
    protected boolean nextRow() {
        boolean result;
        boolean bl = result = this.selectedRow < this.rowCount - 1;
        if (result) {
            ++this.selectedRow;
        }
        return result;
    }

    @Override
    protected void drawRectangles(Graphics g, Map<String, List<TimeGridPanel.VisibleIndividualInfo>> map, Color color, boolean drawBorder) {
        Rectangle rr = new Rectangle();
        int insetY = 0;
        int insetW = 0;
        if (drawBorder) {
            insetY = 3;
            insetW = 3;
        }
        for (List<TimeGridPanel.VisibleIndividualInfo> list : map.values()) {
            for (TimeGridPanel.VisibleIndividualInfo visibleIndividualInfo : list) {
                Rectangle r = visibleIndividualInfo.getVisibleRectangle();
                rr.x = Math.round(this.fromLogicalXToPthysical(r.x));
                rr.y = Math.round(this.fromLogicalYToPthysical(r.y)) + insetY;
                rr.width = Math.round(this.fromLogicalXToPthysical(r.width));
                rr.height = Math.round(this.fromLogicalYToPthysical(r.height)) - insetW * 2;
                g.setColor(color);
                g.fillRect(rr.x, rr.y, rr.width, rr.height);
                if (!drawBorder) continue;
                g.setColor(Color.black);
                g.drawRect(rr.x, rr.y, rr.width, rr.height);
            }
        }
    }

    @Override
    protected void drawGrid(Graphics g) {
        g.setColor(GRID_COLOR);
        int i = 0;
        while (Math.round((float)i * this.rowHeight) < this.getHeight()) {
            g.drawLine(0, Math.round((float)i * this.rowHeight), this.getWidth(), Math.round((float)i * this.rowHeight));
            ++i;
        }
        i = 0;
        while (Math.round((float)i * this.columnWidth) < this.getWidth()) {
            if (i % COLUMN_IN_HOUR == 0) {
                int y = Math.round((float)i * this.columnWidth);
                g.drawLine(y, 0, y, this.getHeight());
                if (i % (hoursCount * COLUMN_IN_HOUR) == 0) {
                    g.drawLine(y + 1, 0, y + 1, this.getHeight());
                }
            }
            ++i;
        }
    }

    @Override
    public void setDaysCount(int daysCount) {
        this.daysCount = this.weekDayMarks.countMarkedDays(this.gcStartDay, daysCount);
        this.setColumnCount(this.daysCount * hoursCount * COLUMN_IN_HOUR);
    }

    public int getRowHeight() {
        return Math.round(this.rowHeight);
    }

    public int getDaysCount() {
        return this.daysCount;
    }

    @Override
    public void setAppointmentTime(TimeInterval appointmentTime) {
        this.initCalendar();
        this.gcAppointmentTime.setTime(appointmentTime.getStartDateAsDate());
        PositionInterval interval = this.getLogicalVisibleInterval(appointmentTime);
        int column = interval.getStartPosition();
        if (this.getSelectedColumn() == 0) {
            this.setLogicalPosition(column, this.getSelectedRow());
        } else {
            this.setLogicalPosition(this.getSelectedColumn(), this.getSelectedRow());
        }
        this.setLogicalWidth(interval.getLength());
    }

    @Override
    protected TimeInterval getAppointmentTimeInterval() {
        TimeInterval result = new TimeInterval();
        this.initCalendar();
        this.gcAppointmentTime.setTime(this.gcStartDay.getTime());
        int date = this.getSelectedColumn() / (hoursCount * COLUMN_IN_HOUR);
        if (!this.weekDayMarks.isEveryDayMarked()) {
            date = this.weekDayMarks.countDaysToMarkedDay(this.gcStartDay, date);
        }
        this.gcAppointmentTime.add(5, date);
        this.gcAppointmentTime.set(11, startHour);
        int min = AvailableTimeGrid.MINUTES_PER_ROW * (this.getSelectedColumn() % (hoursCount * COLUMN_IN_HOUR));
        this.gcAppointmentTime.add(12, min);
        result.setStartDate(this.gcAppointmentTime.getTimeInMillis());
        int w = this.getSelectedWidth();
        if (w == 0) {
            w = 1;
        }
        result.setEndDate(this.gcAppointmentTime.getTimeInMillis() + (long)(w * AvailableTimeGrid.MINUTES_PER_ROW * 60000));
        return result;
    }

    public void setUsersCount(int theUsersCount) {
        this.setRowCount(theUsersCount);
    }

    @Override
    public int getSelectedRow() {
        return super.getSelectedRow();
    }

    @Override
    public int getSelectedColumn() {
        return super.getSelectedColumn();
    }

    @Override
    protected void doRectangleDragging(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        int xx = this.getSnappedRectanglePosition(e.getX() - this.dx, this.colX);
        if (xx < 0) {
            return;
        }
        if (xx + this.recDragged.width > this.getWidth()) {
            return;
        }
        int dayWidth = Math.round(this.columnWidth * (float)COLUMN_IN_HOUR * (float)hoursCount);
        int currentDay = e.getX() / dayWidth;
        if (currentDay == (xx + this.recDragged.width - 2) / dayWidth) {
            if (xx / dayWidth != currentDay) {
                xx = dayWidth * currentDay;
            }
            this.recDragged.x = xx;
        }
        this.recDragged.y = this.getSnappedRectanglePosition(e.getY() - this.dy, this.rowY);
    }

    @Override
    protected void doLeftSideDragging(MouseEvent e) {
        int x = this.getSnappedRectanglePosition(e.getX() - this.dx, this.colX);
        int rightX = this.recDragged.x + this.recDragged.width;
        int dayWidth = Math.round(this.columnWidth * (float)COLUMN_IN_HOUR * (float)hoursCount);
        int currentDay = e.getX() / dayWidth;
        if ((float)(rightX - x) >= this.columnWidth && currentDay == (rightX - 2) / dayWidth) {
            this.recDragged.x = x;
            this.recDragged.width = rightX - x;
        } else {
            logger.debug((Object)("can't drag: current day - " + currentDay));
        }
    }

    @Override
    protected void doRightSideDragging(MouseEvent e) {
        int x = this.getSnappedRectanglePosition(e.getX() - this.dx, this.colX);
        int dayWidth = Math.round(this.columnWidth * (float)COLUMN_IN_HOUR * (float)hoursCount);
        int currentDay = (e.getX() - 2) / dayWidth;
        if (currentDay <= this.recDragged.x / dayWidth) {
            this.recDragged.width = x - this.recDragged.x;
            if (this.recDragged.width < 3) {
                this.recDragged.width = (int)this.columnWidth;
            }
        }
    }

    @Override
    protected Rectangle getLogicalRectangle(TimeInterval timeInterval, int index) {
        PositionInterval interval = this.getLogicalVisibleInterval(timeInterval);
        return new Rectangle(interval.getStartPosition(), index, interval.getLength(), 1);
    }

    private PositionInterval getLogicalVisibleInterval(TimeInterval timeInterval) {
        int shiftMilliseconds = this.calculateShiftHours(timeInterval) * 3600000;
        int startPostion = this.calculateAbsoluteLogicalPosition(timeInterval.getStartDate() + (long)shiftMilliseconds);
        int endPostion = this.calculateAbsoluteLogicalPosition(timeInterval.getEndDate() + (long)shiftMilliseconds);
        assert (startPostion >= 0 && endPostion >= 0) : "negative position for interval: " + timeInterval;
        PositionInterval positionInterval = new PositionInterval(startPostion, endPostion);
        assert (this.columnVisibilityFlags != null) : "columnVisibilityFlags was not initialized";
        positionInterval = BusySearchUtils.convertAbsoluteToVisibleInterval(this.columnVisibilityFlags, positionInterval);
        return positionInterval;
    }

    private int calculateAbsoluteLogicalPosition(long millis) {
        long minutes = (millis - this.gcStartDay.getTimeInMillis()) / 60000L;
        return Math.round((float)minutes / (float)MINUTES_PER_ROW);
    }

    @Override
    public void setMVCModel(Object model) {
        GWBusySearch search = (GWBusySearch)model;
        this.populateColumnVisibilityFlags(search.getSearchStartTime(), search.getDaysCount());
        super.setMVCModel(model);
    }

    private void populateColumnVisibilityFlags(Date startDate, int absoluteDayCount) {
        int absoluteColumnCount = absoluteDayCount * 24 * COLUMN_IN_HOUR;
        this.columnVisibilityFlags = new BitSet(absoluteColumnCount);
        Calendar temporaryCalendar = Calendar.getInstance();
        temporaryCalendar.setTimeInMillis(startDate.getTime());
        for (int i = 0; i < absoluteDayCount; ++i) {
            if (this.weekDayMarks.isCalendarDayMarked(temporaryCalendar.get(7))) {
                int dayStartPosition = i * 24 * COLUMN_IN_HOUR;
                int startPosition = dayStartPosition + startHour * COLUMN_IN_HOUR;
                int endPosition = startPosition + hoursCount * COLUMN_IN_HOUR;
                this.columnVisibilityFlags.set(startPosition, endPosition);
            }
            temporaryCalendar.add(7, 1);
        }
    }

    @Override
    protected void doComponentResized() {
        float w = this.getWidth();
        this.columnWidth = w / (float)this.columnCount;
        this.calculateGrid();
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
    }

    private class ISKeyListener
    extends KeyAdapter {
        private ISKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                if (e.isShiftDown()) {
                    if (IndividShedules.this.isDayEnd() && !IndividShedules.this.isDayStart()) {
                        IndividShedules.this.prevColumn();
                        IndividShedules.this.updateRecPosition();
                    }
                    if (!IndividShedules.this.isDayStart() || !IndividShedules.this.isDayEnd()) {
                        IndividShedules.this.recDragged.width += CELL_WIDTH;
                        IndividShedules.this.convertPhysicalXYToLogical(IndividShedules.this.recDragged);
                    }
                }
                if (IndividShedules.this.recDragged.x + IndividShedules.this.recDragged.width <= IndividShedules.this.getWidth() && (float)IndividShedules.this.selectedColumn * IndividShedules.this.columnWidth < (float)IndividShedules.this.getWidth()) {
                    IndividShedules.this.updateRecPosition();
                }
            } else if (e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                if (e.isShiftDown()) {
                    IndividShedules.this.recDragged.width -= CELL_WIDTH;
                    IndividShedules.this.convertPhysicalXYToLogical(IndividShedules.this.recDragged);
                }
                IndividShedules.this.updateRecPosition();
            }
        }
    }

    public static class DayHoursPanel
    extends AvailableTimeGrid.DayLabels {
        private DateFormat sdf = GWCalendarUtils.getDateFormatFull();
        private ArrayList dayLabels;
        static int labelHeight = PLAFChanger.getFontSize() + 10;
        private WeekDayMarks weekDayMarks;

        public DayHoursPanel(int theDaysCount, WeekDayMarks weekDayMarks) {
            super(theDaysCount);
            if (weekDayMarks == null) {
                throw new IllegalArgumentException("weekDayMarks is null");
            }
            this.weekDayMarks = weekDayMarks;
        }

        protected void init() {
            super.init();
            this.dayLabels = new ArrayList();
            this.height = labelHeight;
        }

        protected void setTextToLabel(JLabel lbl, Calendar day, boolean isShortText) {
            lbl.setText(this.sdf.format(day.getTime()));
        }

        protected JLabel getLabel(int i) {
            return (JLabel)this.dayLabels.get(i);
        }

        public void setDaysCount(int daysCount) {
            this.dayLabels.clear();
            super.setDaysCount(daysCount);
            Dimension dim = new Dimension(CELL_WIDTH * COLUMN_IN_HOUR * hoursCount * daysCount, this.height * 2);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
        }

        public void addLabel() {
            JPanel pnl = new JPanel(new BorderLayout());
            OrientableLabel lbl = new OrientableLabel(" ");
            lbl.setHorizontalAlignment(0);
            this.dayLabels.add(lbl);
            pnl.add((Component)lbl, "North");
            pnl.add((Component)new SimpleHourLabel(hoursCount), "South");
            pnl.setBorder(this.labelBorder);
            this.add(pnl);
        }

        public void removeLabel() {
            super.removeLabel();
            this.dayLabels.remove(this.dayLabels.size() - 1);
        }

        public void setTitles(Date startDay, Date currentDay) {
            this.gcStartDay.setTime(startDay);
            Calendar day = GWCalendarUtils.getToday();
            day.setTime(startDay);
            boolean isShort = this.isShortTitle();
            int nCount = this.getComponentCount();
            for (int i = 0; i < nCount; ++i) {
                JLabel lbl = this.getLabel(i);
                if (lbl == null) {
                    return;
                }
                while (!this.weekDayMarks.isCalendarDayMarked(day.get(7))) {
                    day.add(5, 1);
                }
                this.setTextToLabel(lbl, day, isShort);
                day.add(5, 1);
            }
        }

        static class SimpleHourLabel
        extends AvailableTimeGrid.DayLabels {
            private SimpleDateFormat sdf = new SimpleDateFormat("hh", EngineCommandManager.getLocale());
            private Calendar gc = GWCalendarUtils.getToday();

            public SimpleHourLabel(int theHoursCount) {
                this.setDaysCount(theHoursCount);
                this.setTitles(GWCalendarUtils.getToday().getTime(), GWCalendarUtils.getToday().getTime());
            }

            protected void init() {
                super.init();
                this.height = labelHeight;
            }

            public void setTitles(Date theStartDay, Date theCurrentDay) {
                int nCount = this.getComponentCount();
                for (int i = 0; i < nCount; ++i) {
                    JLabel lbl = this.getLabel(i);
                    if (lbl == null) {
                        return;
                    }
                    this.gc.set(11, startHour + i);
                    String text = this.sdf.format(this.gc.getTime());
                    if (text.startsWith("0") && text.length() > 1) {
                        text = text.substring(1);
                    }
                    lbl.setText(text);
                }
            }
        }
    }
}

