/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.novell.gw.ab.DistributionList;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchUtils;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientDescriptionsList
extends ArrayList<RecipientDescription> {
    private static Logger logger = Logger.getLogger(RecipientDescriptionsList.class);

    public RecipientDescriptionsList() {
    }

    public RecipientDescriptionsList(List<IRecipient> list) {
        this.clear();
        if (list.isEmpty()) {
            return;
        }
        for (IRecipient recipient : list) {
            BusySearchUtils.addRecipientDescriptionToList(this, recipient, 0, true);
        }
    }

    public void addAllRecipientDiscriptions(List<RecipientDescription> list) {
        this.addAll(list);
    }

    public List<RecipientDescription> getRecipientDescriptions(RecipientCopyType copyType) {
        ArrayList<RecipientDescription> list = new ArrayList<RecipientDescription>(this.size());
        for (RecipientDescription rd : this) {
            if (!rd.getRecipient().getCopyType().hasRecipientCopyType(copyType) || rd.getRecipient().isUnresolved()) continue;
            list.add(rd);
        }
        return list;
    }

    public int getFailedSize() {
        int result = 0;
        for (RecipientDescription rd : this) {
            if (!rd.isFailed()) continue;
            ++result;
        }
        return result;
    }

    public List<RecipientDescription> getResolvedList() {
        int size = this.size();
        ArrayList<RecipientDescription> list = new ArrayList<RecipientDescription>(size);
        for (RecipientDescription rd : this) {
            if (rd.getRecipient().isUnresolved()) continue;
            list.add(rd);
        }
        return list;
    }

    public RecipientDescription getRecipientDescription(IRecipient recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("recipient is null");
        }
        String recipientId = ABUtils.getRecipientID(recipient);
        RecipientDescription result = null;
        for (RecipientDescription recipientDescription : this) {
            if (!ABUtils.getRecipientID(recipientDescription.getRecipient()).equals(recipientId)) continue;
            result = recipientDescription;
            break;
        }
        return result;
    }

    public DistributionList getDistributionList() {
        DistributionList distributionList = new DistributionList();
        for (RecipientDescription rd : this) {
            distributionList.addRecipient(rd.getRecipient().getNativeRecipient());
        }
        return distributionList;
    }

    public List<IRecipient> getSelectedRecipients(RecipientCopyType copyType) {
        int size = this.size();
        ArrayList<IRecipient> result = new ArrayList<IRecipient>(size);
        for (RecipientDescription recipientDescription : this) {
            if (!recipientDescription.isSelected() || copyType != null && !recipientDescription.getRecipient().getCopyType().hasRecipientCopyType(copyType) || recipientDescription.getRecipient().isUnresolved()) continue;
            result.add(recipientDescription.getRecipient());
        }
        return result;
    }

    public void addRecipientDescription(RecipientDescription newRecipientDescription) {
        if (newRecipientDescription == null) {
            throw new IllegalArgumentException("newRecipientDescription is null");
        }
        super.add(newRecipientDescription);
    }
}

