/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.busysearch.ShedulesInfoController;
import com.novell.gw.jclient.application.controls.busysearch.TimeBlockInfo;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ShedulesInfoPanel
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger(ShedulesInfoPanel.class);
    private ShedulesInfoController shedulesInfoController;
    private JLabel lblStartDate;
    private JLabel lblStartTime;
    private JLabel lblDuration;
    private JPanel panelBusy;
    private JLabel lblReason;
    private JLabel lblFrom;
    private JLabel lblSubject;
    private JLabel lblPlace;

    public ShedulesInfoPanel(MVCController theParentController) {
        super(new CardLayout());
        this.shedulesInfoController = new ShedulesInfoController(this, theParentController);
        this.buildUI();
    }

    private void buildUI() {
        this.buildBusyPanel();
        this.add((Component)this.panelBusy, "BUSY_PANEL");
        String text = this.getComponentOrientation().isLeftToRight() ? "<html><p align=left>" + StringResources.TO_VIEW_INFORMATION + "</p></html>" : "<html><p align=right>" + StringResources.TO_VIEW_INFORMATION + "</p></html>";
        OrientableLabel label = new OrientableLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.add((Component)label, "FREE_PANEL");
    }

    private void buildBusyPanel() {
        this.panelBusy = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.lblReason = new OrientableLabel(" ");
        this.lblStartDate = new OrientableLabel();
        this.lblFrom = new OrientableLabel(" ");
        this.lblStartTime = new OrientableLabel();
        c.anchor = 21;
        c.gridy = 0;
        c.insets = new Insets(2, 10, 2, 10);
        c.gridx = 0;
        this.panelBusy.add((Component)this.lblReason, c);
        c.gridx = 2;
        this.panelBusy.add((Component)new OrientableLabel(StringResources.START_DATE_C), c);
        c.gridx = 3;
        this.panelBusy.add((Component)this.lblStartDate, c);
        c.gridy = 1;
        c.gridx = 0;
        this.panelBusy.add((Component)new OrientableLabel(StringResources.FROM_C), c);
        c.gridx = 1;
        this.panelBusy.add((Component)this.lblFrom, c);
        c.gridx = 2;
        this.panelBusy.add((Component)new OrientableLabel(StringResources.START_TIME_C), c);
        c.gridx = 3;
        this.panelBusy.add((Component)this.lblStartTime, c);
        c.gridy = 2;
        c.gridx = 2;
        this.panelBusy.add((Component)new OrientableLabel(StringResources.DURATION_C), c);
        this.lblDuration = new OrientableLabel();
        c.gridx = 3;
        this.panelBusy.add((Component)this.lblDuration, c);
        c.gridy = 3;
        c.gridx = 0;
        this.panelBusy.add((Component)new OrientableLabel(StringResources.SUBJECT_C), c);
        this.lblSubject = new OrientableLabel(" ");
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelBusy.add((Component)this.lblSubject, c);
        c.gridx = 0;
        c.gridy = 4;
        this.panelBusy.add((Component)new OrientableLabel(StringResources.PLACE_C), c);
        this.lblPlace = new OrientableLabel("");
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelBusy.add((Component)this.lblPlace, c);
        Border outside = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        TitledBorder inside = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), StringResources.APPOINTMENT);
        this.panelBusy.setBorder(BorderFactory.createCompoundBorder(outside, inside));
    }

    public void setTimeBlockInfo(TimeBlockInfo theTimeBlockInfo) {
        if (theTimeBlockInfo.getReason() == null || theTimeBlockInfo.getReason().length() == 0) {
            ((CardLayout)this.getLayout()).show(this, "FREE_PANEL");
            return;
        }
        ((CardLayout)this.getLayout()).show(this, "BUSY_PANEL");
        this.lblStartDate.setText(theTimeBlockInfo.getStartDate());
        this.lblStartTime.setText(theTimeBlockInfo.getStartTime());
        this.lblReason.setText(theTimeBlockInfo.getReason());
        this.lblFrom.setText(theTimeBlockInfo.getFrom());
        this.lblSubject.setText(theTimeBlockInfo.getSubject());
        this.lblDuration.setText(theTimeBlockInfo.getDuration());
        this.lblPlace.setText(theTimeBlockInfo.getPlace());
    }

    public void setController(MVCController theController) {
    }

    public MVCController getController() {
        return this.shedulesInfoController;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return null;
    }
}

