/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.resources.GWIcons;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.BusySearchRecipientResultUserstatus;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.busysearch.BSScrollPane;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.IndividShedules;
import com.novell.gw.jclient.application.controls.busysearch.InfoPanel;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.ShedulesInfoPanel;
import com.novell.gw.jclient.application.controls.busysearch.ShedulesWithListController;
import com.novell.gw.jclient.application.controls.gwcalendar.AbstractCalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.WeekDayMarks;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShedulesWithListPanel
extends AbstractCalendarView
implements MVCView {
    private ShedulesWithListController controller;
    private GWBusySearch busySearch;
    private JList listRecipients;
    private JScrollPane scrollRecipients;
    private DefaultListModel modelRecipients;
    private JScrollPane spShedules = new OrientableScrollPane();
    private JButton inviteButton = new OrientableButton();
    private IndividShedules individSchedules;
    private IndividShedules.DayHoursPanel dayHoursPanel;
    private Rectangle rectListRecipients = new Rectangle();

    public ShedulesWithListPanel(GWBusySearch busySearch, JButton inviteButton, MVCController parentController) {
        this.controller = new ShedulesWithListController(this, parentController);
        this.busySearch = busySearch;
        this.inviteButton = inviteButton;
        this.init();
        this.buildUI();
    }

    private void init() {
        this.initIndividualShedules();
        this.initRecipientsList();
    }

    private void initRecipientsList() {
        this.modelRecipients = new DefaultListModel();
        this.listRecipients = new OrientableList((ListModel)this.modelRecipients);
        this.listRecipients.setCellRenderer(new ListLabel());
        this.listRecipients.setSelectionMode(0);
        this.listRecipients.addListSelectionListener(new RecipientsSelectionListener());
        this.listRecipients.setFixedCellHeight(this.individSchedules.getRowHeight());
        this.listRecipients.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), "remove");
        this.listRecipients.getActionMap().put("remove", new ActionRemoveRecipient());
        this.scrollRecipients = new OrientableScrollPane(this.listRecipients);
        this.scrollRecipients.setHorizontalScrollBarPolicy(31);
        this.scrollRecipients.setVerticalScrollBarPolicy(20);
        this.scrollRecipients.getVerticalScrollBar().addAdjustmentListener(new RecipientsAdjustmentListener());
    }

    private void initIndividualShedules() {
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(userGuid).getDataStoreSettings();
        int startMinutes = (Integer)dataStoreSettings.getBusySearchStartMinutes().getValue();
        int endMinutes = (Integer)dataStoreSettings.getBusySearchEndMinutes().getValue();
        int startHour = startMinutes / 60;
        int endHour = endMinutes / 60 + (endMinutes % 60 > 0 ? 1 : 0);
        int hoursCount = endHour - startHour;
        int mask = (Integer)dataStoreSettings.getBusySearchDays().getValue();
        WeekDayMarks weekDayMarks = WeekDayMarks.createFromGwBitmask(mask);
        this.individSchedules = new IndividShedules(this.getController(), startHour, hoursCount, weekDayMarks);
        this.individSchedules.addMouseListener(new IndividSheduleMouse());
        this.individSchedules.addMouseMotionListener(new IndividSheduleMouseMoution());
        this.dayHoursPanel = new IndividShedules.DayHoursPanel(7, weekDayMarks);
        this.dayHoursPanel.setTitles(GWCalendarUtils.getToday().getTime(), GWCalendarUtils.getToday().getTime());
        this.spShedules = new BSScrollPane(this.individSchedules);
        this.spShedules.setColumnHeaderView(this.dayHoursPanel);
        this.spShedules.setHorizontalScrollBarPolicy(32);
        this.spShedules.setVerticalScrollBarPolicy(22);
        JScrollBar scrollBar = new JScrollBar(1, 0, 1, 0, 13);
        scrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                ShedulesWithListPanel.this.scrollRecipientsToPosition(e.getValue());
            }
        });
        this.spShedules.setVerticalScrollBar(scrollBar);
    }

    public void selectDefaultComponent() {
        this.individSchedules.requestFocusInWindow();
    }

    public JComponent getDefaultComponent() {
        return this.individSchedules;
    }

    public void removeRecipient(RecipientDescription recipientDescription) {
        DefaultListModel model = (DefaultListModel)this.listRecipients.getModel();
        int index = model.indexOf(recipientDescription);
        if (model.removeElement(recipientDescription) && model.getSize() > 0) {
            if (index >= model.getSize()) {
                --index;
            }
            this.listRecipients.setSelectedIndex(index);
        }
    }

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildShedulesPanel());
        this.add(this.buildInfoPanel());
    }

    private JPanel buildShedulesPanel() {
        OrientablePanel p = new OrientablePanel(new GridBagLayout());
        p.setMinimumSize(new Dimension(468, 175));
        p.setPreferredSize(new Dimension(468, 175));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 27);
        p.add((Component)this.inviteButton, c);
        int a = this.spShedules.getColumnHeader().getPreferredSize().height - this.inviteButton.getPreferredSize().height;
        int h = this.spShedules.getHorizontalScrollBar().getPreferredSize().height;
        c.gridy = 1;
        c.weighty = 1.0;
        c.insets = new Insets(a, 0, h, 27);
        p.add((Component)this.scrollRecipients, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        p.add((Component)this.spShedules, c);
        return p;
    }

    private JPanel buildInfoPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        InfoPanel infoIndividualPanel = new InfoPanel(this.getController());
        infoIndividualPanel.setBusyShowing(true);
        ShedulesInfoPanel shedulesInfoPanel = new ShedulesInfoPanel(this.getController());
        pnl.add(shedulesInfoPanel);
        pnl.add(infoIndividualPanel);
        pnl.setBorder(BusySearchFrame.lineBorder);
        return pnl;
    }

    protected void refreshView() {
        if (!this.isShowing()) {
            this.wasViewRefreshed = true;
            return;
        }
        this.wasViewRefreshed = false;
        this.modelRecipients.clear();
        List<RecipientDescription> allList = this.busySearch.getRecipientDescriptionsList().getResolvedList();
        for (RecipientDescription recipientDescription : allList) {
            this.modelRecipients.addElement(recipientDescription);
        }
        this.listRecipients.validate();
        this.individSchedules.setUsersCount(this.modelRecipients.getSize());
        this.listRecipients.setSelectedIndex(0);
        boolean isStillWorking = this.busySearch.isStillWorking();
        this.listRecipients.setEnabled(!isStillWorking);
        this.individSchedules.setMVCModel(this.busySearch);
        this.dayHoursPanel.setDaysCount(this.individSchedules.getDaysCount());
        this.dayHoursPanel.setTitles(this.busySearch.getSearchStartTime(), null);
    }

    public void setController(MVCController theController) {
        this.controller = (ShedulesWithListController)theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof GWBusySearch) {
            this.busySearch = (GWBusySearch)theModel;
            this.refreshView();
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private void scrollRecipientsToPosition(int position) {
        this.rectListRecipients.x = 0;
        this.rectListRecipients.y = position;
        this.rectListRecipients.width = this.scrollRecipients.getWidth();
        this.rectListRecipients.height = this.scrollRecipients.getHeight() - 2;
        this.listRecipients.scrollRectToVisible(this.rectListRecipients);
    }

    void updateSelectionInRecipientList() {
        this.listRecipients.setSelectedIndex(this.individSchedules.getSelectedRow());
    }

    void updateSelectionInSchedules() {
        this.individSchedules.setSelectedRow(this.listRecipients.getSelectedIndex());
    }

    private class ActionRemoveRecipient
    extends AbstractAction {
        private ActionRemoveRecipient() {
        }

        public void actionPerformed(ActionEvent e) {
            Object selectedElement;
            int selectedIndex = ShedulesWithListPanel.this.listRecipients.getSelectedIndex();
            if (selectedIndex != -1 && (selectedElement = ShedulesWithListPanel.this.listRecipients.getModel().getElementAt(selectedIndex)) instanceof RecipientDescription) {
                ShedulesWithListPanel.this.busySearch.removeRecipient((RecipientDescription)selectedElement, ShedulesWithListPanel.this);
            }
        }
    }

    private class RecipientsSelectionListener
    implements ListSelectionListener {
        private RecipientsSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            ShedulesWithListPanel.this.updateSelectionInSchedules();
        }
    }

    private class IndividSheduleMouse
    extends MouseAdapter {
        private IndividSheduleMouse() {
        }

        public void mouseClicked(MouseEvent e) {
            ShedulesWithListPanel.this.updateSelectionInRecipientList();
        }
    }

    private class IndividSheduleMouseMoution
    extends MouseMotionAdapter {
        private IndividSheduleMouseMoution() {
        }

        public void mouseDragged(MouseEvent e) {
            ShedulesWithListPanel.this.updateSelectionInRecipientList();
        }
    }

    class RecipientsAdjustmentListener
    implements AdjustmentListener {
        RecipientsAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            Rectangle aRect = new Rectangle(ShedulesWithListPanel.this.spShedules.getHorizontalScrollBar().getValue(), e.getValue(), ((ShedulesWithListPanel)ShedulesWithListPanel.this).spShedules.getViewport().getSize().width, ((ShedulesWithListPanel)ShedulesWithListPanel.this).spShedules.getViewport().getSize().height);
            ShedulesWithListPanel.this.individSchedules.scrollRectToVisible(aRect);
        }
    }

    class ListLabel
    extends OrientablePanel
    implements ListCellRenderer {
        private Color colorSelected = new Color(8, 36, 106);
        private JLabel lblName = new OrientableLabel();
        private JLabel lblCC = new OrientableLabel();
        private boolean isCrossOver = false;

        public ListLabel() {
            this("");
        }

        public ListLabel(String text) {
            this.buildUI();
            this.setDisplayName(text);
        }

        private void buildUI() {
            this.setLayout(new BoxLayout(this, 2));
            this.lblName.setIcon(GWIcons.EMPTY_ICON);
            this.lblName.setDisabledIcon(GWIcons.EMPTY_ICON);
            this.lblName.setOpaque(false);
            this.lblCC.setOpaque(false);
            this.add(this.lblName);
            this.add(Box.createHorizontalGlue());
            this.add(this.lblCC);
        }

        void setDisplayName(String text) {
            this.lblName.setText(text);
        }

        void setCC(String text) {
            this.lblCC.setText(text);
        }

        public void setForeground(Color fg) {
            if (this.lblName != null && this.lblCC != null) {
                this.lblName.setForeground(fg);
                this.lblCC.setForeground(fg);
            }
        }

        public void setEnabled(boolean enabled) {
            if (this.lblName != null && this.lblCC != null) {
                this.lblName.setEnabled(enabled);
                this.lblCC.setEnabled(enabled);
            }
        }

        public void setFont(Font font) {
            if (this.lblName != null && this.lblCC != null) {
                this.lblName.setFont(font);
                this.lblCC.setFont(font);
            }
        }

        void setCrossOver(boolean isCrossOver) {
            this.isCrossOver = isCrossOver;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isCrossOver) {
                g.setColor(this.lblName.getForeground());
                int width = this.getWidth();
                int halvedHeight = this.getHeight() / 2;
                g.drawLine(0, halvedHeight, width, halvedHeight);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof RecipientDescription)) {
                throw new IllegalArgumentException("Value must be instance of Recipient");
            }
            RecipientDescription recipientDescription = (RecipientDescription)value;
            IRecipient recipient = recipientDescription.getRecipient();
            this.setDisplayName(recipient.getAddressable().getDisplayName());
            this.isCrossOver = recipientDescription.isFailed();
            if (recipient.getCopyType().hasCc()) {
                this.setCC(StringResources.CC);
            } else if (recipient.getCopyType().hasBc()) {
                this.setCC(StringResources.BC);
            } else {
                this.setCC("");
            }
            if (BusySearchRecipientResultUserstatus.COMPLETE_FULL == recipientDescription.getUserstatus()) {
                if (isSelected) {
                    this.lblName.setIcon(ImageResources.ICON_BUSY_I_YELLOW);
                } else {
                    this.lblName.setIcon(ImageResources.ICON_BUSY_I_BLACK);
                }
            } else {
                this.lblName.setIcon(GWIcons.EMPTY_ICON);
            }
            if (isSelected) {
                this.setForeground(Color.white);
                this.setBackground(this.colorSelected);
            } else {
                this.setForeground(Color.black);
                this.setBackground(Color.white);
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.validate();
            return this;
        }
    }
}

