/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.components;

import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public abstract class TimerTextField
extends GWTextField
implements ActionListener {
    private static final int DEFAULT_DELAY = 400;
    private int delay = 400;
    private boolean isTimerOn = true;
    private boolean ignoreNextTimerEvent = false;
    private Timer timer = new Timer(this.delay, this);

    public TimerTextField() {
        this.timer.setRepeats(false);
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.initTimer();
    }

    public void setTimerOn(boolean timerOn) {
        this.isTimerOn = timerOn;
    }

    protected void setIgnoreNextTimerEvent() {
        this.ignoreNextTimerEvent = true;
    }

    protected boolean isTimerOn() {
        return this.isTimerOn;
    }

    private void initTimer() {
        this.timer = new Timer(this.delay, this);
        this.setTimerOn(true);
    }

    protected void startTimer() {
        this.timer.start();
    }

    protected void stopTimer() {
        this.timer.stop();
    }

    protected void restartTimer() {
        this.timer.restart();
    }

    public void setText(String theText) {
        this.setTimerOn(false);
        super.setText(theText);
        this.setTimerOn(true);
    }

    protected boolean isValidString(String s) {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isEditable() && !this.ignoreNextTimerEvent) {
            this.processTimerAction();
        }
        this.ignoreNextTimerEvent = false;
    }

    protected abstract void processTimerAction();

    protected Document createDefaultModel() {
        return new TimerDocument();
    }

    private class TimerDocument
    extends PlainDocument {
        private TimerDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (TimerTextField.this.isValidString(str)) {
                super.insertString(offs, str, a);
                if (TimerTextField.this.isTimerOn()) {
                    TimerTextField.this.restartTimer();
                }
            }
        }

        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            if (TimerTextField.this.isTimerOn()) {
                TimerTextField.this.restartTimer();
            }
        }
    }
}

