/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.jclient.application.controls.contactsearch.AddressSerializable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;

public class AddressesTransferrable
implements Transferable {
    public static DataFlavor addressFlavor = new DataFlavor(AddressSerializable.class, "address");
    private DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor, addressFlavor};
    private String addressesAsString;
    private AddressSerializable[] addresses;

    public AddressesTransferrable(String addressesAsString) {
        this.addressesAsString = addressesAsString;
    }

    public AddressesTransferrable(String addressesAsString, AddressSerializable[] addresses) {
        this(addressesAsString);
        this.addresses = addresses;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.asList(this.flavors).contains(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.addressesAsString;
            }
            if (addressFlavor.equals(flavor)) {
                return this.addresses;
            }
        }
        return null;
    }
}

