/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListCellRenderer;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListModel;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListPopup;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListTransferHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcomponent.GWMouseAdapter;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientList
extends OrientableList
implements MVCView {
    private static Logger logger = Logger.getLogger(RecipientList.class);
    private MVCController controller;
    private ContactSearchComboField comboField;

    public RecipientList(MVCController controller, ContactSearchComboField comboField) {
        super((ListModel)new RecipientListModel((Window)controller.getActionList().getMVCView()));
        this.controller = controller;
        this.comboField = comboField;
        this.init();
    }

    private void init() {
        this.comboField.addSearchListener(new RLSearchListener());
        this.setCellRenderer(new RecipientListCellRenderer());
        this.addMouseListener(new RLMouseListener());
        this.addKeyListener(new RLKeyListener());
        this.addFocusListener(new RLFocusListener());
        this.setDragEnabled(true);
        this.setTransferHandler(new RecipientListTransferHandler(this, this.comboField));
        if (OS.isMacOS()) {
            this.addListSelectionListener(new MACRepainter());
        }
    }

    public void edit(IRecipient recipient) {
        if (!this.comboField.getText().equals("")) {
            this.comboField.addRecipient();
        }
        this.comboField.setText(recipient.getAddressable().getDisplayName());
        if (OS.isMacOS()) {
            int index = this.getModel().removeRecipient(recipient);
            this.selectNearestRow(index);
        } else {
            this.removeRecipient(recipient);
        }
        this.comboField.requestFocus();
    }

    public RecipientCopyType getCopyType() {
        return this.comboField.getCopyType();
    }

    public void selectAtIndex(int selectedIndex) {
        if (selectedIndex >= 0) {
            this.clearSelection();
            this.setSelectedIndex(selectedIndex);
            this.ensureIndexIsVisible(selectedIndex);
        }
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip toolTip = super.createToolTip();
        toolTip.setBackground(ColorConstants.YELLOW);
        return toolTip;
    }

    public RecipientListModel getModel() {
        return (RecipientListModel)super.getModel();
    }

    public void setController(MVCController controller) {
        this.controller = controller;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return null;
    }

    public void addRecipient(IRecipient theRecipient) {
        int selectedIndex = this.getModel().addRecipient(theRecipient);
        this.selectAtIndex(selectedIndex);
    }

    private int selectNearestRow(int theIndex) {
        int size = this.getModel().getSize();
        if (size > 0) {
            if (theIndex <= --size) {
                this.setSelectedIndex(theIndex);
            } else {
                theIndex = size;
                this.setSelectedIndex(theIndex);
            }
        }
        return theIndex;
    }

    private void refreshView() {
        if (this.getModel().getSize() == 0) {
            this.comboField.hidePopup();
            this.comboField.requestFocus();
        }
    }

    public void removeRecipients(List<IRecipient> recipients) {
        int index = this.getModel().removeRecipients(recipients);
        this.selectNearestRow(index);
        this.refreshView();
    }

    public void removeRecipient(IRecipient recipient) {
        int index = this.getModel().removeRecipient(recipient);
        this.selectNearestRow(index);
        this.refreshView();
    }

    public IRecipient getSelectedValue() {
        return (IRecipient)super.getSelectedValue();
    }

    public List<IRecipient> getSelectedRecipients() {
        ArrayList<IRecipient> recipients = new ArrayList<IRecipient>();
        for (Object o : this.getSelectedValues()) {
            if (!(o instanceof IRecipient)) continue;
            recipients.add((IRecipient)o);
        }
        return recipients;
    }

    public static boolean isParentInstanceOfPopup(Component component) {
        if (component == null) {
            return false;
        }
        if (component instanceof RecipientListPopup) {
            return true;
        }
        for (Container p = component.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof RecipientListPopup)) continue;
            return true;
        }
        return false;
    }

    private class MACRepainter
    implements ListSelectionListener {
        private MACRepainter() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            RecipientList.this.repaint();
        }
    }

    private class RLMouseListener
    extends GWMouseAdapter {
        private RLMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.getClickCount() == 2 && !RecipientList.this.getSelectedRecipients().isEmpty()) {
                IRecipient recipient = RecipientList.this.getSelectedRecipients().get(0);
                RecipientList.this.edit(recipient);
            }
        }

        public void showPopup(MouseEvent event) {
            Point point = event.getPoint();
            int index = RecipientList.this.locationToIndex(point);
            RecipientList.this.requestFocus();
            if (index != -1 && (index < RecipientList.this.getMinSelectionIndex() || index > RecipientList.this.getMaxSelectionIndex())) {
                RecipientList.this.setSelectedIndex(index);
            } else {
                RecipientList.this.setSelectedIndices(RecipientList.this.getSelectedIndices());
            }
            RecipientListPopup.getInstance().show(RecipientList.this, point.x, point.y, RecipientList.this.controller);
        }

        public void mousePressed(MouseEvent e) {
            if (OS.isMacOS()) {
                SwingUtilities.getWindowAncestor(RecipientList.this).setFocusableWindowState(true);
                RecipientList.this.requestFocus();
            }
            if (e.isPopupTrigger()) {
                super.mousePressed(e);
            } else {
                RecipientListPopup.getInstance().setVisible(false);
            }
        }
    }

    private class RLKeyListener
    extends KeyAdapter {
        private RLKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            int key = e.getKeyCode();
            int selectedIndex = RecipientList.this.getSelectedIndex();
            if (selectedIndex != -1) {
                if (key == 10) {
                    RecipientList.this.edit(RecipientList.this.getSelectedValue());
                } else if (key == OptionManager.getInstance().getGeneralOptions().getItemDeleteKey()) {
                    RecipientList.this.removeRecipients(RecipientList.this.getSelectedRecipients());
                    e.consume();
                } else if (key == 38 && selectedIndex == 0) {
                    RecipientList.this.comboField.requestFocus();
                }
            }
        }
    }

    private class RLFocusListener
    extends FocusAdapter {
        private RLFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            Component component = e.getOppositeComponent();
            if (RecipientList.isParentInstanceOfPopup(component)) {
                return;
            }
            if (component == null || RecipientList.this.isVisible() && !SwingUtilities.isDescendingFrom(component, RecipientList.this.comboField) && RecipientList.this.getRootPane() != null && !RecipientList.this.getRootPane().equals(component)) {
                logger.debug((Object)("focusLost: " + component));
                RecipientList.this.comboField.hidePopup();
                String text = RecipientList.this.comboField.getText();
                RecipientListModel model = RecipientList.this.getModel();
                if (!text.equals("") && !text.equals(ContactUtils.toString(model.getRecipients()))) {
                    IAddressable addressable = ContactUtils.getAddressForName(text);
                    model.addRecipient(APIAbWrapperManager.createRecipient(addressable, RecipientList.this.comboField.getCopyType()));
                }
                RecipientList.this.comboField.setText(ContactUtils.toString(model.getRecipients()));
            }
        }
    }

    private class RLSearchListener
    implements SearchResultListener {
        private RLSearchListener() {
        }

        public void searchFinished(SearchEvent e) {
            IRecipient recipient = APIAbWrapperManager.createRecipient(e.getFoundContact(), RecipientList.this.comboField.getCopyType());
            RecipientList.this.addRecipient(recipient);
            RecipientList.this.comboField.setText("");
        }
    }
}

