/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filechoser;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.IconedDialog;
import com.novell.gw.jclient.application.controls.filechoser.GWFileFilter;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class GWFileChooser
extends IconedDialog {
    private static Logger logger = Logger.getLogger(GWFileChooser.class);
    private JFileChooser chooser = new JFileChooser();
    private BorderLayout borderlayout = new BorderLayout();
    private String[] selectedPaths = null;
    private String fileName = " ";
    private JTextComponent tfFileName;
    private boolean canceled = false;
    private File suggestedFile;
    public static final int DIALOG_HEIGHT = 500;

    public GWFileChooser(Frame theParent, String theTitle, File theCurrentDir, int theSelectionMode, int theDialogType, boolean multipleEnabled) {
        this(theParent, theTitle, theCurrentDir, null, theSelectionMode, theDialogType, multipleEnabled);
    }

    public GWFileChooser(Frame theParent, String theTitle, File theCurrentDir, File theSelectedFile, int theSelectionMode, int theDialogType, boolean multipleEnabled) {
        super(theParent, true);
        this.setTitle(theTitle);
        this.init(theDialogType, theCurrentDir, theSelectionMode, multipleEnabled, theSelectedFile);
        this.setLocationRelativeTo(theParent);
    }

    public GWFileChooser(Dialog theParent, String theTitle, File theCurrentDir, int theSelectionMode, int theDialogType, boolean multipleEnabled) {
        this(theParent, theTitle, theCurrentDir, null, theSelectionMode, theDialogType, multipleEnabled);
    }

    public GWFileChooser(Dialog theParent, String theTitle, File theCurrentDir, File theSelectedFile, int theSelectionMode, int theDialogType, boolean multipleEnabled) {
        super(theParent, true);
        this.setTitle(theTitle);
        this.init(theDialogType, theCurrentDir, theSelectionMode, multipleEnabled, theSelectedFile);
        this.setLocationRelativeTo(theParent);
    }

    private void init(int theDialogType, File theCurrentDir, int theSelectionMode, boolean multipleEnabled, File theSelectedFile) {
        this.chooser.setDialogType(theDialogType);
        this.chooser.setCurrentDirectory(theCurrentDir);
        this.chooser.setFileSelectionMode(theSelectionMode);
        this.chooser.setMultiSelectionEnabled(multipleEnabled);
        this.suggestedFile = theSelectedFile;
        boolean showHiddenFiles = ApplicationOptions.getInstance().getBoolean("SHOW_HIDDEN_FILES");
        this.chooser.setFileHidingEnabled(!showHiddenFiles);
        if (theSelectedFile != null) {
            this.fileName = theSelectedFile.getPath();
            this.chooser.setSelectedFile(theSelectedFile);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            logger.debug((Object)"Error during creating ChooserDialog object");
            logger.error((Object)e, (Throwable)e);
        }
        this.setPreferredSize(new Dimension(500, 500));
        this.pack();
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }

    public void setFileFilter(FileFilter theFileFilter) {
        this.chooser.setFileFilter(theFileFilter);
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.chooser.getAcceptAllFileFilter();
    }

    public void setAcceptAllFileFilter(boolean b) {
        this.chooser.setAcceptAllFileFilterUsed(b);
    }

    public void removeChoosableFileFilter(FileFilter theFileFilter) {
        this.chooser.removeChoosableFileFilter(theFileFilter);
    }

    public void addChoosableFileFilter(FileFilter theFileFilter) {
        this.chooser.addChoosableFileFilter(theFileFilter);
    }

    private void jbInit() {
        UIUtils.centerWindowOnScreen(this);
        this.getContentPane().setLayout(this.borderlayout);
        if (this.getParent() != null) {
            this.chooser.setLocale(this.getParent().getLocale());
        }
        if (!OS.isMacOS()) {
            this.chooser.setApproveButtonMnemonic(5);
        }
        this.getContentPane().add((Component)this.chooser, "Center");
        ActionListener actionlistener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof JFileChooser) {
                    String string = e.getActionCommand();
                    GWFileChooser.this.chooser;
                    if (string.equalsIgnoreCase("ApproveSelection")) {
                        GWFileChooser.this.onSelect();
                    } else {
                        GWFileChooser.this.onCancel();
                    }
                }
            }
        };
        this.chooser.addActionListener(actionlistener);
        if (OS.isMacOS()) {
            this.lookingForFileNameField();
            if (this.fileName != null) {
                this.tfFileName.setText(this.fileName);
            }
        }
    }

    void onSelect() {
        if (this.chooser.isMultiSelectionEnabled()) {
            File[] selectedFiles = this.chooser.getSelectedFiles();
            int nSize = selectedFiles.length;
            this.selectedPaths = new String[nSize];
            for (int i = 0; i < nSize; ++i) {
                File selectedFile = selectedFiles[i];
                this.selectedPaths[i] = selectedFile.getAbsolutePath();
            }
        } else {
            File selectedFile = this.chooser.getSelectedFile();
            String parentPath = selectedFile.getParentFile().getAbsolutePath();
            String selectedFileName = selectedFile.getName();
            if (this.suggestedFile != null) {
                selectedFileName = Utils.validateExtention(selectedFileName, this.suggestedFile.getName());
            }
            String validatedPath = parentPath + Utils.FILE_SEPARATOR + selectedFileName;
            this.selectedPaths = new String[]{validatedPath};
        }
        this.setVisible(false);
    }

    void onCancel() {
        this.canceled = true;
        this.selectedPaths = null;
        this.setVisible(false);
    }

    public String[] getResult() {
        if (this.selectedPaths != null) {
            for (String selectedPath : this.selectedPaths) {
                FileFilter ff;
                String ext = Utils.getExtention(selectedPath);
                if (ext == null) {
                    ext = "";
                }
                if (ext.length() != 0 && !ext.equals(selectedPath) || !((ff = this.chooser.getFileFilter()) instanceof GWFileFilter)) continue;
                GWFileFilter gwFF = (GWFileFilter)ff;
                this.selectedPaths[i] = selectedPath + gwFF.getExtension();
            }
        }
        return this.selectedPaths;
    }

    public void setSelectedFile(File theFile) {
        this.chooser.setSelectedFile(theFile);
    }

    private void lookingForFileNameField() {
        int nCount = this.chooser.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            JComponent pOld = (JComponent)this.chooser.getComponent(i);
            this.tfFileName = this.findFileNameField(pOld);
            if (this.tfFileName != null) break;
        }
    }

    JTextField findFileNameField(JComponent theComponent) {
        JTextField tc = null;
        int n = theComponent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JComponent comp = (JComponent)theComponent.getComponent(i);
            if (comp instanceof JTextField) {
                return (JTextField)comp;
            }
            if (this.findFileNameField(comp) == null) continue;
            return this.findFileNameField(comp);
        }
        return tc;
    }

    JFileChooser getFileChooser() {
        return this.chooser;
    }

    public void setCurrentDirectory(File theDirectory) {
        this.chooser.setCurrentDirectory(theDirectory);
        this.chooser.updateUI();
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

