/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.utils.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ComponentWithMenu
extends JComponent {
    private JComponent cContent;
    private ALMouseMotionListener mouseMotionListener;
    private ALMouseListener mouseListener;

    public ComponentWithMenu(JComponent theContent, JPopupMenu thePopupMenu) {
        this.setLayout(new BorderLayout());
        this.cContent = theContent;
        JPanel pnlContent = new JPanel();
        pnlContent.setOpaque(false);
        pnlContent.setLayout(new BoxLayout(pnlContent, 0));
        pnlContent.add(this.cContent);
        this.add((Component)pnlContent, "Center");
        this.mouseMotionListener = new ALMouseMotionListener(thePopupMenu);
        this.mouseListener = new ALMouseListener(theContent, thePopupMenu);
        this.addMouseMotionListener(this.mouseMotionListener);
        this.addMouseListener(this.mouseListener);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    public static void initComponent(JComponent component, JPopupMenu thePopupMenu) {
        ComponentWithMenu.removeListeners(component);
        component.addMouseMotionListener(new ALMouseMotionListener(thePopupMenu));
        component.addMouseListener(new ALMouseListener(component, thePopupMenu));
    }

    private static void removeListeners(JComponent component) {
        MouseListener[] mouseListeners = component.getMouseListeners();
        for (int i = 0; i < mouseListeners.length; ++i) {
            MouseListener mouseListener = mouseListeners[i];
            if (!(mouseListener instanceof ALMouseListener)) continue;
            component.removeMouseListener(mouseListener);
        }
        MouseMotionListener[] mouseMotionListeners = component.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListeners.length; ++i) {
            MouseMotionListener mouseMotionListener = mouseMotionListeners[i];
            if (!(mouseMotionListener instanceof ALMouseListener)) continue;
            component.removeMouseMotionListener(mouseMotionListener);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.cContent.setFont(font);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.mouseListener.setPopupMenu(popupMenu);
        this.mouseMotionListener.setPopupMenu(popupMenu);
    }

    private static class ALMouseListener
    extends MouseAdapter {
        private JComponent component;
        private JPopupMenu popupMenu;

        public ALMouseListener(JComponent theComponent, JPopupMenu thePopupMenu) {
            this.component = theComponent;
            this.popupMenu = thePopupMenu;
        }

        public void mousePressed(MouseEvent e) {
            int x = this.component.getWidth() - this.popupMenu.getWidth() / 2;
            this.component.requestFocusInWindow();
            this.popupMenu.show(this.component, x, this.component.getHeight());
            e.getComponent().setCursor(new Cursor(0));
        }

        public void setPopupMenu(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }
    }

    private static class ALMouseMotionListener
    extends MouseMotionAdapter {
        private JPopupMenu popupMenu;

        public ALMouseMotionListener(JPopupMenu thePopupMenu) {
            this.popupMenu = thePopupMenu;
        }

        public void mouseMoved(MouseEvent e) {
            if (!this.popupMenu.isVisible()) {
                e.getComponent().setCursor(new Cursor(12));
            } else {
                e.getComponent().setCursor(new Cursor(0));
            }
        }

        public void setPopupMenu(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }
    }
}

