/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.utils.Utils;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.controls.filter.AbstractFilter;
import org.apache.log4j.Logger;

public class ContactFilter
extends AbstractFilter {
    private static Logger logger = Logger.getLogger(ContactFilter.class);
    private boolean contact;
    private boolean group;
    private boolean resource;
    private boolean organization;
    private String displayName;
    private String emailAddress;
    private String lastName;
    private String firstName;
    private String nameOrganization;
    private String department;
    private boolean systemAddressBook;
    private ICategoryList categories;

    public ContactFilter(AddressBookItemListFilter filter, boolean systemAddressBook) {
        if (filter != null) {
            int contactType = filter.getContactType();
            logger.debug((Object)("contactType: " + contactType));
            this.contact = (contactType & 1) > 0;
            this.group = (contactType & 2) > 0;
            this.resource = (contactType & 4) > 0;
            this.organization = (contactType & 8) > 0;
            this.displayName = filter.getDisplayName();
            this.emailAddress = filter.getEmailAddress();
            this.lastName = filter.getLastName();
            this.firstName = filter.getFirstName();
            this.nameOrganization = filter.getOrganization();
            this.department = filter.getDepartment();
        }
        this.systemAddressBook = systemAddressBook;
    }

    public ContactFilter(boolean systemAddressBook) {
        this.systemAddressBook = systemAddressBook;
        this.contact = true;
        this.group = true;
        this.resource = true;
        this.organization = true;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setOrganization(String nameOrganization) {
        this.nameOrganization = nameOrganization;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getDepartment() {
        return this.department;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getOrganization() {
        return this.nameOrganization;
    }

    public ICategoryList getCategories() {
        return this.categories;
    }

    public void setCategories(ICategoryList categories) {
        this.categories = categories;
    }

    public ItemListFilter getItemListFilter() {
        int contactType;
        AddressBookItemListFilter filter = new AddressBookItemListFilter(this.systemAddressBook);
        if (this.isEmpty()) {
            contactType = 15;
        } else {
            contactType = 0;
            if (this.contact) {
                contactType |= 1;
            }
            if (this.group) {
                contactType |= 2;
            }
            if (this.organization) {
                contactType |= 8;
            }
            if (this.resource) {
                contactType |= 4;
            }
            filter.setDisplayName(this.displayName);
            filter.setFirstName(this.firstName);
            filter.setLastName(this.lastName);
            filter.setOrganization(this.nameOrganization);
            filter.setDepartment(this.department);
            filter.setEmailAddress(this.emailAddress);
            if (this.categories != null) {
                filter.setCategories(this.categories.getNativeCategoryList());
            }
        }
        filter.setContactType(contactType);
        return filter;
    }

    public int getBoxType() {
        return this.getItemListFilter().getBoxType();
    }

    public boolean isContact() {
        return this.contact;
    }

    public void setContact(boolean contact) {
        this.contact = contact;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public boolean isOrganization() {
        return this.organization;
    }

    public void setOrganization(boolean organization) {
        this.organization = organization;
    }

    public boolean isResource() {
        return this.resource;
    }

    public void setResource(boolean resource) {
        this.resource = resource;
    }

    public boolean isEmpty() {
        return (this.contact && this.group && this.resource && this.organization || !this.contact && !this.group && !this.resource && !this.organization) && Utils.isNullOrEmpty(this.displayName) && Utils.isNullOrEmpty(this.firstName) && Utils.isNullOrEmpty(this.lastName) && Utils.isNullOrEmpty(this.nameOrganization) && Utils.isNullOrEmpty(this.department) && Utils.isNullOrEmpty(this.emailAddress) && (this.categories == null || this.categories.getCount() == 0);
    }

    public boolean isSystemAddressBook() {
        return this.systemAddressBook;
    }

    public void setSystemAddressBook(boolean systemAddressBook) {
        this.systemAddressBook = systemAddressBook;
    }
}

