/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.cache.IdentifiedObject;
import com.appframework.utils.IDGenerator;
import com.appframework.utils.Utils;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.application.controls.filter.AbstractFilter;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class CustomFilter
extends AbstractFilter
implements IdentifiedObject {
    private static Logger logger = Logger.getLogger(CustomFilter.class);
    private String ID = IDGenerator.getUIDAsString();
    private String from;
    private String toCC;
    private String subject;
    private String message;
    private ICategoryList categories;
    private Calendar dateFrom;
    private Calendar dateTo;
    private boolean putOnMenu;

    public CustomFilter(String theFrom, String theToCC, String theSubject, String theMessage, ICategoryList theCategories) {
        this.from = theFrom;
        this.toCC = theToCC;
        this.subject = theSubject;
        this.message = theMessage;
        this.categories = theCategories;
        this.dateFrom = null;
        this.dateTo = null;
        logger.debug((Object)("from: " + this.from + ", toCC: " + this.toCC + ", subject: " + this.subject + ", message: " + this.message));
    }

    public CustomFilter(String theFrom, String theToCC, String theSubject, String theMessage, ICategoryList theCategories, Calendar theDateFrom, Calendar theDateTo) {
        this.from = theFrom;
        this.toCC = theToCC;
        this.subject = theSubject;
        this.message = theMessage;
        this.categories = theCategories;
        this.dateFrom = theDateFrom;
        this.dateTo = theDateTo;
        this.initCorrectTime();
        logger.debug((Object)("from: " + this.from + ", toCC: " + this.toCC + ", subject: " + this.subject + ", message: " + this.message + ", dateTo: " + this.dateTo + ", dateFrom: " + this.dateFrom));
    }

    public CustomFilter() {
        this.from = "";
        this.toCC = "";
        this.subject = "";
        this.message = "";
        this.putOnMenu = true;
        this.dateFrom = null;
        this.dateTo = null;
        this.categories = null;
    }

    public void setId(String theId) {
        this.ID = theId;
    }

    public String getID() {
        return this.ID;
    }

    public boolean isPutOnMenu() {
        return this.putOnMenu;
    }

    public void setPutOnMenu(boolean thePutOnMenu) {
        this.putOnMenu = thePutOnMenu;
    }

    public void setFrom(String theFrom) {
        this.from = theFrom;
    }

    public void setToCC(String theToCC) {
        this.toCC = theToCC;
    }

    public void setSubject(String theSubject) {
        this.subject = theSubject;
    }

    public void setMessage(String theMessage) {
        this.message = theMessage;
    }

    public void setUserCreateDate(Calendar theDateFrom, Calendar theDateTo) {
        this.dateFrom = theDateFrom;
        this.dateTo = theDateTo;
        this.initCorrectTime();
    }

    public String getFrom() {
        return this.from;
    }

    public String getToCC() {
        return this.toCC;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public ICategoryList getCategories() {
        return this.categories;
    }

    public void setCategories(ICategoryList categories) {
        this.categories = categories;
    }

    public Calendar getdateFrom() {
        return this.dateFrom;
    }

    public Calendar getdateTo() {
        return this.dateTo;
    }

    private void initCorrectTime() {
        if (this.dateFrom != null && this.dateTo != null) {
            this.dateFrom.set(9, 0);
            this.dateFrom.set(10, 0);
            this.dateFrom.set(12, 0);
            this.dateFrom.set(13, 0);
            this.dateFrom.set(14, 0);
            this.dateTo.set(9, 1);
            this.dateTo.set(10, 11);
            this.dateTo.set(12, 59);
            this.dateTo.set(13, 59);
            this.dateTo.set(14, 999);
        }
    }

    private static boolean isStringValid(String theText) {
        return theText != null && theText.length() != 0;
    }

    public String getDescription() {
        StringBuilder description = new StringBuilder();
        if (CustomFilter.isStringValid(this.from)) {
            description.append("From contains '");
            description.append(this.from);
            description.append("' ");
        }
        if (CustomFilter.isStringValid(this.toCC)) {
            if (description.length() != 0) {
                description.append("and ");
            }
            description.append("To contains '");
            description.append(this.toCC);
            description.append("' or CC contains '");
            description.append(this.toCC);
            description.append("' ");
        }
        if (CustomFilter.isStringValid(this.subject)) {
            if (description.length() != 0) {
                description.append("and ");
            }
            description.append("Subject contains '");
            description.append(this.subject);
            description.append("' ");
        }
        if (CustomFilter.isStringValid(this.message)) {
            if (description.length() != 0) {
                description.append("and ");
            }
            description.append("Message contains '");
            description.append(this.message);
            description.append("' ");
        }
        return description.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.ID.equals(((CustomFilter)obj).ID) && this.from.equals(((CustomFilter)obj).from) && this.toCC.equals(((CustomFilter)obj).toCC) && this.subject.equals(((CustomFilter)obj).subject) && this.message.equals(((CustomFilter)obj).message) && this.putOnMenu == ((CustomFilter)obj).putOnMenu && this.dateFrom.equals(((CustomFilter)obj).dateFrom) && this.dateTo.equals(((CustomFilter)obj).dateTo) && this.categories.equals(((CustomFilter)obj).categories);
    }

    public ItemListFilter getItemListFilter() {
        ItemListFilter itemListFilter = new ItemListFilter();
        if (this.from != null && this.from.length() != 0) {
            itemListFilter.setFromText(this.from);
        }
        if (this.subject != null && this.subject.length() != 0) {
            itemListFilter.setSubject(this.subject);
        }
        if (this.toCC != null && this.toCC.length() != 0) {
            itemListFilter.setToCc(this.toCC);
        }
        if (this.message != null && this.message.length() != 0) {
            itemListFilter.setMessage(this.message);
        }
        if (this.categories != null) {
            itemListFilter.setCategories(this.categories.getNativeCategoryList());
        }
        if (this.dateFrom != null && this.dateTo != null) {
            itemListFilter.setUserCreateDateRange(this.dateFrom.getTime(), this.dateTo.getTime());
        }
        itemListFilter.setBoxType(this.getBoxType());
        return itemListFilter;
    }

    public boolean isEmpty() {
        return !(!Utils.isNullOrEmpty(this.from) || !Utils.isNullOrEmpty(this.subject) || !Utils.isNullOrEmpty(this.toCC) || !Utils.isNullOrEmpty(this.message) || this.dateFrom != null && this.dateTo != null || this.categories != null && this.categories.getCount() != 0);
    }
}

