/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.impl.folder.FakeNewCalendarFolderImpl;
import com.novell.gw.jclient.api.impl.folder.FakeNewContactsFolderImpl;
import com.novell.gw.jclient.api.impl.folder.FakeNewFolderImpl;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.folder.ActionRenameFolder;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.ScrollPaneBorderHighlightFocusListener;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeCellEditor;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeController;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeModelUtils;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeSerializer;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTreeRenderer;
import com.novell.gw.jclient.application.controls.folderstree.dnd.FoldersTreeDropTargetListener;
import com.novell.gw.jclient.application.controls.folderstree.dnd.MainGWFoldersTreeDragGestureListener;
import com.novell.gw.jclient.application.controls.itemlisttable.IconsFactory;
import com.novell.gw.jclient.application.controls.menus.FolderPopupMenu;
import com.novell.gw.jclient.application.dialogs.folderproperties.ColorChooserButton;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MainGWFoldersTree
extends GWFoldersTree {
    private static final int TIMER_DELAY = 400;
    private static Logger logger = Logger.getLogger(MainGWFoldersTree.class);
    private int gtkToNonGtkSwitchWorkaroundCounter = 0;
    private TreeRefreshTimer timer;
    private AbstractFolder dragTargetFolder;
    private AbstractFolder popupFolder;
    public AbstractFolder lastSelectedFolder;
    private GWFoldersTreeSelectionListener selectionListener;
    public static ColorChooserButton colorChooser = new ColorChooserButton(Color.red);
    private GWFolderTreeExpansionListener expansionListener = new GWFolderTreeExpansionListener();
    private boolean refreshBlocked = false;
    private boolean isEditNewFolder = false;
    private boolean isFocused = false;

    public MainGWFoldersTree(MVCController parentController, String userGuid) {
        super(parentController, userGuid);
        this.setExpandsSelectedPaths(true);
        this.setExpandsSelectedPaths(true);
        this.timer = new TreeRefreshTimer(400, new TimerAction());
        this.setDropTarget(new DropTarget(this, 3, new FoldersTreeDropTargetListener(this)));
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 2, new MainGWFoldersTreeDragGestureListener(this));
        this.scrollsOnExpand = true;
        MainGWFoldersTreeRenderer renderer = new MainGWFoldersTreeRenderer(this);
        this.setCellRenderer(renderer);
        GWFoldersTreeCellEditor cellEditor = new GWFoldersTreeCellEditor(this, renderer);
        this.setCellEditor(cellEditor);
        this.selectionListener = new GWFoldersTreeSelectionListener();
        this.addMouseListener(new MainGWFoldersTreeMouseListener());
        GWFoldersTreeSerializer.restore(this);
        this.addTreeExpansionListener(this.expansionListener);
        this.addFocusListener(new ScrollPaneBorderHighlightFocusListener(this));
        this.addFocusListener(new MainTreeFocusListener());
    }

    public String getName() {
        return "MainGWFoldersTree";
    }

    void setEditNewFolder(boolean isEditNewFolder) {
        this.isEditNewFolder = isEditNewFolder;
    }

    boolean isEditNewFolder() {
        return this.isEditNewFolder;
    }

    public String getUIClassID() {
        String classID = PLAFChanger.isCustomFolderTreeUIUsed() && this.gtkToNonGtkSwitchWorkaroundCounter != 1 ? "FoldersTreeUI" : super.getUIClassID();
        if (this.gtkToNonGtkSwitchWorkaroundCounter > 0) {
            --this.gtkToNonGtkSwitchWorkaroundCounter;
        }
        return classID;
    }

    public void updateUI() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && "javax.swing.plaf.synth.SynthTreeUI".equals(treeUI.getClass().getName()) && "FoldersTreeUI".equals(this.getUIClassID())) {
            logger.debug((Object)"switch from GTK to another LAF, usind gtkToNonGtkSwitchWorkaroundCounter");
            this.gtkToNonGtkSwitchWorkaroundCounter = 2;
        }
        super.updateUI();
        this.updateChildIndent();
    }

    private void updateChildIndent() {
        TreeUI treeUI = this.getUI();
        if (treeUI instanceof BasicTreeUI && (LookAndFeelManager.isNimbusLookAndFeel() || LookAndFeelManager.isGtkLookAndFeel())) {
            BasicTreeUI basicTreeUI = (BasicTreeUI)treeUI;
            if (!this.getComponentOrientation().isLeftToRight()) {
                basicTreeUI.setRightChildIndent(IconsFactory.getCollapsedIcon().getIconWidth() / 2);
            }
            basicTreeUI.setLeftChildIndent(basicTreeUI.getLeftChildIndent() + 4);
        }
    }

    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        this.updateChildIndent();
    }

    public static AbstractFolder getFolderForPath(TreePath thePath) {
        if (thePath == null) {
            return null;
        }
        Object lastPathComponent = thePath.getLastPathComponent();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)lastPathComponent;
        if (treeNode.getUserObject() instanceof AbstractFolder) {
            return (AbstractFolder)treeNode.getUserObject();
        }
        return null;
    }

    public void repaintDragFolder(Point cursorPos) {
        super.repaintDragFolder(cursorPos);
        this.dragTargetFolder = MainGWFoldersTree.getFolderForPath(this.getPathForRow(this.lastSelectedRow));
    }

    public void selectDefaultStartItem() {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        IFolder folder = APIFolderWrapperManager.getFolder(accountSettings.getStartupFolder());
        String userGuid = this.getOwnerFrameUserGUID();
        if (folder == null || folder.getType() == FolderType.UNIVERSAL) {
            this.selectNode(this.getFolderNode(FoldersCache.getMailboxFolder(userGuid)), true);
        } else if (folder.getType() == FolderType.USER) {
            try {
                AbstractFolder rootFolder = GWCommandManager.getInstance(userGuid).getRootFolder();
                this.selectNode(this.getFolderNode(rootFolder), true);
            }
            catch (GWCommandException e) {
                logger.error((Object)"GWCommandException caught > rethrowing");
                throw new RuntimeException(e);
            }
        }
        Rectangle pathBounds = this.getPathBounds(this.getSelectionPath());
        this.scrollRectToVisible(pathBounds);
        this.scrollRowToVisible(this.getSelectionRows()[0]);
    }

    public void refreshTree(boolean doReload) {
        if (this.refreshBlocked) {
            return;
        }
        AbstractFolder oldSelectedFolder = this.getSelectedFolder();
        this.removeTreeSelectionListener(this.selectionListener);
        this.removeTreeExpansionListener(this.expansionListener);
        super.refreshTree(doReload);
        GWFoldersTreeSerializer.restore(this);
        if (doReload) {
            this.lastSelectedFolder = null;
        }
        if (oldSelectedFolder != null) {
            String userGuid = ControlsUtils.getUserGuid(this.controller);
            oldSelectedFolder = GWCommandManager.getInstance(userGuid).findFolderInCurrentDataStore(oldSelectedFolder);
            this.selectNode(this.getFolderNode(oldSelectedFolder), doReload);
        } else {
            this.selectDefaultStartItem();
        }
        if (!Arrays.asList(this.getTreeSelectionListeners()).contains(this.selectionListener)) {
            this.addTreeSelectionListener(this.selectionListener);
        }
        this.addTreeExpansionListener(this.expansionListener);
        this.getController().processCommand(new Command(1430, Boolean.TRUE));
    }

    public AbstractFolder getSelectedFolder() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null) {
            return (AbstractFolder)((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
        }
        return null;
    }

    public void selectFolder(AbstractFolder theFolder) {
        DefaultMutableTreeNode node = this.getFolderNode(theFolder);
        if (node != null) {
            this.selectNode(node, false);
        }
    }

    public void selectNode(DefaultMutableTreeNode theNode, boolean doFreshSelection) {
        this.removeTreeSelectionListener(this.selectionListener);
        AbstractFolder newFolder = (AbstractFolder)theNode.getUserObject();
        TreePath treePath = new TreePath(theNode.getPath());
        this.setSelectionPath(treePath);
        if (!newFolder.equals(this.lastSelectedFolder)) {
            this.executeRule(false);
            this.lastSelectedFolder = (AbstractFolder)theNode.getUserObject();
            this.executeRule(true);
            Command command = new Command(10, this.lastSelectedFolder);
            command.setAttribute((Object)AttributeKey.FOCUSED, this.isFocusOwner());
            command.setAttribute((Object)AttributeKey.SOURCE, this);
            this.getController().processCommand(command);
            if (!this.isEditing()) {
                command = new Command(1090, this.lastSelectedFolder);
                command.setAttribute("FORCE_REFRESH", doFreshSelection);
                this.getController().processCommand(command);
            }
        }
        if (!Arrays.asList(this.getTreeSelectionListeners()).contains(this.selectionListener)) {
            this.addTreeSelectionListener(this.selectionListener);
        }
    }

    public void startEditingAtPath(TreePath path) {
        if (this.isEditable()) {
            this.setRefreshBlocked(true);
        }
        super.startEditingAtPath(path);
    }

    private void executeRule(boolean b) {
        try {
            if (this.lastSelectedFolder != null) {
                this.lastSelectedFolder.getNativeFolder().executeRules(b);
            }
        }
        catch (EngineException e) {
            logger.error((Object)e);
        }
    }

    private DefaultMutableTreeNode getMailBoxNode() {
        DefaultMutableTreeNode mailboxNode = GWFoldersTreeModelUtils.getMailboxTreeNode((DefaultMutableTreeNode)this.getModel().getRoot());
        if (mailboxNode == null) {
            logger.debug((Object)"MAILBOX IS UNAVALIABLE FOR SYSTEM");
            mailboxNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        }
        return mailboxNode;
    }

    private DefaultMutableTreeNode getFolderNode(AbstractFolder theFolder) {
        DefaultMutableTreeNode folderNode = GWFoldersTreeModelUtils.getFolderTreeNode((DefaultMutableTreeNode)this.getModel().getRoot(), theFolder);
        if (folderNode == null) {
            return this.getMailBoxNode();
        }
        return folderNode;
    }

    public void expandFolder(AbstractFolder theFolder) {
        this.expandPath(new TreePath(this.getFolderNode(theFolder).getPath()));
    }

    public AbstractFolder getPopupFolder() {
        return this.popupFolder;
    }

    public void setPopupFolder(AbstractFolder thePopupFolder) {
        this.popupFolder = thePopupFolder;
    }

    public AbstractFolder getDragTargetFolder() {
        return this.dragTargetFolder;
    }

    public void setDragTargetFolder(AbstractFolder theDragTargetFolder) {
        this.dragTargetFolder = theDragTargetFolder;
    }

    protected void doPopup(MouseEvent e) {
        logger.debug((Object)e);
        if (e.isPopupTrigger()) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            if (row < 0) {
                return;
            }
            TreePath path = this.getPathForRow(row);
            if (path == null) {
                return;
            }
            this.popupFolder = (AbstractFolder)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            ActionList actionList = this.getController().getActionList();
            if (actionList instanceof ApplicationFrameActionList) {
                TreeCellEditor cellEditor = this.getCellEditor();
                if (cellEditor instanceof GWFoldersTreeCellEditor) {
                    ((GWFoldersTreeCellEditor)cellEditor).stopTimer();
                }
                FolderPopupMenu popup = FolderPopupMenu.createFolderPopupMenu(this.popupFolder, (ApplicationFrameActionList)actionList);
                ((ActionRenameFolder)actionList.getAction(ActionKey.RENAME_FOLDER_LIGHT)).setIsClickInTree(true);
                if (!e.getComponent().isShowing()) {
                    e.getComponent().setVisible(true);
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
                this.repaint();
            }
        }
    }

    private boolean checkColorChooser(MouseEvent e) {
        DefaultMutableTreeNode node;
        AbstractFolder folder;
        int y;
        int x = e.getX();
        int row = this.getRowForLocation(x, y = e.getY());
        TreePath path = this.getPathForRow(row);
        if (path != null && (folder = (AbstractFolder)(node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof SubCalendarFolder && !(folder.getNativeFolder() instanceof FakeNewFolderImpl) && MainGWFoldersTree.isColorClicked(e, this.getCellRenderer(), this.getPathBounds(path))) {
            colorChooser.setColor(((SubCalendarFolder)folder).getColor());
            colorChooser.setInvoker(folder);
            colorChooser.getColorMenu().show(this, e.getX(), e.getY());
            return true;
        }
        return false;
    }

    private boolean checkSubCalendar(MouseEvent e) {
        int y;
        int x = e.getX();
        int row = this.getRowForLocation(x, y = e.getY());
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            AbstractFolder folder = (AbstractFolder)node.getUserObject();
            if (!(folder instanceof SubCalendarFolder)) {
                return false;
            }
            if (MainGWFoldersTree.isCheckBoxClicked(e, this.getCellRenderer(), this.getPathBounds(path))) {
                ((SubCalendarFolder)folder).setSubCalendarShown(!folder.isSubCalendarShown());
                ((DefaultTreeModel)this.getModel()).nodeChanged(node);
                return true;
            }
        }
        return false;
    }

    public static boolean isCheckBoxClicked(MouseEvent e, TreeCellRenderer treeRenderer, Rectangle pathBounds) {
        int x = e.getX();
        int y = e.getY();
        Rectangle checkBounds = ((MainGWFoldersTreeRenderer)treeRenderer).getCheckBounds();
        int checkXBegin = pathBounds.x + checkBounds.x;
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            checkXBegin = pathBounds.x + pathBounds.width - checkBounds.width;
        }
        int checkXEnd = checkBounds.width + checkXBegin;
        int checkYBegin = pathBounds.y + checkBounds.y;
        int checkYEnd = checkBounds.height + checkYBegin;
        return x > checkXBegin && x < checkXEnd && y > checkYBegin && y < checkYEnd;
    }

    public static boolean isColorClicked(MouseEvent e, TreeCellRenderer treeRenderer, Rectangle pathBounds) {
        int x = e.getX();
        int y = e.getY();
        Rectangle checkBounds = ((MainGWFoldersTreeRenderer)treeRenderer).getCheckBounds();
        int checkXBegin = pathBounds.x + checkBounds.x + checkBounds.width;
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            checkXBegin = pathBounds.x + pathBounds.width - checkBounds.width - 12;
        }
        int checkXEnd = checkXBegin + 12;
        int checkYBegin = pathBounds.y + checkBounds.y;
        int checkYEnd = checkBounds.height + checkYBegin;
        return x > checkXBegin && x < checkXEnd && y > checkYBegin && y < checkYEnd;
    }

    public void setRefreshBlocked(boolean refreshBlocked) {
        this.refreshBlocked = refreshBlocked;
    }

    public void setSelectionPath(TreePath treePath) {
        logger.debug((Object)treePath);
        super.setSelectionPath(treePath);
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void createNewFolder(AbstractFolder parentFolder, String name) {
        FakeNewFolderImpl nativeFolder = new FakeNewFolderImpl(parentFolder.getNativeFolder(), name);
        this.doCreateNewFolder(parentFolder, nativeFolder);
    }

    public void createNewCalendarFolder(AbstractFolder parentFolder, String name) {
        FakeNewCalendarFolderImpl nativeFolder = new FakeNewCalendarFolderImpl(parentFolder.getNativeFolder(), name);
        this.doCreateNewFolder(parentFolder, nativeFolder);
    }

    public void createNewContactsFolder(AbstractFolder parentFolder, String name) {
        FakeNewContactsFolderImpl nativeFolder = new FakeNewContactsFolderImpl(parentFolder.getNativeFolder(), name);
        this.doCreateNewFolder(parentFolder, nativeFolder);
    }

    private void doCreateNewFolder(AbstractFolder parentFolder, FakeNewFolderImpl fakeNewFolder) {
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        AbstractFolder newFolder = EngineCommandManager.getInstance(userGuid).getGWFolder(fakeNewFolder);
        DefaultMutableTreeNode parentNode = this.getFolderNode(parentFolder);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newFolder);
        int insertPosition = 0;
        if (fakeNewFolder.getType() == FolderType.CALENDAR) {
            insertPosition = parentNode.getChildCount();
        }
        ((DefaultTreeModel)this.getModel()).insertNodeInto(childNode, parentNode, insertPosition);
        this.setEditNewFolder(true);
        this.setEditable(true);
        TreePath path = new TreePath(parentNode.getPath()).pathByAddingChild(childNode);
        this.startEditingAtPath(path);
    }

    public void removeNewFolder(AbstractFolder newFolder) {
        assert (newFolder.getNativeFolder() instanceof FakeNewFolderImpl) : "illegal new folder is canceled: " + newFolder.getNativeFolder();
        DefaultMutableTreeNode node = this.getFolderNode(newFolder);
        this.setEditable(false);
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
    }

    private class MainTreeFocusListener
    extends FocusAdapter {
        private MainTreeFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            MainGWFoldersTree.this.drawItFocused(false);
            MainGWFoldersTree.this.isFocused = false;
        }

        public void focusGained(FocusEvent e) {
            MainGWFoldersTree.this.isFocused = true;
            TreePath selectedPath = MainGWFoldersTree.this.getSelectionPath();
            if (selectedPath == null) {
                return;
            }
            Object selectedObject = selectedPath.getLastPathComponent();
            if (selectedObject instanceof DefaultMutableTreeNode) {
                AbstractFolder folder = (AbstractFolder)((DefaultMutableTreeNode)selectedObject).getUserObject();
                if (folder == null) {
                    return;
                }
                if (folder instanceof ContactsFolder && !((ContactsFolder)folder).hasAddressBook()) {
                    logger.warn((Object)("folder with NULL address book detected: " + folder));
                    return;
                }
                GWFoldersTreeController controller = MainGWFoldersTree.this.getController();
                Command command = new Command(10, folder);
                command.setAttribute((Object)AttributeKey.FOCUSED, Boolean.TRUE);
                command.setAttribute((Object)AttributeKey.SOURCE, MainGWFoldersTree.this);
                controller.processCommand(command);
                command = new GlobalCommand(1980, MainGWFoldersTree.this);
                controller.processCommand(command);
                MainGWFoldersTree.this.drawItFocused(true);
            }
        }
    }

    public class GWFolderTreeExpansionListener
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent event) {
            this.doSave();
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.doSave();
        }

        private void doSave() {
            GWFoldersTreeSerializer.save(MainGWFoldersTree.this);
        }
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MainGWFoldersTree tree = MainGWFoldersTree.this;
            TreePath selectedPath = tree.getSelectionPath();
            if (selectedPath == null) {
                return;
            }
            Object selectedObject = selectedPath.getLastPathComponent();
            if (selectedObject instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedObject;
                tree.selectNode(node, true);
            }
        }
    }

    private class TreeRefreshTimer
    extends Timer {
        public TreeRefreshTimer(int delay, TimerAction theListener) {
            super(delay, theListener);
            this.setRepeats(false);
        }

        public void flash() {
            this.stop();
            this.fireActionPerformed(new ActionEvent(this, 0, null, System.currentTimeMillis(), 0));
        }

        public void start() {
            Command command = new Command(470);
            MainGWFoldersTree.this.getController().processCommand(command);
            super.start();
        }
    }

    private class GWFoldersTreeSelectionListener
    implements TreeSelectionListener {
        private GWFoldersTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            MainGWFoldersTree mainGWFoldersTree = (MainGWFoldersTree)e.getSource();
            if (mainGWFoldersTree.getSelectedFolder() != null) {
                boolean newFakeFolder = mainGWFoldersTree.getSelectedFolder().getNativeFolder() instanceof FakeNewFolderImpl;
                mainGWFoldersTree.setEditable(newFakeFolder || mainGWFoldersTree.getSelectedFolder().canRename());
            }
            MainGWFoldersTree.this.timer.restart();
        }
    }

    private class MainGWFoldersTreeMouseListener
    implements MouseListener {
        private MainGWFoldersTreeMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (!MainGWFoldersTree.this.isFocusOwner() && !MainGWFoldersTree.this.checkColorChooser(e)) {
                MainGWFoldersTree.this.requestFocus();
            }
            MainGWFoldersTree.this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            if (!MainGWFoldersTree.this.isFocusOwner() && !MainGWFoldersTree.this.checkColorChooser(e)) {
                MainGWFoldersTree.this.requestFocus();
            }
            MainGWFoldersTree.this.doPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger() && !MainGWFoldersTree.this.checkColorChooser(e)) {
                MainGWFoldersTree.this.timer.flash();
                MainGWFoldersTree.this.checkSubCalendar(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

