/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewAllDayEvent;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.AllDayAppointmentItemStatusLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.AllDayEventsGridLayout;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigateCreateItem;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigationCreateItemKeyboardListener;
import com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.TypingWindow;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AcceptsDroppedCalendarItems;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDragGestureListener;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemDropTargetListener;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DateWatchPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyView;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllDayEventsBoxesPanel
extends DateWatchPanel
implements NavigateCreateItem,
AcceptsDroppedCalendarItems {
    private static Logger logger = Logger.getLogger(AllDayEventsBoxesPanel.class);
    private ArrayList allDayEvents;
    private Calendar startDate;
    private List<AbstractItem> items;
    private int days;
    private LabelMouseClick labelMouseListener;
    private Rectangle dragRect;
    private boolean isLTR = UIUtils.getComponentOrientation().isLeftToRight();
    private AbstractItem itemSel;

    public AllDayEventsBoxesPanel(MVCController theParentController, int theSize, boolean drawBorders) {
        super(theParentController);
        this.days = theSize;
        this.setLayout(new AllDayEventsGridLayout(this.days));
        this.setFocusable(true);
        this.addKeyListener(new NavigationCreateItemKeyboardListener(this));
        this.addMouseListener(new BoxMouseListener());
        this.labelMouseListener = new LabelMouseClick();
        this.allDayEvents = new ArrayList();
        this.setDropTarget(new DropTarget(this, 3, new CalendarItemDropTargetListener(this, this.getController())));
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AllDayEventsBoxesPanel.this.getController().getParentController() != null) {
                    MVCView mvcView = AllDayEventsBoxesPanel.this.getController().getParentController().getMVCView();
                    if (mvcView instanceof DailyView) {
                        ((DailyView)mvcView).setFocusedPanel(AllDayEventsBoxesPanel.this);
                    } else if (mvcView instanceof WeeklyView) {
                        ((WeeklyView)mvcView).setFocusedPanel(AllDayEventsBoxesPanel.this);
                    }
                }
            }
        });
    }

    @Override
    public void navigateUP() {
    }

    @Override
    public void navigateDOWN() {
    }

    @Override
    public void navigateLEFT() {
        GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
        assert (gwCalendarController != null);
        gwCalendarController.itemSelected(null);
        Calendar gc = (Calendar)this.getCurrentDate().clone();
        gc.add(5, -1);
        this.adjustCurrentTime(gc);
    }

    @Override
    public void navigateRIGHT() {
        GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
        assert (gwCalendarController != null);
        gwCalendarController.itemSelected(null);
        Calendar gc = (Calendar)this.getCurrentDate().clone();
        gc.add(5, 1);
        this.adjustCurrentTime(gc);
    }

    @Override
    public void createItem() {
        ActionList aList = this.getController().getActionList();
        AppAction action = aList.getAction(ActionKey.NEW_ALL_DAY_EVENT);
        ((ActionNewAllDayEvent)action).setSelectedDate(this.getCurrentDate().getTime());
        ((ActionNewAllDayEvent)action).setCalendarView(true);
        action.actionPerformed(null);
    }

    @Override
    public void quickCreateItem(char thePressedChar) {
        int selectedDay = this.getCurrentDate().get(5) - this.startDate.get(5);
        Point newLocation = this.isLTR ? new Point(selectedDay * this.getWidth() / this.days, 0) : new Point(this.getWidth() - (selectedDay + 1) * this.getWidth() / this.days, 0);
        SwingUtilities.convertPointToScreen(newLocation, this);
        int height = this.getParent() instanceof JViewport ? this.getParent().getHeight() : this.getHeight();
        Dimension newSize = new Dimension(this.getWidth() / this.days, height);
        TypingWindow.getInstance(SwingUtilities.windowForComponent(this)).show("AllDayEvent", (Calendar)this.getCurrentDate().clone(), String.valueOf(thePressedChar), newLocation, newSize, this.getController());
    }

    public void loadItemsForDate(Calendar gcStartDay, IItemList itemList) {
        Calendar start = (Calendar)gcStartDay.clone();
        Calendar end = (Calendar)start.clone();
        end.add(5, this.days);
        this.startDate = start;
        this.items = new ArrayList<AbstractItem>();
        this.items.addAll(GWCalendarUtils.getAllDayEvents(itemList, start.getTime(), end.getTime()));
        ((AllDayEventsGridLayout)this.getLayout()).setFirstDate(gcStartDay);
        this.refreshLabels(itemList);
    }

    public int getCountOfItemsForCurrentDate(Calendar gcStartDay, IItemList itemList) {
        Calendar start = (Calendar)gcStartDay.clone();
        return GWCalendarUtils.getAllDayEvents(itemList, start.getTime()).size();
    }

    public int getMaxCountOfElements() {
        if (this.items == null) {
            return 0;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        HashMap<String, Integer> freqElementsPosition = new HashMap<String, Integer>();
        for (AbstractItem item : this.items) {
            String key = new String(sdf.format(item.getDate()));
            Integer oldCount = (Integer)freqElementsPosition.get(key);
            Integer newCount = oldCount == null ? new Integer(1) : new Integer(oldCount + 1);
            freqElementsPosition.put(key, newCount);
        }
        ArrayList list = new ArrayList(freqElementsPosition.values());
        Collections.sort(list);
        return list.size() > 0 ? (Integer)list.get(list.size() - 1) : 0;
    }

    public void refreshLabels(IItemList itemList) {
        this.removeLabels();
        for (AbstractItem item : this.items) {
            StaticItemLabel label = this.getLabelForItem(false, new ItemAndItemListInfo(itemList, item));
            if (item.equals(this.itemSel)) {
                label.setSelected(true);
                GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
                assert (gwCalendarController != null);
                gwCalendarController.itemSelected((IItem)item.getNativeItem());
            }
            this.allDayEvents.add(label);
            this.add(label);
            label.addMouseListener(this.labelMouseListener);
        }
        this.validate();
    }

    protected void removeLabels() {
        this.removeAll();
        this.allDayEvents.clear();
        this.repaint();
    }

    public void setItemSel(AbstractItem itemSel) {
        this.itemSel = itemSel;
    }

    public void addBoxAndLoadData(Calendar theDate, List<? extends AbstractItem> appointments, IItemList itemList) {
        ++this.days;
        ((AllDayEventsGridLayout)this.getLayout()).setDays(this.days);
        this.items.addAll(appointments);
        this.refreshLabels(itemList);
        this.getLayout().layoutContainer(this);
    }

    public void removeBox(IItemList itemList) {
        --this.days;
        ((AllDayEventsGridLayout)this.getLayout()).setDays(this.days);
        this.refreshLabels(itemList);
        this.getLayout().layoutContainer(this);
    }

    protected StaticItemLabel getLabelForItem(boolean multiline, ItemAndItemListInfo itemAndItemListInfo) {
        AllDayAppointmentItemStatusLabel label = new AllDayAppointmentItemStatusLabel(multiline, itemAndItemListInfo, GWCalendarUtils.getShowAsLevelColor(((AppointmentItem)itemAndItemListInfo.getItem()).getShowAsLevel()), this.getController(), false);
        CalendarItemDragGestureListener dragListener = new CalendarItemDragGestureListener(label, ControlsUtils.getUserGuid(this.getController()));
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(label, 3, dragListener);
        return label;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int boxWidth = this.getWidth() / this.days;
        g.setColor(Color.WHITE);
        if (this.isLTR) {
            g.fillRect(0, 0, boxWidth * this.days, this.getHeight());
        } else {
            g.fillRect(this.getWidth() - boxWidth * this.days - 1, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(Color.GRAY);
        for (int i = 0; i < this.days; ++i) {
            if (this.isLTR) {
                g.drawLine(i * boxWidth, 0, i * boxWidth, this.getHeight());
                g.drawLine((i + 1) * boxWidth - 1, 0, (i + 1) * boxWidth - 1, this.getHeight());
                continue;
            }
            g.drawLine(this.getWidth() - i * boxWidth - 1, 0, this.getWidth() - i * boxWidth - 1, this.getHeight());
            g.drawLine(this.getWidth() - ((i + 1) * boxWidth - 1) - 1, 0, this.getWidth() - ((i + 1) * boxWidth - 1) - 1, this.getHeight());
        }
        Graphics2D g2 = (Graphics2D)UIUtils.enableAntialiasing(g);
        this.drawDragRect(g2);
    }

    private void drawDragRect(Graphics2D g2) {
        if (this.dragRect == null) {
            return;
        }
        g2.setColor(Color.BLUE);
        g2.setStroke(AppointmentPanel.HOUR_LINE_STROKE);
        g2.drawRect(this.dragRect.x, this.dragRect.y, this.dragRect.width, this.dragRect.height);
        g2.setStroke(AppointmentPanel.DEFAULT_LINE_STROKE);
        g2.setColor(Color.BLACK);
    }

    private Calendar getDateAtPoint(Point thePoint) {
        int boxWidth = this.getWidth() / this.days;
        int selectedDay = this.isLTR ? thePoint.x / boxWidth : (this.getWidth() - thePoint.x) / boxWidth;
        Calendar date = null;
        if (this.startDate != null) {
            Calendar gc = (Calendar)this.startDate.clone();
            gc.add(5, selectedDay);
            date = this.getDateWithAdjustedTime(gc);
        }
        return date;
    }

    private Calendar getDateWithAdjustedTime(Calendar gc) {
        gc.set(10, this.getCurrentDate().get(10));
        gc.set(12, this.getCurrentDate().get(12));
        gc.set(9, this.getCurrentDate().get(9));
        return gc;
    }

    private void handleClick(Point thePoint) {
        Calendar date = this.getDateAtPoint(thePoint);
        if (date != null && !GWCalendarUtils.isSameDate(this.getCurrentDate(), date)) {
            this.adjustCurrentTime(date);
        }
    }

    @Override
    public Date getDragDate() {
        if (this.dragRect != null) {
            return GWCalendarUtils.clearTime(this.getDateAtPoint(new Point(this.dragRect.x, this.dragRect.y))).getTime();
        }
        return null;
    }

    @Override
    public void highlightDragHours(Point theLocation, long theDurationInMinutes) {
        int x;
        int boxWidth = this.getWidth() / this.days;
        if (this.isLTR) {
            int selectedDay = theLocation.x / boxWidth;
            x = selectedDay * boxWidth + 2;
        } else {
            int selectedDay = (this.getWidth() - theLocation.x) / boxWidth;
            x = this.getWidth() - (selectedDay + 1) * boxWidth + 2;
        }
        int y = 2;
        int w = boxWidth - 4;
        int h = this.getHeight() - 4;
        this.dragRect = new Rectangle(x, y, w, h);
        Rectangle rect = new Rectangle(x, y - 20, w, h + 40);
        this.scrollRectToVisible(rect);
        this.repaint();
    }

    @Override
    public void clearHighlightDragHours() {
        this.dragRect = null;
        this.repaint();
    }

    @Override
    public boolean acceptsDraggableItem(AbstractItem item) {
        return item != null;
    }

    private class LabelMouseClick
    extends MouseAdapter {
        private LabelMouseClick() {
        }

        public void mousePressed(MouseEvent e) {
            if (!AllDayEventsBoxesPanel.this.isFocusOwner()) {
                AllDayEventsBoxesPanel.this.grabFocus();
            }
            Point point = e.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)e.getSource());
            SwingUtilities.convertPointFromScreen(point, AllDayEventsBoxesPanel.this);
            AllDayEventsBoxesPanel.this.handleClick(point);
        }
    }

    private class BoxMouseListener
    extends MouseAdapter {
        private BoxMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (OS.isDoubleClick(e)) {
                DateWatchPanel panel = (DateWatchPanel)e.getSource();
                GWCalendar.createNewCalendarItem("AllDayEvent", panel.getCurrentDate().getTime(), AllDayEventsBoxesPanel.this.getController(), true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            if (!AllDayEventsBoxesPanel.this.isFocusOwner()) {
                AllDayEventsBoxesPanel.this.grabFocus();
            }
            Point point = e.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)e.getSource());
            SwingUtilities.convertPointFromScreen(point, AllDayEventsBoxesPanel.this);
            GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(AllDayEventsBoxesPanel.this.getController());
            assert (gwCalendarController != null);
            gwCalendarController.itemSelected(null);
            AllDayEventsBoxesPanel.this.handleClick(point);
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GWCalendarPopup pop = this.createPopup(e);
                pop.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private GWCalendarPopup createPopup(MouseEvent e) {
            DateWatchPanel panel = (DateWatchPanel)e.getSource();
            MVCController controller = panel.getController();
            return new GWCalendarPopup("AllDayEvent", panel.getCurrentDate().getTime(), controller);
        }
    }
}

