/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveTypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggleEvent;

public class PanelTypesToggle
extends ActiveTypesToggle {
    private IViewDisplaySettings displaySettings;

    public PanelTypesToggle(IViewDisplaySettings theDisplaySettings) {
        super("CALENDAR_ON_PANEL");
        this.displaySettings = theDisplaySettings;
        this.loadFromSettings();
    }

    private void loadFromSettings() {
        this.showAppointments = GWCalendarUtils.isShowCalendarAppointments(this.displaySettings);
        this.showNotes = GWCalendarUtils.isShowCalendarNotes(this.displaySettings);
        this.showTasks = GWCalendarUtils.isShowCalendarTasks(this.displaySettings);
    }

    private void updateDisplaySettings() {
        GWCalendarUtils.setShowCalendarItems(this.showAppointments, this.showTasks, this.showNotes, this.displaySettings);
    }

    public void setShowAppointments(boolean appointmentsShowing) {
        if (appointmentsShowing != this.showAppointments) {
            this.showAppointments = appointmentsShowing;
            this.fireToggleChanged(new TypesToggleEvent(0));
            this.updateDisplaySettings();
        }
    }

    public void setShowNotes(boolean notesShowing) {
        if (notesShowing != this.showNotes) {
            this.showNotes = notesShowing;
            this.fireToggleChanged(new TypesToggleEvent(1));
            this.updateDisplaySettings();
        }
    }

    public void setShowTasks(boolean tasksShowing) {
        if (tasksShowing != this.showTasks) {
            this.showTasks = tasksShowing;
            this.fireToggleChanged(new TypesToggleEvent(2));
            this.updateDisplaySettings();
        }
    }
}

