/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.gwcalendar.CheckBoxItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaskItemLabel
extends CheckBoxItemLabel {
    private static Logger logger = Logger.getLogger(TaskItemLabel.class);
    public static final Color TASK_NOT_COMPLETED_DUE_TODAY_COLOR = new Color(0, 127, 0);
    public static final Color TASK_NOT_COMPLETED_PAST_DUE_COLOR = Color.RED;
    public static int FIRST_COLUMN_WIDTH = 15;

    public TaskItemLabel(boolean isMultiLine, ItemAndItemListInfo itemAndItemListInfo, Color backColor, MVCController theParentController) {
        super(isMultiLine, itemAndItemListInfo, backColor, theParentController, true);
        this.itemType = "Task";
    }

    protected void paintSelection(Graphics g) {
        int x1;
        if (!this.checkboxLTRInit) {
            this.initLTRCheckbox();
        }
        Graphics2D g2D = (Graphics2D)g;
        Color c = g2D.getColor();
        int x = this.isLTR ? 0 : this.getWidth() - FIRST_COLUMN_WIDTH;
        g2D.setColor(Color.WHITE);
        AbstractItem item = this.getItem();
        if (!item.isStatusCompleted()) {
            TaskItem task = (TaskItem)item;
            Date startDate = task.getStartDate();
            Date endDate = task.getEndDate();
            Date today = GWCalendarUtils.getToday().getTime();
            if (!item.isStatusCompleted() && GWCalendarUtils.isSameDate(today, startDate)) {
                if (GWCalendarUtils.isSameDate(today, endDate)) {
                    g2D.setPaint(TASK_NOT_COMPLETED_DUE_TODAY_COLOR);
                } else if (!GWCalendarUtils.isSameDate(today, endDate) && GWCalendarUtils.getDifferenceInSeconds(today, endDate) > 0L) {
                    g2D.setPaint(TASK_NOT_COMPLETED_PAST_DUE_COLOR);
                }
            }
        }
        g2D.fillRect(x, 0, FIRST_COLUMN_WIDTH, this.getHeight());
        g2D.setColor(Color.WHITE);
        g2D.fill(this.getCheckbox());
        int n = x1 = this.isLTR ? FIRST_COLUMN_WIDTH : 0;
        if (this.isLTR) {
            g2D.setPaint(new GradientPaint(FIRST_COLUMN_WIDTH + 1, 0.0f, item.getCalendarDisplayColor(), (float)this.getWidth() * 1.5f, 0.0f, item.getCalendarDisplayFinalGradientColor()));
        } else {
            g2D.setPaint(new GradientPaint(FIRST_COLUMN_WIDTH + 1, (float)(-this.getWidth()) * 0.5f, item.getCalendarDisplayFinalGradientColor(), this.getWidth(), 0.0f, item.getCalendarDisplayColor()));
        }
        g2D.fillRect(x1, 0, this.getWidth() - FIRST_COLUMN_WIDTH, this.getHeight());
        this.paintSelectionBorder(g2D);
        g2D.setColor(c);
    }
}

