/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class TimeRange {
    private Calendar start;
    private Calendar end;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public TimeRange(Calendar start, Calendar end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public TimeRange() {
        this(Calendar.getInstance(), Calendar.getInstance());
    }

    public Calendar getStart() {
        return (Calendar)this.start.clone();
    }

    public void setRange(Calendar start, Calendar end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setStart(Calendar newValue) {
        if (this.start != newValue || this.start != null && !this.start.equals(newValue)) {
            Calendar oldValue = this.start;
            this.start = (Calendar)newValue.clone();
            this.firePropertyChanged(new PropertyChangeEvent(this, "start", oldValue, newValue));
        }
    }

    public void setStart(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        this.setStart(instance);
    }

    public Calendar getEnd() {
        return (Calendar)this.end.clone();
    }

    public void setEnd(Calendar newValue) {
        if (this.end != newValue || this.end != null && !this.end.equals(newValue)) {
            Calendar oldValue = this.end;
            this.end = (Calendar)newValue.clone();
            this.firePropertyChanged(new PropertyChangeEvent(this, "end", oldValue, newValue));
        }
    }

    public void setEnd(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        this.setEnd(instance);
    }

    private void firePropertyChanged(PropertyChangeEvent event) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public boolean addPropertyChangeListener(PropertyChangeListener changeListener) {
        return this.listeners.add(changeListener);
    }

    public boolean removePropertyChangeListener(PropertyChangeListener changeListener) {
        return this.listeners.remove(changeListener);
    }
}

