/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties;

import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.resources.StringResources;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesViewList
implements Serializable {
    private List<PropertiesViewListItem> items = new ArrayList<PropertiesViewListItem>();
    private static List<CalendarViewType> calendarViewTypes = new ArrayList<CalendarViewType>();
    private static List<PropertiesViewListItem> staticItems;

    public PropertiesViewList() {
        this.initItems();
    }

    public PropertiesViewList(PropertiesViewList theList) {
        int nSize = theList.size();
        for (int i = 0; i < nSize; ++i) {
            this.items.add(new PropertiesViewListItem(theList.getListItem(i)));
        }
    }

    public PropertiesViewList(List theList) {
        int nSize = theList.size();
        for (int i = 0; i < nSize; ++i) {
            this.items.add(new PropertiesViewListItem(((PropertiesViewListItem)theList.get(i)).getName(), ((PropertiesViewListItem)theList.get(i)).getView()));
        }
    }

    private void initItems() {
        PropertiesViewListItem item = new PropertiesViewListItem(staticItems.get(0));
        this.items.add(item);
        item = new PropertiesViewListItem(staticItems.get(1));
        item.setName(StringResources.WEEK);
        this.items.add(item);
        item = new PropertiesViewListItem(staticItems.get(2));
        this.items.add(item);
        item = new PropertiesViewListItem(staticItems.get(3));
        this.items.add(item);
    }

    public void add(PropertiesViewListItem item) {
        this.items.add(item);
    }

    public void add(String name, CalendarViewType calendarViewType) {
        this.items.add(new PropertiesViewListItem(name, calendarViewType));
    }

    public void remove(int i) {
        if (i < this.size()) {
            this.items.remove(i);
        }
    }

    public void remove(PropertiesViewListItem item) {
        if (this.items.contains(item)) {
            this.items.remove(item);
        }
    }

    public void clear() {
        this.items.clear();
    }

    public String getName(int i) {
        if (i < this.size()) {
            return this.items.get(i).getName();
        }
        return null;
    }

    public CalendarViewType getView(int i) {
        if (i < this.size() && i > -1) {
            return this.items.get(i).getView();
        }
        return null;
    }

    public List getList() {
        return this.items;
    }

    public PropertiesViewListItem getListItem(int i) {
        if (i < this.size()) {
            return this.items.get(i);
        }
        return null;
    }

    public void setName(int i, String name) {
        if (i < this.size()) {
            this.getListItem(i).setName(name);
        }
    }

    public void setView(int i, CalendarViewType calendarViewType) {
        if (i < this.size()) {
            this.getListItem(i).setView(calendarViewType);
        }
    }

    public void setItem(int i, PropertiesViewListItem item) {
        if (i < this.size()) {
            this.items.set(i, item);
        }
    }

    public void changeItems(int i, int j) {
        PropertiesViewListItem temp = this.getListItem(j);
        this.setItem(j, this.getListItem(i));
        this.setItem(i, temp);
    }

    public int size() {
        return this.items.size();
    }

    public static List getViewTypesList() {
        return calendarViewTypes;
    }

    public static List<PropertiesViewListItem> getItemTypesList() {
        return staticItems;
    }

    public int getItemIndex(PropertiesViewListItem item) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getListItem(i).equals(item)) continue;
            return i;
        }
        return -1;
    }

    public List<String> getNamesList() {
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < this.items.size(); ++i) {
            result.add(this.getListItem(i).getName());
        }
        return result;
    }

    static {
        calendarViewTypes.add(CalendarViewType.DAILY);
        calendarViewTypes.add(CalendarViewType.WEEKLY);
        calendarViewTypes.add(CalendarViewType.MONTHLY);
        calendarViewTypes.add(CalendarViewType.YEARLY);
        staticItems = new ArrayList<PropertiesViewListItem>();
        staticItems.add(new PropertiesViewListItem(StringResources.DAY, CalendarViewType.DAILY));
        staticItems.add(new PropertiesViewListItem(StringResources.WEEK, CalendarViewType.WEEKLY));
        staticItems.add(new PropertiesViewListItem(StringResources.MONTH, CalendarViewType.MONTHLY));
        staticItems.add(new PropertiesViewListItem(StringResources.YEAR, CalendarViewType.YEARLY));
    }
}

