/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.Application;
import com.appframework.drag.DragManager;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import sun.awt.dnd.SunDragSourceContextPeer;

public class CalendarItemDragGestureListener
implements DragGestureListener {
    private static Logger logger = Logger.getLogger(CalendarItemDragGestureListener.class);
    private ActiveItemLabel label;
    private String userID;

    public CalendarItemDragGestureListener(ActiveItemLabel theLabel, String userID) {
        this.label = theLabel;
        this.userID = userID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (dge.getTriggerEvent() instanceof MouseEvent && ((MouseEvent)dge.getTriggerEvent()).getButton() == 2) {
            return;
        }
        if ((dge.getDragAction() & 3) > 0) {
            logger.debug((Object)">>---recognizer");
            AbstractItem item = this.label.getItem();
            if (item instanceof AbstractCalendarItem) {
                logger.debug((Object)">>---recognizer");
                dge.getSourceAsDragGestureRecognizer().setSourceActions(3);
                BufferedImage image = new BufferedImage(100, 100, 3);
                Graphics2D g2 = image.createGraphics();
                g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
                OrientableLabel label = new OrientableLabel(ImageResources.ICON_MESSAGE);
                label.paint(g2);
                ImageResources.ICON_START_QUERY_FOLDER.getImage();
                DragManager.getInstance().setItem(item);
                try {
                    SunDragSourceContextPeer.checkDragDropInProgress();
                }
                catch (InvalidDnDOperationException e) {
                    SunDragSourceContextPeer.setDragDropInProgress(false);
                }
                finally {
                    dge.startDrag(DragSource.DefaultMoveNoDrop, image, new Point(0, 0), new CalendarItemWrapper((AbstractCalendarItem)item), new CalendarItemDragSourceListener());
                }
            }
        }
    }

    private static class CalendarItemDragSourceListener
    extends DragSourceAdapter {
        private int userAction;

        private CalendarItemDragSourceListener() {
        }

        public void dragOver(DragSourceDragEvent dsde) {
            this.userAction = dsde.getUserAction();
            if (this.userAction == 1) {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
            } else if (this.userAction == 2) {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
            this.userAction = dsde.getUserAction();
        }

        public void dragExit(DragSourceEvent dse) {
            if (this.userAction == 1) {
                dse.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            } else if (this.userAction == 2) {
                dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragManager.getInstance().setItem(null);
        }
    }

    private class CalendarItemWrapper
    implements Transferable {
        private DataFlavor[] flavors;
        private AbstractCalendarItem item;
        private String userGuid;
        private String folderID;

        public CalendarItemWrapper(AbstractCalendarItem theItem) {
            this.item = theItem;
            this.userGuid = CalendarItemDragGestureListener.this.userID;
            this.folderID = Application.getGWMainAppFrame().getFolder().getID();
            this.flavors = new DataFlavor[]{GWFlavors.transferItemsFlavor, GWFlavors.userGuidFlavor, GWFlavors.folderFlavor};
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(this.flavors).contains(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(GWFlavors.transferItemsFlavor)) {
                IItemList itemList = GWCommandManager.getInstance(CalendarItemDragGestureListener.this.userID).getItemListForItem(this.item);
                int[] indexes = new int[]{itemList.indexOf((IItem)this.item.getNativeItem())};
                return itemList.getTransferItems(indexes);
            }
            if (flavor.equals(GWFlavors.userGuidFlavor)) {
                return this.userGuid;
            }
            if (flavor.equals(GWFlavors.folderFlavor)) {
                return this.folderID;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

