/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.MultiLineLabelBox;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.StaticCalendarItemPanelController;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticCalendarItemPanel
extends MultiLineLabelBox
implements MVCView,
Cloneable {
    private static Logger logger = Logger.getLogger(StaticCalendarItemPanel.class);
    private Calendar currentDay;
    private boolean isMultiLineLabels = true;
    private ArrayList allDayEvents;
    private ArrayList notes;
    private ArrayList tasks;
    private boolean showAllDayEvents;
    private boolean showNotes;
    private boolean showTasks;
    private AbstractItem itemSel;
    protected IItemList itemList;
    private StaticCalendarItemPanelController controller;

    public StaticCalendarItemPanel(boolean multiLineLabels, MVCController theParentController) {
        this.controller = new StaticCalendarItemPanelController(this, theParentController);
        this.currentDay = GWCalendarUtils.getToday();
        this.isMultiLineLabels = multiLineLabels;
        this.allDayEvents = new ArrayList();
        this.notes = new ArrayList();
        this.tasks = new ArrayList();
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return null;
    }

    public void setController(MVCController theController) {
        this.controller = (StaticCalendarItemPanelController)theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public Calendar getCurrentDate() {
        return this.currentDay;
    }

    protected void setCurrentDay(Calendar theCurrentDay) {
        this.currentDay = theCurrentDay;
    }

    public boolean isMultiLineLabels() {
        return this.isMultiLineLabels;
    }

    public void setItems(Calendar theDate, List<? extends AbstractItem> items, IItemList itemList, String theItemType) {
        ArrayList labels = this.getLabels(theItemType);
        this.removeLabels(labels);
        this.currentDay = (Calendar)theDate.clone();
        for (AbstractItem abstractItem : items) {
            StaticItemLabel label = this.createLabel(this.isMultiLineLabels, new ItemAndItemListInfo(itemList, abstractItem));
            if (abstractItem.equals(this.itemSel)) {
                label.setSelected(true);
                GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
                assert (gwCalendarController != null);
                gwCalendarController.itemSelected((IItem)abstractItem.getNativeItem());
            }
            labels.add(label);
        }
    }

    public void setItemSel(AbstractItem itemSel) {
        this.itemSel = itemSel;
    }

    public void setItems(Calendar theDate, IItemList itemList, String theItemType) {
        this.setItems(theDate, GWCalendarUtils.getCalendarItems(itemList, theDate.getTime(), theItemType), itemList, theItemType);
    }

    public void cloneItems(String theItemType, StaticCalendarItemPanel theAnotherPanel) {
        ArrayList thisLabels = this.getLabels(theItemType);
        this.removeLabels(thisLabels);
        ArrayList anotherLabels = theAnotherPanel.getLabels(theItemType);
        for (Object anotherLabel : anotherLabels) {
            StaticItemLabel label = (StaticItemLabel)anotherLabel;
            StaticItemLabel newLabel = this.createLabel(this.isMultiLineLabels, new ItemAndItemListInfo(label.getItemList(), label.getItem()));
            newLabel.setSelected(label.isSelected());
            thisLabels.add(newLabel);
        }
    }

    protected StaticItemLabel createLabel(boolean multiline, ItemAndItemListInfo itemAndItemListInfo) {
        return this.getLabelForItem(multiline, itemAndItemListInfo);
    }

    protected abstract StaticItemLabel getLabelForItem(boolean var1, ItemAndItemListInfo var2);

    public ArrayList getLabels(String theItemType) {
        if ("AllDayEvent".equals(theItemType)) {
            return this.allDayEvents;
        }
        if ("Note".equals(theItemType)) {
            return this.notes;
        }
        if ("Task".equals(theItemType)) {
            return this.tasks;
        }
        throw new IllegalArgumentException("Specified item type [" + theItemType + "] is not supported");
    }

    protected void removeLabels(ArrayList theLabels) {
        int nSize = theLabels.size();
        for (int i = 0; i < nSize; ++i) {
            StaticItemLabel label = (StaticItemLabel)theLabels.get(i);
            this.disposeLabel(label);
            this.remove(label);
        }
        theLabels.clear();
    }

    protected void disposeLabel(StaticItemLabel theLabel) {
    }

    public void setShowItems(boolean show, String theItemType) {
        this.setVisibility(show, theItemType);
        this.reloadComponents();
        this.validate();
        this.repaint();
    }

    private void reloadComponents() {
        this.removeAll();
        if (this.showAllDayEvents) {
            this.addItems(this.getLabels("AllDayEvent"));
        }
        if (this.showTasks) {
            this.addItems(this.getLabels("Task"));
        }
        if (this.showNotes) {
            this.addItems(this.getLabels("Note"));
        }
    }

    private void addItems(ArrayList theItems) {
        int nSize = theItems.size();
        for (int i = 0; i < nSize; ++i) {
            this.add((StaticItemLabel)theItems.get(i));
        }
    }

    private void setVisibility(boolean visible, String theItemType) {
        if ("AllDayEvent".equals(theItemType)) {
            this.showAllDayEvents = visible;
        } else if ("Note".equals(theItemType)) {
            this.showNotes = visible;
        } else if ("Task".equals(theItemType)) {
            this.showTasks = visible;
        } else {
            throw new IllegalArgumentException("Specified item type [" + theItemType + "] is not supported");
        }
    }

    protected boolean isShowItems(String theItemType) {
        if ("AllDayEvent".equals(theItemType)) {
            return this.showAllDayEvents;
        }
        if ("Note".equals(theItemType)) {
            return this.showNotes;
        }
        if ("Task".equals(theItemType)) {
            return this.showTasks;
        }
        throw new IllegalArgumentException("Specified item type [" + theItemType + "] is not supported");
    }

    public void removeItems() {
        this.removeLabels(this.getLabels("AllDayEvent"));
        this.removeLabels(this.getLabels("Note"));
        this.removeLabels(this.getLabels("Task"));
    }
}

