/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.IItemListComponentDataModel;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarViewController;
import com.novell.gw.jclient.application.controls.gwcalendar.DayBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GradientBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.BorderedCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.CalendarItemPanelPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.StaticCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.GlassPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.YearlyCalendar;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class MonthlyView
extends CalendarView {
    private static int CAL_SIZE = 42;
    private BorderedCalendarItemPanel[] bxDays;
    private Border borderHeader;
    private Border borderCurrent;
    private Border borderTodayCurrent;
    private Border borderToday;
    private int minimumCellWidth;
    private int minimumCellHeight;
    private Calendar[] days;
    private TimeInterval viewInterval;
    private GlassPanel glassPanel;
    private DayBorder borderDefault;
    private CalendarItemPanelPopup popup;
    private ArrayList<JLabel> weekNumberLabelList;
    private OrientablePanel pnlHeaderDates;
    private OrientablePanel pnlWeekNumber;
    private OrientablePanel pnlEmpty;
    private TimeInterval refreshedInterval = new TimeInterval(-1L, -1L);

    public MonthlyView(Calendar theCurrentDay, TypesToggle theToggle, MVCController theParentController, boolean showMonthPicker, IItemListComponentDataModel calendarItemListData) {
        super(theCurrentDay, theToggle, theParentController, showMonthPicker, calendarItemListData);
        this.buildUI();
    }

    protected MVCController createController(MVCController theParentController) {
        return new CalendarViewController(this, theParentController);
    }

    protected void buildUI() {
        this.days = new Calendar[CAL_SIZE];
        this.bxDays = new BorderedCalendarItemPanel[CAL_SIZE];
        this.borderCurrent = new DayBorder(DayBorder.BORDER_DAY_SELECTED, 2);
        this.borderTodayCurrent = new DayBorder(DayBorder.BORDER_TODAY_SELECTED, 2);
        this.borderToday = new DayBorder(DayBorder.BORDER_TODAY_UNSELECTED);
        this.borderHeader = new LineBorder(Color.GRAY, 1);
        this.borderDefault = new DayBorder(DayBorder.BORDER_DAY_UNSELECTED);
        this.minimumCellWidth = 70;
        this.minimumCellHeight = 50;
        this.setFocusable(false);
        this.buildYearlyCalendarComponent();
        this.initTitleLable();
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(1));
        this.lblTitle.setOpaque(true);
        this.lblTitle.setBorder(this.borderHeader);
        this.lblTitle.setBackground(Color.WHITE);
        this.titlePanel.add((Component)this.lblTitle, "Center");
        this.popup = new CalendarItemPanelPopup(this.getController());
        this.glassPanel = new GlassPanel(this.buildGrid(), this.popup, this);
        OrientablePanel pnlMonthes = new OrientablePanel(new GridBagLayout());
        this.setLayout(new BorderLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        pnlMonthes.add((Component)this.titlePanel, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        this.pnlEmpty = this.createEmptyPanel();
        pnlMonthes.add((Component)this.pnlEmpty, constraints);
        this.pnlEmpty.setVisible(this.showWeekNumber);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        this.pnlHeaderDates = this.createHeader();
        pnlMonthes.add((Component)this.pnlHeaderDates, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        this.pnlWeekNumber = this.createWeekNumbersPanel();
        this.pnlWeekNumber.setVisible(this.showWeekNumber);
        pnlMonthes.add((Component)this.pnlWeekNumber, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        pnlMonthes.add((Component)this.glassPanel, constraints);
        this.add((Component)pnlMonthes, "Center");
        this.add((Component)this.yearlyCalendarComponent, "Before");
        this.yearlyCalendarComponent.setVisible(this.showYearlyCalendar);
    }

    protected void buildYearlyCalendarComponent() {
        this.yearlyCalendarComponent = new YearlyCalendar(this.currentDate, false, this.getController(), this.getItemList());
        this.yearlyCalendarComponent.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(2, 2, 2, 2), new GradientBorder(10, 10, 10, 10)));
        Dimension preferredSize = new Dimension(this.yearlyCalendarComponent.getPrefferedWidth() + 24, (int)this.yearlyCalendarComponent.getPreferredSize().getHeight());
        this.yearlyCalendarComponent.setPreferredSize(preferredSize);
        super.buildYearlyCalendarComponent();
    }

    public void setMonthPickerVisibled(boolean b) {
        this.showYearlyCalendar = b;
        this.yearlyCalendarComponent.setVisible(b);
    }

    public void folderChanged() {
        if (this.yearlyCalendarComponent != null) {
            this.yearlyCalendarComponent.setItemList(this.calendarItemListData.getItemList());
        }
    }

    private OrientablePanel createEmptyPanel() {
        OrientablePanel panel = new OrientablePanel();
        panel.setBackground(Color.WHITE);
        panel.setOpaque(true);
        panel.setBorder(this.borderHeader);
        return panel;
    }

    private void adjustItems(boolean theShow, String theType) {
        this.popup.setShowItems(theShow, theType);
        for (int i = 0; i < CAL_SIZE; ++i) {
            this.bxDays[i].setShowItems(theShow, theType);
        }
    }

    protected void adjustTasks() {
        this.adjustItems(this.typesToggle.isShowTasks(), "Task");
    }

    protected void adjustNotes() {
        this.adjustItems(this.typesToggle.isShowNotes(), "Note");
    }

    protected void adjustAppointments() {
        this.adjustItems(this.typesToggle.isShowAppointments(), "AllDayEvent");
    }

    private OrientablePanel createHeader() {
        int firstDayOfWeek = this.firstDayOfWeek;
        OrientablePanel result = new OrientablePanel(new GridLayout(1, 7, 1, 1));
        for (int i = 0; i < 7; ++i) {
            if (firstDayOfWeek > 6) {
                firstDayOfWeek = 0;
            }
            OrientableLabel day = new OrientableLabel(GWCalendarUtils.getWeekDayName(firstDayOfWeek, GWCalendarUtils.DayNameLength.FULL));
            day.setHorizontalAlignment(0);
            day.setOpaque(true);
            day.setBorder(this.borderHeader);
            day.setBackground(Color.white);
            if (this.highlightWeekends && (firstDayOfWeek == 0 || firstDayOfWeek == 6)) {
                day.setForeground(ColorConstants.clrDaysHoly);
            }
            ++firstDayOfWeek;
            result.add(day);
        }
        return result;
    }

    private JPanel buildGrid() {
        OrientablePanel panel = new OrientablePanel(new GridLayout(6, 7, 1, 1));
        for (int i = 0; i < CAL_SIZE; ++i) {
            this.bxDays[i] = new BorderedCalendarItemPanel(false, this.getController());
            this.bxDays[i].setMinimumSize(new Dimension(this.minimumCellWidth, this.minimumCellHeight));
            panel.add(this.bxDays[i]);
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 23;
        ++constraints.gridx;
        constraints.weightx = 1.0;
        return panel;
    }

    private OrientablePanel createWeekNumbersPanel() {
        OrientablePanel panel = new OrientablePanel(new GridLayout(6, 1, 1, 1));
        this.weekNumberLabelList = new ArrayList();
        for (int i = 0; i < 6; ++i) {
            OrientableLabel label = new OrientableLabel("T");
            label.setVerticalAlignment(1);
            label.setBorder(this.borderHeader);
            label.setOpaque(true);
            label.setBackground(Color.WHITE);
            this.weekNumberLabelList.add(label);
            panel.add(label);
        }
        return panel;
    }

    protected CalendarViewType getViewType() {
        return CalendarViewType.MONTHLY;
    }

    public void closePopup() {
        this.popup.close();
    }

    public void change(CalendarStateEvent theEvent) {
        this.closePopup();
        super.change(theEvent);
    }

    private void refreshItems(IItemList theItemList, TimeInterval theChangedInterval) {
        if (theChangedInterval == null) {
            if (this.popup.getContentPanel() != null) {
                this.refreshPopup(theItemList);
            }
            for (int i = 0; i < CAL_SIZE; ++i) {
                MonthlyView.refreshCalendarItemPanel(this.bxDays[i], theItemList, this.days[i]);
            }
        } else {
            if (this.popup.getContentPanel() != null && theChangedInterval.contains(this.popup.getCurrentDate())) {
                this.refreshPopup(theItemList);
            }
            for (int i = 0; i < CAL_SIZE; ++i) {
                if (!theChangedInterval.contains(this.days[i])) continue;
                MonthlyView.refreshCalendarItemPanel(this.bxDays[i], theItemList, this.days[i]);
            }
        }
    }

    private static void refreshCalendarItemPanel(BorderedCalendarItemPanel bxDay, IItemList itemList, Calendar date) {
        Date time = date.getTime();
        ArrayList<AbstractCalendarItem> appointments = new ArrayList<AbstractCalendarItem>();
        ArrayList<AbstractItem> tasks = new ArrayList<AbstractItem>();
        ArrayList<AbstractCalendarItem> notes = new ArrayList<AbstractCalendarItem>();
        GWCalendarUtils.fillCalendarItems(itemList, time, appointments, tasks, notes);
        bxDay.setItems(date, appointments, itemList, "AllDayEvent");
        bxDay.setItems(date, tasks, itemList, "Task");
        bxDay.setItems(date, notes, itemList, "Note");
    }

    private void refreshPopup(IItemList itemList) {
        Date popupTime = this.popup.getCurrentDate().getTime();
        ArrayList<AbstractCalendarItem> appointments = new ArrayList<AbstractCalendarItem>();
        ArrayList<AbstractItem> tasks = new ArrayList<AbstractItem>();
        ArrayList<AbstractCalendarItem> notes = new ArrayList<AbstractCalendarItem>();
        GWCalendarUtils.fillCalendarItems(itemList, popupTime, appointments, tasks, notes);
        this.popup.setItems(this.popup.getCurrentDate(), appointments, itemList, "AllDayEvent");
        this.popup.setItems(this.popup.getCurrentDate(), tasks, itemList, "Task");
        this.popup.setItems(this.popup.getCurrentDate(), notes, itemList, "Note");
    }

    protected void prepareRefresh(boolean folderWasChanged) {
        if (folderWasChanged && this.yearlyCalendarComponent != null) {
            this.yearlyCalendarComponent.setDirty();
            this.yearlyCalendarComponent.validateBusyDays(this.getItemList());
        }
        this.refreshedInterval = GWCalendarUtils.getMonthTimeInterval(GWCalendarUtils.convertDayToCalendar(this.currentDate).getTime());
        this.updateDays();
        this.adjustBorders();
        long startDate = GWCalendarUtils.getDayTimeInterval(this.days[0].getTime()).getStartDate();
        long endDate = GWCalendarUtils.getDayTimeInterval(this.days[41].getTime()).getEndDate();
        this.viewInterval = new TimeInterval(startDate, endDate);
    }

    public void refreshUIOptions() {
        super.refreshUIOptions();
        this.pnlEmpty.setVisible(this.showWeekNumber);
        this.pnlWeekNumber.setVisible(this.showWeekNumber);
        this.yearlyCalendarComponent.refreshUIOptions();
        if (this.pnlHeaderDates != null) {
            int firstDayOfWeek = this.firstDayOfWeek;
            for (int i = 0; i < 7; ++i) {
                if (firstDayOfWeek > 6) {
                    firstDayOfWeek = 0;
                }
                JLabel day = (JLabel)this.pnlHeaderDates.getComponent(i);
                day.setText(GWCalendarUtils.getWeekDayName(firstDayOfWeek, GWCalendarUtils.DayNameLength.FULL));
                day.setForeground(ColorConstants.clrDaysWork);
                if (this.highlightWeekends && (firstDayOfWeek == 0 || firstDayOfWeek == 6)) {
                    day.setForeground(ColorConstants.clrDaysHoly);
                }
                ++firstDayOfWeek;
            }
        }
        this.yearlyCalendarComponent.setPreferredSize(new Dimension(this.yearlyCalendarComponent.getPrefferedWidth() + 24, (int)this.yearlyCalendarComponent.getPreferredSize().getHeight()));
        this.refresh(false);
    }

    protected void refresh(boolean folderWasChanged, TimeInterval theChangedInterval) {
        if (this.canRefresh()) {
            MessageUtils.showBusyCursor(true);
            this.prepareRefresh(folderWasChanged);
            this.refreshItems(this.getItemList(), theChangedInterval);
            this.adjustAppointments();
            this.adjustTasks();
            this.adjustNotes();
            MessageUtils.showBusyCursor(false);
        }
    }

    private void updateTitle() {
        this.lblTitle.setText(' ' + GWCalendarUtils.monthNames[GWCalendarUtils.convertDayToCalendar(this.currentDate).get(2)] + ' ' + this.currentDate.getYear());
    }

    private void refreshWeekNumbers() {
        Calendar gcDay = GWCalendarUtils.convertDayToCalendar(this.currentDate);
        gcDay.setFirstDayOfWeek((Integer)GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings().getMonthCalendarFirstDay().getValue() + 1);
        gcDay.set(5, 1);
        int minimalDaysInFirstWeek = this.firstDayOfWeek != 4 ? (this.firstDayOfWeek + 3) % 7 : this.firstDayOfWeek + 3;
        gcDay.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
        if (this.weekNumberLabelList == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.weekNumberLabelList.get(i).setText(String.valueOf(gcDay.get(3)));
            gcDay.add(5, 7);
        }
    }

    private void updateDays() {
        this.updateTitle();
        this.refreshWeekNumbers();
        Calendar gcDay = GWCalendarUtils.initCalendar(GWCalendarUtils.convertDayToCalendar(this.currentDate));
        for (int i = 0; i < CAL_SIZE; ++i) {
            gcDay.add(5, 1);
            this.days[i] = (Calendar)gcDay.clone();
            this.bxDays[i].setTitle(String.valueOf(gcDay.get(5)));
            if (this.refreshedInterval.contains(gcDay.getTime())) {
                if ((gcDay.get(7) == 1 || gcDay.get(7) == 7) && this.highlightWeekends) {
                    this.bxDays[i].setForeground(ColorConstants.clrDaysHoly);
                } else {
                    this.bxDays[i].setForeground(ColorConstants.clrDaysWork);
                }
                this.bxDays[i].setBackground(ColorConstants.clrCurrDayBack);
                continue;
            }
            this.bxDays[i].setForeground(Color.gray);
            this.bxDays[i].setBackground(ColorConstants.clrDayBack);
        }
    }

    private void adjustBorders() {
        String sDay;
        String sToday = GWCalendarUtils.calendarToString(GWCalendarUtils.getToday());
        String sCurrDay = GWCalendarUtils.calendarToString(GWCalendarUtils.convertDayToCalendar(this.currentDate));
        StaticCalendarItemPanel popupPanel = this.popup.getContentPanel();
        if (popupPanel != null) {
            sDay = GWCalendarUtils.calendarToString(popupPanel.getCurrentDate());
            this.updateBorder(sDay, sCurrDay, sToday, popupPanel);
        }
        for (int i = 0; i < CAL_SIZE; ++i) {
            sDay = GWCalendarUtils.calendarToString(this.days[i]);
            BorderedCalendarItemPanel panel = this.bxDays[i];
            this.updateBorder(sDay, sCurrDay, sToday, panel);
        }
    }

    private void updateBorder(String theDay, String theCurrDay, String theToday, StaticCalendarItemPanel thePanel) {
        if (theDay.equals(theCurrDay) && theDay.equals(theToday)) {
            thePanel.setBorder(this.borderTodayCurrent);
        } else if (theDay.equals(theCurrDay)) {
            thePanel.setBorder(this.borderCurrent);
        } else if (theDay.equals(theToday)) {
            thePanel.setBorder(this.borderToday);
        } else {
            thePanel.setBorder(this.borderDefault);
        }
    }

    protected void adjustCurrentDay() {
        if (this.refreshedInterval.contains(GWCalendarUtils.convertDayToCalendar(this.currentDate).getTime())) {
            this.adjustBorders();
            this.needRefresh(false);
        } else {
            this.popup.close();
            this.needRefresh(true);
            this.refresh(false);
        }
        if (this.showYearlyCalendar) {
            this.calendarAdjusting = true;
            this.yearlyCalendarComponent.setCurrentDate(this.currentDate);
            this.calendarAdjusting = false;
        }
    }

    public void requestFocus() {
        this.glassPanel.requestFocus();
    }

    public String getName() {
        return "CalendarView-Monthly";
    }
}

