/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEventType;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DayCell;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class CalendarComponent
extends JComponent
implements ListSelectionListener {
    private static Logger logger = Logger.getLogger(CalendarComponent.class);
    public static final Color CALENDAR_BACKGROUND = Color.WHITE;
    public static final Color LABELS_BACKGROUND = Color.WHITE;
    public static final Color SELECTED_DAY_COLOR = Color.BLUE;
    public static final Color DAYLABELS_LINE_COLOR = Color.GRAY;
    public static final Color TODAY_DAY_FILL_COLOR = new Color(225, 225, 225);
    public static final Color TODAY_DAY_BORDER_COLOR = Color.LIGHT_GRAY;
    private static final int DEFAULT_CELL_WIDTH = PLAFChanger.getFontSize() * 2 - 2;
    private static final int DEFAULT_CELL_HEIGHT = PLAFChanger.getFontSize() + 2;
    private static final int DEFAULT_LABELS_HEIGHT = PLAFChanger.getFontSize() + 3;
    private static final int DEFAULT_SEPARATOR_WIDTH = 3;
    private int cellWidth;
    private int cellHeight;
    private Insets cellInsets = new Insets(1, 1, 1, 1);
    private Dimension size;
    private int labelsHeight;
    private DayCell dragOverCell;
    private CalendarModel dataModel;
    private ListSelectionModel selectionModel;
    private int fullHeight;
    private int fullWidth;
    private int RTLOffset;
    private boolean isLTR;
    private boolean drawLine;
    private boolean showWeekNumber;

    public CalendarComponent(CalendarModel dm) {
        this(dm, DEFAULT_CELL_WIDTH, DEFAULT_CELL_HEIGHT, DEFAULT_LABELS_HEIGHT, true);
    }

    public CalendarComponent(CalendarModel dm, int theCellWidht, int theCellHeight, int theLabelsHeight, boolean drawLine) {
        this.setDoubleBuffered(true);
        this.isLTR = UIUtils.getComponentOrientation().isLeftToRight();
        this.cellWidth = theCellWidht;
        this.cellHeight = theCellHeight;
        this.labelsHeight = theLabelsHeight;
        this.drawLine = drawLine;
        this.showWeekNumber = (Boolean)GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings().getMonthCalendarShowWeekNumber().getValue();
        this.initSize();
        this.initSelectionModel();
        if (dm == null) {
            dm = CalendarComponent.createDefaultDataModel();
        }
        this.setModel(dm);
    }

    private void setModel(CalendarModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("Cannot set a null CalendarDataModel");
        }
        CalendarModel oldModel = this.dataModel;
        if (oldModel != newModel) {
            this.dataModel = newModel;
        }
        this.update();
    }

    public void update() {
        this.showWeekNumber = (Boolean)GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings().getMonthCalendarShowWeekNumber().getValue();
        this.initSize();
        this.initCells();
        this.clearSelection();
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    private void initSelectionModel() {
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
        this.selectionModel.addListSelectionListener(this);
    }

    public void setSelectionMode(boolean multipleSelectionMode) {
        this.selectionModel.setSelectionMode(multipleSelectionMode ? 2 : 0);
    }

    private static CalendarModel createDefaultDataModel() {
        return new CalendarModel(GWCalendarUtils.getToday());
    }

    private void initSize() {
        int w = (this.cellInsets.right + this.cellWidth + this.cellInsets.left) * 7 + 1;
        int h = this.labelsHeight + (this.cellInsets.top + this.cellHeight + this.cellInsets.bottom) * 6 + 1;
        this.size = new Dimension(w, h);
        this.fullHeight = this.cellInsets.top + this.cellHeight + this.cellInsets.bottom;
        this.fullWidth = this.cellInsets.right + this.cellWidth + this.cellInsets.left;
        this.RTLOffset = this.size.width - this.cellInsets.right - this.cellWidth;
        if (this.showWeekNumber) {
            w = w + this.fullWidth + 3;
            this.size = new Dimension(w, h);
        }
    }

    private void initCells() {
        int i;
        int dx = 0;
        int dy = this.cellInsets.top + this.labelsHeight;
        int nSize = this.dataModel.size();
        for (i = 0; i < nSize; ++i) {
            dx = this.incDx(i, dx, this.fullWidth);
            if (i / 7 == 0) {
                this.dataModel.getLabelCell(i).setBounds(dx, 0, this.cellWidth, this.cellHeight);
            }
            if (i % 6 != 0 && i % 7 == 0) {
                dy += this.fullHeight;
            }
            this.dataModel.getDayCell(i).setBounds(dx, dy, this.cellWidth, this.cellHeight);
        }
        if (this.showWeekNumber) {
            for (i = 0; i < nSize; ++i) {
                this.moveX(this.dataModel.getDayCell(i));
                if (i / 7 != 0) continue;
                this.moveX(this.dataModel.getLabelCell(i));
            }
        }
        int y = this.cellInsets.top + this.labelsHeight;
        for (int i2 = 0; i2 < this.dataModel.getNumberOfWeekToDisplay(); ++i2) {
            this.dataModel.getWeekNumberCell(i2).setBounds(0, y, this.cellWidth, this.cellHeight);
            y += this.fullHeight;
        }
    }

    private void moveX(DayCell dayCell) {
        Rectangle rectangle = dayCell.getBounds();
        double x = rectangle.getX() + (double)this.fullWidth + 3.0;
        double y = rectangle.getY();
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        rectangle.setRect(x, y, width, height);
    }

    private int incDx(int index, int theDx, int width) {
        theDx = index % 7 == 0 ? (this.isLTR ? this.cellInsets.right : this.RTLOffset) : (theDx += this.isLTR ? width : -width);
        return theDx;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void paint(Graphics g) {
        g = UIUtils.enableAntialiasing(g);
        this.drawLabels(g);
        this.drawGrid(g);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, this.size.width, this.size.height);
    }

    private void drawLabels(Graphics g) {
        g.setColor(LABELS_BACKGROUND);
        g.fillRect(0, 0, this.size.width, this.labelsHeight);
        if (this.drawLine) {
            g.setColor(DAYLABELS_LINE_COLOR);
            g.drawLine(1, this.labelsHeight - 1, this.size.width - 2, this.labelsHeight - 1);
        }
        for (int j = 0; j < 7; ++j) {
            DayCell cell = this.dataModel.getLabelCell(j);
            this.drawString(g, cell.getText(), cell.getBounds(), cell.getForeground(), CalendarComponent.getTextFont(g, this.drawLine));
        }
    }

    public void setHighLighted(Point point) {
        DayCell dayCell = this.getModel().getDayCell(point);
        if (dayCell != null && dayCell.getTime() != null) {
            this.dragOverCell = dayCell;
            this.repaint();
        } else {
            this.clearHighLight();
        }
    }

    public void clearHighLight() {
        this.dragOverCell = null;
        this.repaint();
    }

    private static Font getTextFont(Graphics g, boolean isBold) {
        Font oldFont = g.getFont();
        return isBold ? new Font(oldFont.getName(), 1, oldFont.getSize()) : new Font(oldFont.getName(), 0, oldFont.getSize());
    }

    private void drawGrid(Graphics g) {
        int i;
        g.setColor(CALENDAR_BACKGROUND);
        g.fillRect(0, this.labelsHeight, this.size.width, this.size.height);
        int nSize = this.dataModel.size();
        for (i = 0; i < nSize; ++i) {
            this.drawCell(g, i);
        }
        if (this.showWeekNumber) {
            for (i = 0; i < this.dataModel.getNumberOfWeekToDisplay(); ++i) {
                DayCell cell = this.dataModel.getWeekNumberCell(i);
                if (cell.getText() == null) continue;
                g.setColor(Color.DARK_GRAY);
                this.drawString(g, cell.getText(), cell.getBounds(), cell.getForeground(), CalendarComponent.getTextFont(g, cell.isBold()));
                this.drawSeparator(g, cell.getBounds());
            }
        }
    }

    private void drawSeparator(Graphics g, Rectangle bounds) {
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(bounds.x + this.fullWidth, bounds.y, bounds.x + this.fullWidth, bounds.y + this.fullHeight);
        g.drawLine(bounds.x + this.fullWidth + 1, bounds.y, bounds.x + this.fullWidth + 1, bounds.y + this.fullHeight);
    }

    private void drawCell(Graphics g, int index) {
        DayCell cell = this.getModel().getDayCell(index);
        Rectangle bounds = cell.getBounds();
        Calendar dateCell = cell.getTime();
        boolean isHighLighted = cell.equals(this.dragOverCell);
        if (dateCell != null) {
            if (isHighLighted) {
                g.setColor(cell.getForeground());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                this.drawString(g, cell.getText(), cell.getBounds(), LABELS_BACKGROUND, CalendarComponent.getTextFont(g, cell.isBold()));
            } else {
                if (GWCalendarUtils.isToday(dateCell)) {
                    g.setColor(TODAY_DAY_FILL_COLOR);
                    g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    g.setColor(TODAY_DAY_BORDER_COLOR);
                    g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    g.setColor(Color.BLACK);
                    g.drawLine(bounds.x, bounds.y, bounds.x + 3, bounds.y);
                    g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + 3);
                    g.drawLine(bounds.x + bounds.width, bounds.y, bounds.x - 3 + bounds.width, bounds.y);
                    g.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + 3);
                    g.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + 3, bounds.y + bounds.height);
                    g.drawLine(bounds.x, bounds.y + bounds.height, bounds.x, bounds.y + bounds.height - 3);
                    g.drawLine(bounds.x + bounds.width, bounds.y + bounds.height, bounds.x + bounds.width - 3, bounds.y + bounds.height);
                    g.drawLine(bounds.x + bounds.width, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height - 3);
                }
                if (this.isCellSelected(cell)) {
                    g.setColor(SELECTED_DAY_COLOR);
                    g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                }
                this.drawString(g, cell.getText(), cell.getBounds(), cell.getForeground(), CalendarComponent.getTextFont(g, cell.isBold()));
            }
        }
    }

    private boolean isCellSelected(DayCell theCell) {
        return this.selectionModel.isSelectedIndex(theCell.getIndex());
    }

    private void drawString(Graphics g, String text, Rectangle bounds, Color textColor, Font textFont) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle textRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        g.setFont(textFont);
        SwingUtilities.layoutCompoundLabel(fm, text, null, 0, 0, 0, 0, bounds, iconRect, textRect, 0);
        int textX = textRect.x;
        int textY = textRect.y + fm.getAscent();
        g.setColor(textColor);
        g.drawString(text, textX, textY);
    }

    public void handleKey(int code, boolean isShiftDown, boolean canChange) {
        switch (code) {
            case 38: {
                this.updateSelectedCell(-7, isShiftDown, canChange);
                break;
            }
            case 40: {
                this.updateSelectedCell(7, isShiftDown, canChange);
                break;
            }
            case 37: {
                int delta = this.isLTR ? -1 : 1;
                this.updateSelectedCell(delta, isShiftDown, canChange);
                break;
            }
            case 39: {
                int delta = this.isLTR ? 1 : -1;
                this.updateSelectedCell(delta, isShiftDown, canChange);
                break;
            }
            case 33: {
                this.navigate(-1, canChange);
                break;
            }
            case 34: {
                this.navigate(1, canChange);
                break;
            }
            case 32: {
                if (!canChange) break;
                this.dataModel.setDate(this.dataModel.getDate(), CalendarEventType.SELECT);
            }
        }
    }

    private void updateSelectedCell(int delta, boolean isShiftDown, boolean canChange) {
        int i = this.selectionModel.getLeadSelectionIndex();
        int first = this.dataModel.getFirstCell().getIndex();
        int last = this.dataModel.getLastCell().getIndex();
        Calendar date = this.dataModel.getDate();
        int index = i + delta;
        if (index >= first && index <= last) {
            if (!isShiftDown) {
                this.clearSelection();
            }
            date.add(5, delta);
            this.dataModel.setDate(date);
        } else {
            if (index < first) {
                int shift = delta - first + i;
                date.set(5, date.getActualMinimum(5));
                date.add(5, shift);
            } else {
                int shift = last - delta - i;
                date.set(5, date.getActualMaximum(5));
                date.add(5, -shift);
            }
            if (canChange) {
                this.dataModel.setDate(date);
            } else {
                this.dataModel.fireModelChenged(new CalendarEvent(GWCalendarUtils.getChangeMask(this.dataModel.getDate(), date), date));
            }
        }
    }

    public void handleClick(Point point, boolean isShiftDown) {
        DayCell dayCell = this.dataModel.getDayCell(point);
        if (dayCell == null) {
            return;
        }
        Calendar time = dayCell.getTime();
        if (time == null) {
            return;
        }
        if (!isShiftDown) {
            this.clearSelection();
        }
        Calendar date = this.dataModel.getDate();
        date.set(5, time.get(5));
        this.dataModel.setDate(date, CalendarEventType.SELECT);
    }

    public void valueChanged(ListSelectionEvent e) {
        boolean isAdjusting;
        int firstIndex = e.getFirstIndex();
        int lastIndex = e.getLastIndex();
        boolean bl = isAdjusting = this.selectionModel.isSelectionEmpty() && firstIndex == lastIndex;
        if (isAdjusting) {
            return;
        }
        this.repaint();
    }

    public void navigate(int shift, boolean canChange) {
        Calendar date = this.dataModel.getDate();
        switch (shift) {
            case -1: {
                date.add(2, -1);
                break;
            }
            case 1: {
                date.add(2, 1);
                break;
            }
            case -2: {
                date.add(1, -1);
                break;
            }
            case 2: {
                date.add(1, 1);
            }
        }
        if (canChange) {
            this.dataModel.setDate(date, CalendarEventType.NAVIGATE);
        } else {
            this.dataModel.fireModelChenged(new CalendarEvent(GWCalendarUtils.getChangeMask(this.dataModel.getDate(), date), date));
        }
    }

    public void updateSelection() {
        DayCell currentCell = this.dataModel.getCurrentCell();
        if (currentCell != null) {
            int index = currentCell.getIndex();
            this.selectionModel.addSelectionInterval(index, index);
        }
    }

    public void gotoToday() {
        this.clearSelection();
        Calendar today = GWCalendarUtils.getToday();
        this.dataModel.setDate(today);
    }

    public CalendarModel getModel() {
        return this.dataModel;
    }

    public Date getDragOverDate() {
        return this.dragOverCell == null ? null : this.dragOverCell.getTime().getTime();
    }
}

