/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview;

import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.Glass;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.GlassPanelLayout;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class AppointmentsGlassPanel
extends JLayeredPane {
    private JPanel panel;
    private Glass glass;
    private GlassPanelMouseHandler mouseHandler;

    public AppointmentsGlassPanel(JPanel thePanel) {
        this.panel = thePanel;
        this.setLayout(new GlassPanelLayout());
        this.add((Component)this.panel, "Center");
        this.setLayer(this.panel, JLayeredPane.DEFAULT_LAYER, 0);
        this.glass = new Glass();
        this.add((Component)this.glass, "Glass");
        this.setLayer(this.glass, JLayeredPane.MODAL_LAYER, 0);
        this.mouseHandler = new GlassPanelMouseHandler(this.panel);
        this.glass.addMouseListener(this.mouseHandler);
        this.glass.addMouseMotionListener(this.mouseHandler);
    }

    private ActiveItemLabel getPanel(MouseEvent e) {
        Point containerPoint = SwingUtilities.convertPoint(this.glass, e.getPoint(), this.panel);
        if (this.panel instanceof AppointmentPanel) {
            Component label = this.panel.getComponentAt(containerPoint);
            if (label instanceof ActiveItemLabel) {
                return (ActiveItemLabel)label;
            }
        } else {
            Point point;
            Component label;
            Component component = this.panel.getComponentAt(containerPoint);
            if (component instanceof AppointmentPanel && (label = component.getComponentAt(point = SwingUtilities.convertPoint(this.panel, containerPoint, component))) instanceof ActiveItemLabel) {
                return (ActiveItemLabel)label;
            }
        }
        return null;
    }

    private void redispatch(MouseEvent e) {
        Point containerPoint = SwingUtilities.convertPoint(this.glass, e.getPoint(), this.panel);
        if (this.panel instanceof AppointmentPanel) {
            this.panel.dispatchEvent(new MouseEvent(this.panel, e.getID(), e.getWhen(), e.getModifiers(), containerPoint.x, containerPoint.y, e.getClickCount(), e.isPopupTrigger()));
        } else {
            Component component = this.panel.getComponentAt(containerPoint);
            if (component instanceof AppointmentPanel) {
                component.dispatchEvent(new MouseEvent(this.panel, e.getID(), e.getWhen(), e.getModifiers(), containerPoint.x, containerPoint.y, e.getClickCount(), e.isPopupTrigger()));
            }
        }
    }

    private class GlassPanelMouseHandler
    implements MouseListener,
    MouseMotionListener {
        private ActiveItemLabel label;
        private ActiveItemLabel oldlabel;
        private LabelDragHandler listener;

        public GlassPanelMouseHandler(JPanel thePanel) {
            this.listener = new LabelDragHandler(thePanel);
        }

        public void mousePressed(MouseEvent me) {
            AppointmentsGlassPanel.this.redispatch(me);
        }

        public void mouseReleased(MouseEvent me) {
            AppointmentsGlassPanel.this.redispatch(me);
        }

        private void disposeDragLabel() {
            if (this.label != null) {
                AppointmentsGlassPanel.this.glass.remove(this.label);
                AppointmentsGlassPanel.this.glass.repaint();
                this.listener.setOriginalLabel(null);
                this.label.removeMouseListener(this.listener);
                this.label.removeMouseMotionListener(this.listener);
                this.label = null;
                this.oldlabel = null;
            }
        }

        private void createDragLabel() {
            if (this.oldlabel != null) {
                this.label = new ActiveItemLabel(true, new ItemAndItemListInfo(this.oldlabel.getItemList(), this.oldlabel.getItem()), AppointmentsGlassPanel.this.getBackground(), this.oldlabel.getController(), false);
                this.label.setBorder(new LineBorder(Color.BLACK, 1));
                this.label.setSize(this.oldlabel.getWidth(), this.oldlabel.getHeight());
                this.listener.setOriginalLabel(this.oldlabel);
                this.label.addMouseListener(this.listener);
                this.label.addMouseMotionListener(this.listener);
                Point location = this.oldlabel.getLocation();
                SwingUtilities.convertPointToScreen(location, this.oldlabel.getParent());
                SwingUtilities.convertPointFromScreen(location, AppointmentsGlassPanel.this.glass);
                AppointmentsGlassPanel.this.glass.add((Component)this.label, location);
                AppointmentsGlassPanel.this.glass.revalidate();
            }
        }

        public void mouseDragged(MouseEvent e) {
            AppointmentsGlassPanel.this.redispatch(e);
        }

        public void mouseMoved(MouseEvent e) {
            ActiveItemLabel panel = AppointmentsGlassPanel.this.getPanel(e);
            if (panel != this.oldlabel) {
                this.disposeDragLabel();
                this.oldlabel = panel;
                this.createDragLabel();
            }
            AppointmentsGlassPanel.this.redispatch(e);
        }

        public void mouseClicked(MouseEvent e) {
            AppointmentsGlassPanel.this.redispatch(e);
        }

        public void mouseEntered(MouseEvent e) {
            AppointmentsGlassPanel.this.redispatch(e);
        }

        public void mouseExited(MouseEvent e) {
            AppointmentsGlassPanel.this.redispatch(e);
        }
    }

    private class LabelDragHandler
    implements MouseListener,
    MouseMotionListener {
        private Point pointPressed = null;
        private JPanel panel;
        private ActiveItemLabel original;
        private boolean wasPopupTrigger;
        private boolean dragStarted;

        public LabelDragHandler(JPanel thePanel) {
            this.panel = thePanel;
        }

        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.wasPopupTrigger = true;
                return;
            }
            this.ensurePopupClosed(me.getSource());
            this.wasPopupTrigger = false;
            this.pointPressed = me.getPoint();
            this.dragStarted = true;
        }

        private void ensurePopupClosed(Object theSource) {
            GWPopupMenu fakePopup = new GWPopupMenu();
            fakePopup.setSize(0, 0);
            fakePopup.show((Component)theSource, 0, 0);
            fakePopup.setVisible(false);
        }

        public void mouseReleased(MouseEvent me) {
            if (this.wasPopupTrigger) {
                this.wasPopupTrigger = false;
                return;
            }
            if (me.isPopupTrigger()) {
                this.wasPopupTrigger = true;
                return;
            }
            this.ensurePopupClosed(me.getSource());
            this.pointPressed = null;
            this.original.setVisible(true);
            this.dragStarted = true;
        }

        public void setOriginalLabel(ActiveItemLabel theLabel) {
            this.original = theLabel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent me) {
            Point point = this.pointPressed;
            synchronized (point) {
                if (this.pointPressed == null) {
                    return;
                }
                if (this.dragStarted) {
                    this.original.setVisible(false);
                    this.dragStarted = false;
                }
                this.original.setVisible(false);
                ActiveItemLabel label = (ActiveItemLabel)me.getSource();
                Point location = label.getLocation();
                Point point2 = me.getPoint();
                point2.translate(location.x, location.y);
                point2.translate(-this.pointPressed.x, -this.pointPressed.y);
                if (point2.x < 0) {
                    point2.x = 0;
                }
                if (point2.x + label.getWidth() > this.panel.getWidth()) {
                    point2.x = this.panel.getWidth() - label.getWidth();
                }
                if (point2.y < 0) {
                    point2.y = 0;
                }
                if (point2.y + label.getHeight() > this.panel.getHeight()) {
                    point2.y = this.panel.getHeight() - label.getHeight();
                }
                Rectangle bounds = label.getBounds();
                bounds.setLocation(point2);
                AppointmentsGlassPanel.this.scrollRectToVisible(bounds);
                label.setLocation(point2);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

