/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.level.LevelManager;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewPostedReminderNote;
import com.novell.gw.jclient.application.actions.ActionNewPostedTask;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveItemLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarPopup;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigateCreateItem;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigationCreateItemKeyboardListener;
import com.novell.gw.jclient.application.controls.gwcalendar.TypingWindow;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ActiveCalendarItemPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.DateWatchPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.NotesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.TaskPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyView;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarBoxesPanel
extends DateWatchPanel
implements NavigateCreateItem {
    private static Logger logger = Logger.getLogger(CalendarBoxesPanel.class);
    private Border border = BorderFactory.createLineBorder(ColorConstants.HEADER_BORDER_COLOR);
    private boolean drawBorders = false;
    private ArrayList days = new ArrayList();
    private String type;
    private BoxMouseListener boxMouseListener;
    private LabelMouseClick labelMouseListener;
    private AbstractItem itemSel;

    public CalendarBoxesPanel(MVCController theController, String theType, int theSize, boolean drawBorders) {
        super(theController);
        this.setFocusable(true);
        this.addKeyListener(new NavigationCreateItemKeyboardListener(this));
        this.type = theType;
        this.boxMouseListener = new BoxMouseListener();
        this.labelMouseListener = new LabelMouseClick();
        this.drawBorders = drawBorders;
        this.setLayout(new GridLayout(1, 0, 0, 0));
        this.setBackground(Color.white);
        for (int i = 0; i < theSize; ++i) {
            ActiveCalendarItemPanel box = this.createBox();
            this.days.add(box);
            this.add(box);
        }
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (CalendarBoxesPanel.this.getController().getParentController() != null) {
                    MVCView mvcView = CalendarBoxesPanel.this.getController().getParentController().getMVCView();
                    if (mvcView instanceof DailyView) {
                        ((DailyView)mvcView).setFocusedPanel(CalendarBoxesPanel.this);
                    } else if (mvcView instanceof WeeklyView) {
                        ((WeeklyView)mvcView).setFocusedPanel(CalendarBoxesPanel.this);
                    }
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    private void loadItemsForDate(Calendar gcStartDay, IItemList theItemList) {
        Calendar start = (Calendar)gcStartDay.clone();
        for (int i = 0; i < this.days.size(); ++i) {
            ActiveCalendarItemPanel box = (ActiveCalendarItemPanel)this.days.get(i);
            box.setItemSel(this.itemSel);
            box.setItems(start, theItemList, this.type);
            box.setShowItems(true, this.type);
            start.add(5, 1);
        }
    }

    public void setItemSel(AbstractItem itemSel) {
        this.itemSel = itemSel;
    }

    public void loadItemsForDate(Calendar gcStartDay, IItemList theItemList, TimeInterval theChangedInterval) {
        if (theChangedInterval == null) {
            this.loadItemsForDate(gcStartDay, theItemList);
        } else {
            Calendar start = (Calendar)gcStartDay.clone();
            start.set(11, 12);
            int nSize = this.days.size();
            for (int i = 0; i < nSize; ++i) {
                ActiveCalendarItemPanel box = (ActiveCalendarItemPanel)this.days.get(i);
                if (theChangedInterval.contains(start)) {
                    box.setItems(start, theItemList, this.type);
                    box.setShowItems(true, this.type);
                }
                start.add(5, 1);
            }
        }
    }

    private ActiveCalendarItemPanel getPanelForDate(Date theDate) {
        for (ActiveCalendarItemPanel activeCalendarItemPanel : this.days) {
            if (!GWCalendarUtils.isSameDate(activeCalendarItemPanel.getCurrentDate().getTime(), theDate)) continue;
            return activeCalendarItemPanel;
        }
        return null;
    }

    public void addBoxAndLoadData(Calendar theDay, IItemList itemList, List<? extends AbstractItem> calendarItems) {
        ActiveCalendarItemPanel box = this.createBox();
        this.days.add(box);
        this.add(box);
        box.setItems(theDay, calendarItems, itemList, this.type);
        box.setShowItems(true, this.type);
    }

    private ActiveCalendarItemPanel createBox() {
        ActiveCalendarItemPanel box = null;
        if ("Task".equals(this.type)) {
            box = new TaskPanel(this.getController(), this.labelMouseListener);
        } else if ("Note".equals(this.type)) {
            box = new NotesPanel(this.getController(), this.labelMouseListener);
        }
        if (box != null) {
            box.setBorder(this.drawBorders ? this.border : BorderFactory.createEmptyBorder());
            box.setBackground(Color.white);
            box.addMouseListener(this.boxMouseListener);
        }
        return box;
    }

    public void removeBox() {
        int lastIndex = this.days.size() - 1;
        if (lastIndex == 0) {
            return;
        }
        this.days.remove(lastIndex);
        ActiveCalendarItemPanel cip = (ActiveCalendarItemPanel)this.getComponent(lastIndex);
        cip.removeMouseListener(this.boxMouseListener);
        this.remove(cip);
        LevelManager.getInstance();
        LevelManager.release(cip.getController().getLevel());
    }

    private void navigate(int field, int shift) {
        Calendar newDate = (Calendar)this.getCurrentDate().clone();
        newDate.add(field, shift);
        this.adjustCurrentTime(newDate);
        this.selectFirstLabel(newDate.getTime());
    }

    @Override
    public void navigateUP() {
        ActiveCalendarItemPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        ArrayList labels = panel.getLabels(this.type);
        int selected = CalendarBoxesPanel.getSelectedItemIndex(labels);
        if (selected > 0) {
            ActiveItemLabel label = (ActiveItemLabel)labels.get(selected - 1);
            label.select();
        }
    }

    @Override
    public void navigateDOWN() {
        ActiveCalendarItemPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        ArrayList labels = panel.getLabels(this.type);
        int selected = CalendarBoxesPanel.getSelectedItemIndex(labels);
        if (!labels.isEmpty() && selected < labels.size() - 1) {
            ActiveItemLabel label = (ActiveItemLabel)labels.get(selected + 1);
            label.select();
        }
    }

    @Override
    public void navigateLEFT() {
        this.navigate(5, -1);
    }

    @Override
    public void navigateRIGHT() {
        this.navigate(5, 1);
    }

    @Override
    public void createItem() {
        AppAction action;
        ActionList aList = this.getController().getActionList();
        if (this.type.equals("Task")) {
            action = aList.getAction(ActionKey.NEW_POSTED_TASK);
            ((ActionNewPostedTask)action).setSelectedDate(this.getCurrentDate().getTime());
            ((ActionNewPostedTask)action).setCalendarView(true);
            action.actionPerformed(null);
        }
        if (this.type.equals("Note")) {
            action = aList.getAction(ActionKey.NEW_POSTED_REMINDERNOTE);
            ((ActionNewPostedReminderNote)action).setSelectedDate(this.getCurrentDate().getTime());
            ((ActionNewPostedReminderNote)action).setCalendarView(true);
            action.actionPerformed(null);
        }
    }

    @Override
    public void quickCreateItem(char thePressedChar) {
        ActiveCalendarItemPanel currentPanel = this.getCurrentPanel();
        if (currentPanel != null) {
            Point newLocation = new Point(0, 0);
            SwingUtilities.convertPointToScreen(newLocation, currentPanel);
            int height = this.getParent() instanceof JViewport ? this.getParent().getHeight() : currentPanel.getHeight();
            Dimension newSize = new Dimension(currentPanel.getWidth(), height);
            TypingWindow.getInstance(SwingUtilities.windowForComponent(this)).show(this.type, (Calendar)this.getCurrentDate().clone(), String.valueOf(thePressedChar), newLocation, newSize, this.getController());
        }
    }

    @Override
    public void setCurrentDate(Calendar theDate) {
        super.setCurrentDate(theDate);
    }

    private void selectFirstLabel(Date theDate) {
        if (this.isFocusOwner()) {
            ActiveCalendarItemPanel panel = this.getPanelForDate(theDate);
            if (panel == null) {
                return;
            }
            ArrayList labels = panel.getLabels(this.type);
            if (labels != null && !labels.isEmpty()) {
                ActiveItemLabel label = (ActiveItemLabel)labels.get(0);
                label.select();
                this.scrollRectToVisible(label.getBounds());
            } else {
                this.clearSelectedItem();
            }
        }
    }

    private void clearSelectedItem() {
        GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
        assert (gwCalendarController != null);
        gwCalendarController.itemSelected(null);
    }

    private static int getSelectedItemIndex(List labels) {
        int selected = -1;
        int nSize = labels.size();
        for (int i = 0; i < nSize; ++i) {
            ActiveItemLabel label = (ActiveItemLabel)labels.get(i);
            if (!label.isSelected()) continue;
            selected = i;
        }
        return selected;
    }

    private void handleClick(Point thePoint) {
        Calendar date = this.getDateAtPoint(thePoint);
        if (date != null && !GWCalendarUtils.isSameDate(this.getCurrentDate(), date)) {
            this.adjustCurrentTime(date);
            ActiveCalendarItemPanel panel = this.getCurrentPanel();
            if (panel == null) {
                return;
            }
            if (CalendarBoxesPanel.getSelectedItemIndex(panel.getLabels(this.type)) == -1) {
                this.selectFirstLabel(date.getTime());
            }
        }
    }

    private ActiveCalendarItemPanel getCurrentPanel() {
        return this.getPanelForDate(this.getCurrentDate().getTime());
    }

    private Calendar getDateAtPoint(Point thePoint) {
        Component componentAt = this.getComponentAt(thePoint);
        if (componentAt instanceof ActiveCalendarItemPanel) {
            ActiveCalendarItemPanel box = (ActiveCalendarItemPanel)componentAt;
            Calendar gc = (Calendar)box.getCurrentDate().clone();
            gc.set(10, this.getCurrentDate().get(10));
            gc.set(12, this.getCurrentDate().get(12));
            gc.set(9, this.getCurrentDate().get(9));
            return gc;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    private class LabelMouseClick
    extends MouseAdapter {
        private LabelMouseClick() {
        }

        public void mousePressed(MouseEvent e) {
            if (!CalendarBoxesPanel.this.isFocusOwner()) {
                CalendarBoxesPanel.this.grabFocus();
            }
            Point point = e.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)e.getSource());
            SwingUtilities.convertPointFromScreen(point, CalendarBoxesPanel.this);
            CalendarBoxesPanel.this.handleClick(point);
        }
    }

    private class BoxMouseListener
    extends MouseAdapter {
        private BoxMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (OS.isDoubleClick(e)) {
                ActiveCalendarItemPanel calendarItemPanel = (ActiveCalendarItemPanel)e.getSource();
                GWCalendar.createNewCalendarItem(CalendarBoxesPanel.this.getType(), calendarItemPanel.getCurrentDate().getTime(), CalendarBoxesPanel.this.getController(), true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            if (!CalendarBoxesPanel.this.isFocusOwner()) {
                CalendarBoxesPanel.this.grabFocus();
            }
            Point point = e.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)e.getSource());
            SwingUtilities.convertPointFromScreen(point, CalendarBoxesPanel.this);
            GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(CalendarBoxesPanel.this.getController());
            assert (gwCalendarController != null);
            gwCalendarController.itemSelected(null);
            CalendarBoxesPanel.this.handleClick(point);
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GWCalendarPopup pop = this.createPopup(e);
                pop.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private GWCalendarPopup createPopup(MouseEvent e) {
            ActiveCalendarItemPanel cip = (ActiveCalendarItemPanel)e.getSource();
            MVCController controller = cip.getController();
            return new GWCalendarPopup(CalendarBoxesPanel.this.getType(), cip.getCurrentDate().getTime(), controller);
        }
    }
}

