/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Day;
import com.appframework.utils.Interval;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.IItemListComponentDataModel;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveTypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.AllDayEventsBoxesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarScrollPane;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GradientBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ActiveHourLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.HourLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.CalendarBoxesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.DayHeaderPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyViewController;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.YearlyCalendar;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class WeeklyView
extends CalendarView {
    private static Logger logger = Logger.getLogger(WeeklyView.class);
    private static final int DEFAULT_VISIBLE_ADE_ITEMS = 10;
    private static final int DEFAULT_DAYS_COUNT = 5;
    private static int BTN_PLUS_DISABLED = 0;
    private static int BTN_PLUS_ENABLED = 1;
    private static int BTN_MINUS_DISABLED = 2;
    private static int BTN_MINUS_ENABLED = 3;
    public static final int WIDTH_OF_COLUMN = 35;
    private boolean isVertSplitVisible;
    private JSplitPane spltAppointments;
    private JSplitPane spltTaskNotes;
    private CalendarBoxesPanel tasksBoxesPanel;
    private CalendarBoxesPanel notesBoxesPanel;
    private AllDayEventsBoxesPanel allDayEventsBoxesPanel;
    private JPanel allAppointmentsPanel;
    private JPanel weeklyViewPanel;
    private JScrollPane scrollAppointments;
    private JComponent compNotes;
    private JComponent compTasks;
    private DayHeaderPanel dayLabels;
    private AppointmentsPanel appointmentsPanel;
    private JPanel focusedPanel = null;
    private AbstractItem itemSel;
    private int itemsCount = 0;
    private JSplitPane spltAllDayEvents;
    private JComponent allDayEventsPanel;
    private Interval<Day> visibleInterval = null;
    private TimeAndAppointmentsPanel timeAndAppointmentsPanel;
    private JPanel pnlHours;

    public WeeklyView(Calendar theCurrentDay, TypesToggle theToggle, MVCController theParentController, boolean showYearlyCalendar, IItemListComponentDataModel calendarItemListData) {
        super(theCurrentDay, theToggle, theParentController, showYearlyCalendar, calendarItemListData);
        this.buildUI();
        this.prepareRefresh(false);
        this.refreshAllDayEvents(this.getItemList(), null);
    }

    protected MVCController createController(MVCController theParentController) {
        return new WeeklyViewController(this, theParentController);
    }

    public boolean isAutosizeAllowed() {
        return ApplicationOptions.getInstance().getBoolean("AUTOSIZE_ALLOWED", true);
    }

    protected void buildUI() {
        int daysCount;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setFocusable(false);
        IViewDisplaySettings displaySettings = this.calendarItemListData.getViewDisplaySettings();
        if (displaySettings == null) {
            daysCount = ApplicationOptions.getInstance().getInteger("CALENDAR_WEEKLY_DAYS_SHOW", 7);
            if (daysCount < 1) {
                daysCount = 5;
            }
        } else {
            daysCount = displaySettings.getCalWeekColumnCount();
        }
        this.createVisibleInterval(daysCount);
        this.compNotes = this.buildNotesPanel();
        this.compTasks = this.buildTasksPanel();
        this.spltTaskNotes = new GWSplitPane(0, this.compNotes, this.compTasks);
        this.spltTaskNotes.setOneTouchExpandable(false);
        this.spltTaskNotes.setResizeWeight(0.5);
        this.spltTaskNotes.setBorder(BorderFactory.createEmptyBorder());
        this.spltTaskNotes.addPropertyChangeListener(new DividerPositionListener("CALENDAR_WEEKLY_TASKNOTES_SPLITPOS" + this.optionFrameName, this.spltTaskNotes));
        this.buildAppointmentsPanel();
        this.spltAppointments = new GWSplitPane(0, this.allAppointmentsPanel, this.spltTaskNotes);
        this.spltAppointments.setOneTouchExpandable(false);
        this.spltAppointments.setResizeWeight(0.5);
        this.spltAppointments.setBorder(BorderFactory.createEmptyBorder());
        this.spltAppointments.addPropertyChangeListener(new DividerPositionListener("CALENDAR_WEEKLY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, this.spltAppointments));
        if (this.yearlyCalendarComponent == null) {
            this.buildYearlyCalendarComponent();
        }
        this.add((Component)this.yearlyCalendarComponent, "Before");
        this.yearlyCalendarComponent.setVisible(this.showYearlyCalendar);
        this.weeklyViewPanel = new OrientablePanel(new BorderLayout());
        this.weeklyViewPanel.setBorder(LineBorder.createGrayLineBorder());
        this.weeklyViewPanel.add((Component)this.buildDaysLabelPanel(), "North");
        this.weeklyViewPanel.add((Component)this.spltAppointments, "Center");
        this.add((Component)this.weeklyViewPanel, "Center");
        this.appointmentsPanel.scrollRectToVisible(this.appointmentsPanel.getWorkTimeRectangle());
        this.adjustView();
        this.setSelectedTime();
    }

    protected void buildYearlyCalendarComponent() {
        this.yearlyCalendarComponent = new YearlyCalendar(this.currentDate, false, this.getController(), this.getItemList());
        this.yearlyCalendarComponent.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(2, 2, 2, 2), new GradientBorder(10, 10, 10, 10)));
        Dimension preferredSize = new Dimension(this.yearlyCalendarComponent.getPrefferedWidth() + 24, (int)this.yearlyCalendarComponent.getPreferredSize().getHeight());
        this.yearlyCalendarComponent.setPreferredSize(preferredSize);
        super.buildYearlyCalendarComponent();
    }

    public void refreshUIOptions() {
        super.refreshUIOptions();
        this.yearlyCalendarComponent.refreshUIOptions();
        this.dayLabels.setHighlightDays(this.highlightWeekends);
        this.yearlyCalendarComponent.setPreferredSize(new Dimension(this.yearlyCalendarComponent.getPrefferedWidth() + 24, (int)this.yearlyCalendarComponent.getPreferredSize().getHeight()));
        this.appointmentsPanel.refreshUIOptions();
    }

    private void buildAppointmentsPanel() {
        Calendar date = GWCalendarUtils.getToday();
        date.setTime(this.getCurrentDate());
        this.appointmentsPanel = new AppointmentsPanel(this.getDaysCount(), this.getController(), date);
        this.appointmentsPanel.setBorder(BorderFactory.createEmptyBorder());
        ActiveHourLabelsPanel hourLabelsPanel = new ActiveHourLabelsPanel((Border)BorderFactory.createMatteBorder(1, 1, 1, 0, ColorConstants.HEADER_BORDER_COLOR), this.getController());
        hourLabelsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.pnlHours = new JPanel(new BorderLayout());
        this.pnlHours.add((Component)hourLabelsPanel, "After");
        if (ActiveTypesToggle.getInstance() != null && ActiveTypesToggle.getInstance().isShowAlternateTimeZone()) {
            ActiveHourLabelsPanel alternateHourLabelsPanel = new ActiveHourLabelsPanel(BorderFactory.createMatteBorder(1, 1, 1, 0, ColorConstants.HEADER_BORDER_COLOR), this.getController(), true);
            alternateHourLabelsPanel.setBorder(BorderFactory.createEmptyBorder());
            this.pnlHours.add((Component)alternateHourLabelsPanel, "Before");
        }
        this.timeAndAppointmentsPanel = new TimeAndAppointmentsPanel(new BorderLayout());
        this.timeAndAppointmentsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.timeAndAppointmentsPanel.removeAll();
        this.timeAndAppointmentsPanel.add((Component)this.pnlHours, "Before");
        this.timeAndAppointmentsPanel.add((Component)this.appointmentsPanel, "Center");
        this.appointmentsPanel.setEnabled(this.checkAppointmentAccess());
        this.scrollAppointments = new CalendarScrollPane(this.timeAndAppointmentsPanel, 22, 31);
        this.scrollAppointments.setBorder(BorderFactory.createEmptyBorder());
        this.allAppointmentsPanel = new OrientablePanel(new BorderLayout());
        this.allAppointmentsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.allDayEventsPanel = this.buildAllDayEventsPanel();
        this.buildADEPanel();
    }

    private void buildADEPanel() {
        if (this.isAutosizeAllowed()) {
            this.allAppointmentsPanel.add((Component)this.allDayEventsPanel, "North");
            this.allAppointmentsPanel.add((Component)this.scrollAppointments, "Center");
        } else {
            this.spltAllDayEvents = new GWSplitPane(0, this.allDayEventsPanel, this.scrollAppointments);
            this.spltAllDayEvents.setOneTouchExpandable(false);
            if (this.itemsCount >= 0 && this.itemsCount < 4) {
                this.spltAllDayEvents.setDividerLocation(60);
            } else if (this.itemsCount >= 4 && this.itemsCount <= 10) {
                this.spltAllDayEvents.setDividerLocation(20 * this.itemsCount);
            } else {
                this.spltAllDayEvents.setDividerLocation(190);
            }
            this.spltAllDayEvents.setBorder(BorderFactory.createEmptyBorder());
            this.spltAllDayEvents.addPropertyChangeListener(new DividerPositionListener("CALENDAR_WEEKLY_TASKNOTES_SPLITPOS" + this.optionFrameName, this.spltAllDayEvents));
            this.allAppointmentsPanel.add((Component)this.spltAllDayEvents, "Center");
        }
    }

    private JComponent buildNotesPanel() {
        this.notesBoxesPanel = new CalendarBoxesPanel(this.getController(), "Note", this.getDaysCount(), true);
        this.notesBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.notesBoxesPanel.setEnabled(this.checkNoteAccess());
        return CalendarUtils.createLeftCaptionAndScrollPane(this.notesBoxesPanel, ImageResources.ITM_NOTE_LARGE, this.controller, "Note", false);
    }

    private JComponent buildTasksPanel() {
        this.tasksBoxesPanel = new CalendarBoxesPanel(this.getController(), "Task", this.getDaysCount(), true);
        this.tasksBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.tasksBoxesPanel.setEnabled(this.checkTaskAccess());
        return CalendarUtils.createLeftCaptionAndScrollPane(this.tasksBoxesPanel, ImageResources.ITM_TASK_LARGE, this.controller, "Task", false);
    }

    private JComponent buildAllDayEventsPanel() {
        this.allDayEventsBoxesPanel = new AllDayEventsBoxesPanel(this.getController(), this.getDaysCount(), true);
        this.allDayEventsBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.allDayEventsBoxesPanel.setEnabled(this.checkAppointmentAccess());
        JComponent result = CalendarUtils.createLeftCaptionAndScrollPane(this.allDayEventsBoxesPanel, ImageResources.ITM_ALL_DAY_EVENT_LARGE, BorderFactory.createMatteBorder(1, 0, 0, 0, ColorConstants.HEADER_BORDER_COLOR), this.controller, "AllDayEvent", true);
        result.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, result.getBackground()));
        result.setPreferredSize(new Dimension(0, 60));
        return result;
    }

    private int getDaysCount() {
        return this.visibleInterval.getEnd().getDifference(this.visibleInterval.getStart()) + 1;
    }

    private void decreaseDaysCount() {
        this.updateVisibleInterval(null, this.getDaysCount() - 1);
    }

    private void increaseDaysCount() {
        this.updateVisibleInterval(null, this.getDaysCount() + 1);
    }

    public void storeDaysCount() {
        ApplicationOptions.getInstance().put("CALENDAR_WEEKLY_DAYS_SHOW", this.getDaysCount());
    }

    private JPanel buildDaysLabelPanel() {
        Object o;
        this.dayLabels = new DayHeaderPanel(this.getDaysCount(), this.highlightWeekends);
        this.dayLabels.setBorder(BorderFactory.createEmptyBorder());
        OrientablePanel result = new OrientablePanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder());
        result.add((Component)this.dayLabels, "Center");
        OrientableLabel lbl = new OrientableLabel(" ");
        lbl.setBorder(BorderFactory.createEmptyBorder());
        int width = HourLabelsPanel.getPanelWidth();
        if (ActiveTypesToggle.getInstance() != null && ActiveTypesToggle.getInstance().isShowAlternateTimeZone()) {
            width += width;
        }
        int scrollBarWidth = (o = UIManager.get("ScrollBar.width")) != null && o instanceof Integer ? (Integer)o : new JScrollBar().getPreferredSize().width;
        if (!UIUtils.getComponentOrientation().isLeftToRight()) {
            result.setBorder(BorderFactory.createEmptyBorder(0, scrollBarWidth, 0, width));
        } else {
            result.setBorder(BorderFactory.createEmptyBorder(0, width, 0, scrollBarWidth));
        }
        this.dayLabels.addComponentListener(new ResizeListener());
        return result;
    }

    protected CalendarViewType getViewType() {
        return CalendarViewType.WEEKLY;
    }

    protected void prepareRefresh(boolean folderWasChanged) {
        IViewDisplaySettings displaySettings;
        logger.debug((Object)"prepareRefresh entered");
        if (folderWasChanged && (displaySettings = this.getDisplaySettings()) != null) {
            int weekColumnCount = displaySettings.getCalWeekColumnCount();
            int count = this.getDaysCount();
            if (count != weekColumnCount) {
                int maxDays = this.dayLabels.getWidth() / 35;
                while (weekColumnCount != this.getDaysCount()) {
                    int shift;
                    int n = shift = weekColumnCount > this.getDaysCount() ? 1 : -1;
                    if (this.getDaysCount() > maxDays - 1 && shift > 0) break;
                    this.changeDaysCount(shift);
                }
            }
        }
        if (this.showYearlyCalendar) {
            this.calendarAdjusting = true;
            this.yearlyCalendarComponent.setCurrentDate(this.currentDate);
            if (folderWasChanged && this.yearlyCalendarComponent != null) {
                this.yearlyCalendarComponent.setDirty();
                this.yearlyCalendarComponent.validateBusyDays(this.getItemList());
            }
            this.calendarAdjusting = false;
        }
        if (this.isNeedRefresh()) {
            this.refreshStartDay();
        }
        this.dayLabels.setTitles(GWCalendarUtils.convertDayToCalendar(this.visibleInterval.getStart()).getTime(), this.getCurrentDate());
        logger.debug((Object)"prepareRefresh exited");
    }

    private void refreshStartDay() {
        assert (this.visibleInterval != null);
        logger.debug((Object)"refreshStartDay entered...");
        logger.debug((Object)("this.visibleInterval: " + this.visibleInterval));
        logger.debug((Object)("this.currentDate: " + this.currentDate));
        boolean moved = false;
        if (!this.visibleInterval.contains(this.currentDate)) {
            if (this.currentDate.compareTo(this.visibleInterval.getStart()) < 0) {
                Calendar calendar = GWCalendarUtils.convertDayToCalendar(this.currentDate);
                calendar.add(6, 1);
                if (this.visibleInterval.getStart().equals(new Day(calendar))) {
                    logger.debug((Object)"move 1 day backward");
                    this.updateVisibleInterval(-1, null);
                    moved = true;
                }
            } else if (this.currentDate.compareTo(this.visibleInterval.getEnd()) > 0) {
                Calendar calendar = GWCalendarUtils.convertDayToCalendar(this.currentDate);
                calendar.add(6, -1);
                if (this.visibleInterval.getEnd().equals(new Day(calendar))) {
                    logger.debug((Object)"move 1 day forward");
                    this.updateVisibleInterval(1, null);
                    moved = true;
                }
            }
            if (!moved) {
                this.createVisibleInterval(null);
            }
        }
        logger.debug((Object)("this.visibleInterval: " + this.visibleInterval));
        logger.debug((Object)"... refreshStartDay exited");
    }

    private void createVisibleInterval(Integer duration) {
        logger.debug((Object)("creating, duration: " + duration));
        if (duration == null) {
            duration = this.getDaysCount();
            logger.debug((Object)("using current duration: " + duration));
        }
        Calendar temporaryCalendar = GWCalendarUtils.getDateForDayOfWeek(GWCalendarUtils.convertDayToCalendar(this.currentDate), 1);
        this.visibleInterval = new Interval<Day>(new Day(temporaryCalendar), new Day(temporaryCalendar).addDays(duration - 1));
        while (!this.visibleInterval.contains(this.currentDate)) {
            logger.debug((Object)"move 1 day forward");
            this.updateVisibleInterval(1, null);
        }
        logger.debug((Object)("this.visibleInterval: " + this.visibleInterval));
    }

    private void updateVisibleInterval(Integer shift, Integer duration) {
        logger.debug((Object)("shift: " + shift));
        logger.debug((Object)("duration: " + duration));
        logger.debug((Object)("this.visibleInterval: " + this.visibleInterval));
        Day start = this.visibleInterval.getStart().makeClone();
        if (shift != null) {
            start.addDays(shift);
        }
        if (duration == null) {
            duration = this.getDaysCount();
            logger.debug((Object)("using default duration: " + duration));
        }
        this.visibleInterval = new Interval<Day>(start, start.makeClone().addDays(duration - 1));
        logger.debug((Object)("this.visibleInterval: " + this.visibleInterval));
    }

    protected void refreshTasks(IItemList theItemList, TimeInterval theChangedInterval) {
        AbstractItem item = null;
        if (this.itemSel instanceof TaskItem) {
            item = this.itemSel;
        }
        if (this.itemSel == null) {
            GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
            assert (gwCalendarController != null);
            gwCalendarController.itemSelected(null);
        }
        this.tasksBoxesPanel.setItemSel(item);
        this.tasksBoxesPanel.loadItemsForDate(GWCalendarUtils.convertDayToCalendar(this.visibleInterval.getStart()), theItemList, theChangedInterval);
    }

    protected void refreshNotes(IItemList theItemList, TimeInterval theChangedInterval) {
        AbstractItem item = null;
        if (this.itemSel instanceof ReminderNote) {
            item = this.itemSel;
        }
        this.notesBoxesPanel.setItemSel(item);
        this.notesBoxesPanel.loadItemsForDate(GWCalendarUtils.convertDayToCalendar(this.visibleInterval.getStart()), theItemList, theChangedInterval);
    }

    protected void refreshAppointments(IItemList theItemList, TimeInterval theChangedInterval) {
        AbstractItem item = null;
        if (this.appointmentsPanel.equals(this.focusedPanel) && this.itemSel instanceof AppointmentItem) {
            item = this.itemSel;
        }
        this.appointmentsPanel.setItemSel(item);
        this.appointmentsPanel.loadItemsForDate(GWCalendarUtils.convertDayToCalendar(this.visibleInterval.getStart()), theItemList, theChangedInterval);
    }

    protected void refreshAllDayEvents(IItemList theItemList, TimeInterval theChangedInterval) {
        AbstractItem item = null;
        if (this.allDayEventsBoxesPanel.equals(this.focusedPanel) && this.itemSel instanceof AppointmentItem) {
            item = this.itemSel;
        }
        this.allDayEventsBoxesPanel.setItemSel(item);
        this.allDayEventsBoxesPanel.loadItemsForDate(GWCalendarUtils.convertDayToCalendar(this.visibleInterval.getStart()), theItemList);
        this.itemsCount = this.allDayEventsBoxesPanel.getMaxCountOfElements();
        int height = this.itemsCount >= 0 && this.itemsCount < 4 ? 60 : (this.itemsCount >= 4 && this.itemsCount <= 10 ? 20 * this.itemsCount : 190);
        this.allDayEventsPanel.setPreferredSize(new Dimension(0, height));
    }

    protected void setDirty() {
        if (this.showYearlyCalendar) {
            this.yearlyCalendarComponent.setDirty();
        }
    }

    private Calendar getEndDay() {
        Calendar endDay = GWCalendarUtils.convertDayToCalendar(this.visibleInterval.getEnd());
        endDay.set(11, 23);
        endDay.set(12, 59);
        endDay.set(13, 59);
        endDay.set(14, 999);
        return endDay;
    }

    private void adjustView() {
        if (!this.typesToggle.isShowAppointments()) {
            this.spltAppointments.remove(this.allAppointmentsPanel);
        }
        if (!this.typesToggle.isShowNotes()) {
            this.spltTaskNotes.remove(this.compNotes);
        }
        if (!this.typesToggle.isShowTasks()) {
            this.spltTaskNotes.remove(this.compTasks);
        }
        if (!this.typesToggle.isShowNotes() && !this.typesToggle.isShowTasks()) {
            this.spltAppointments.remove(this.spltTaskNotes);
            this.isVertSplitVisible = false;
        } else {
            this.isVertSplitVisible = true;
        }
        this.adjustSplitters();
    }

    private void adjustSplitters() {
        int pos = ApplicationOptions.getInstance().getInteger("CALENDAR_WEEKLY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, -1);
        this.spltAppointments.setDividerLocation(pos);
        pos = ApplicationOptions.getInstance().getInteger("CALENDAR_WEEKLY_TASKNOTES_SPLITPOS" + this.optionFrameName, -1);
        this.spltTaskNotes.setDividerLocation(pos);
    }

    protected void adjustTasks() {
        if (this.typesToggle.isShowTasks()) {
            if (!this.isVertSplitVisible) {
                this.spltAppointments.add(this.spltTaskNotes);
                this.isVertSplitVisible = true;
            }
            this.spltTaskNotes.add(this.compTasks);
        } else {
            this.spltTaskNotes.remove(this.compTasks);
            if (!this.typesToggle.isShowNotes()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        }
        this.adjustSplitters();
    }

    protected void adjustNotes() {
        if (this.typesToggle.isShowNotes()) {
            if (!this.isVertSplitVisible) {
                this.spltAppointments.add(this.spltTaskNotes);
                this.isVertSplitVisible = true;
            }
            if (this.typesToggle.isShowTasks()) {
                this.spltTaskNotes.remove(this.compTasks);
                this.spltTaskNotes.add(this.compNotes);
                this.spltTaskNotes.add(this.compTasks);
            } else {
                this.spltTaskNotes.add(this.compNotes);
            }
        } else {
            this.spltTaskNotes.remove(this.compNotes);
            if (!this.typesToggle.isShowTasks()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        }
        this.adjustSplitters();
    }

    protected void adjustAppointments() {
        if (this.typesToggle.isShowAppointments()) {
            this.spltAppointments.add(this.allAppointmentsPanel);
            if (!this.typesToggle.isShowTasks() && !this.typesToggle.isShowNotes()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        } else {
            this.spltAppointments.remove(this.allAppointmentsPanel);
        }
        this.adjustSplitters();
    }

    public JPanel getFocusedPanel() {
        return this.focusedPanel;
    }

    public void setFocusedPanel(JPanel focusedPanel) {
        this.focusedPanel = focusedPanel;
    }

    public void setItemSel(AbstractItem itemSel) {
        this.itemSel = itemSel;
    }

    private void changeDaysCount(int x) {
        Command command;
        if (x == 1) {
            if (this.dayLabels.getWidth() <= 0 || this.getDaysCount() < this.dayLabels.getWidth() / 35) {
                this.fillWithDataAndIncreaseDaysCount();
            } else {
                command = new Command(1580, BTN_PLUS_DISABLED);
                command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(this.getController()));
                this.getController().processCommand(command);
            }
        } else if (x == -1) {
            if (this.getDaysCount() > 1) {
                this.decreaseDaysCount();
                this.dayLabels.removeLabel();
                this.appointmentsPanel.removeBox();
                this.tasksBoxesPanel.removeBox();
                this.notesBoxesPanel.removeBox();
                this.allDayEventsBoxesPanel.removeBox(this.calendarItemListData.getItemList());
                command = new Command(1580, BTN_PLUS_ENABLED);
                command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(this.getController()));
                this.getController().processCommand(command);
                if (this.getDaysCount() == 1) {
                    Command command2 = new Command(1580, BTN_MINUS_DISABLED);
                    command2.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(this.getController()));
                    this.getController().processCommand(command2);
                }
            } else {
                Command command2 = new Command(1580, BTN_MINUS_DISABLED);
                command2.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(this.getController()));
                this.getController().processCommand(command2);
            }
        }
        Calendar endDay = this.getEndDay();
        this.visibleInterval = new Interval<Day>(this.visibleInterval.getStart().makeClone(), new Day(endDay));
        if (!this.visibleInterval.contains(this.currentDate)) {
            Calendar temporaryCalendar = GWCalendarUtils.convertDayToCalendar(this.currentDate);
            endDay.set(11, temporaryCalendar.get(11));
            endDay.set(12, temporaryCalendar.get(12));
            Command command2 = new Command(70, endDay);
            this.getController().processCommand(command2);
        }
        this.validate();
        this.repaint();
    }

    private void fillWithDataAndIncreaseDaysCount() {
        Command command;
        this.dayLabels.addLabel();
        this.dayLabels.setTitles(GWCalendarUtils.convertDayToCalendar(this.visibleInterval.getStart()).getTime(), this.getCurrentDate());
        IItemList itemList = this.getItemList();
        this.appointmentsPanel.addBox(itemList);
        this.increaseDaysCount();
        this.tasksBoxesPanel.addBoxAndLoadData(this.getEndDay(), itemList, GWCalendarUtils.getTasks(this.getItemList(), new Day(this.getEndDay())));
        this.notesBoxesPanel.addBoxAndLoadData(this.getEndDay(), itemList, GWCalendarUtils.getNotes(this.getItemList(), new Day(this.getEndDay())));
        this.allDayEventsBoxesPanel.addBoxAndLoadData(this.getEndDay(), GWCalendarUtils.getAllDayEvents(this.getItemList(), this.getEndDay().getTime()), this.getItemList());
        if (this.getDaysCount() == this.dayLabels.getWidth() / 35) {
            command = new Command(1580, BTN_PLUS_DISABLED);
            command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(this.getController()));
            this.getController().processCommand(command);
        }
        command = new Command(1580, BTN_MINUS_ENABLED);
        command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(this.getController()));
        this.getController().processCommand(command);
    }

    public void setMVCModel(Object model) {
        super.setMVCModel(model);
        if (model instanceof Integer) {
            this.changeDaysCount((Integer)model);
            if (this.getDisplaySettings() != null) {
                this.getDisplaySettings().setCalWeekColumnCount(this.getDaysCount());
            }
        }
    }

    public void setMonthPickerVisibled(boolean b) {
        this.showYearlyCalendar = b;
        this.yearlyCalendarComponent.setVisible(b);
    }

    protected void adjustClock() {
        if (this.typesToggle.isShowAppointments()) {
            this.appointmentsPanel.adjustClock();
            this.timeAndAppointmentsPanel.adjustClock();
        }
    }

    protected void adjustCurrentDay() {
        assert (this.visibleInterval != null);
        if (this.visibleInterval.contains(this.currentDate)) {
            this.dayLabels.setTitles(GWCalendarUtils.convertDayToCalendar(this.visibleInterval.getStart()).getTime(), this.getCurrentDate());
            this.needRefresh(false);
        } else {
            this.needRefresh(true);
            this.refresh(false);
        }
        if (this.canRefresh() && this.showYearlyCalendar) {
            this.calendarAdjusting = true;
            this.yearlyCalendarComponent.setCurrentDate(this.currentDate);
            this.calendarAdjusting = false;
        }
    }

    public void requestFocus() {
        if (this.focusedPanel != null) {
            this.focusedPanel.requestFocus();
        } else {
            this.appointmentsPanel.requestFocus();
        }
    }

    public void folderChanged() {
        if (this.showYearlyCalendar) {
            this.yearlyCalendarComponent.setItemList(this.calendarItemListData.getItemList());
        }
    }

    public void rebuild() {
        this.removeAll();
        this.buildUI();
        this.prepareRefresh(false);
        this.refreshAllDayEvents(this.getItemList(), null);
        this.refreshAppointments(this.getItemList(), null);
        this.refreshTasks(this.getItemList(), null);
        this.refreshNotes(this.getItemList(), null);
        this.adjustCurrentDay();
    }

    public String getName() {
        return "CalendarView-nWeekly";
    }

    private class TimeAndAppointmentsPanel
    extends OrientablePanel {
        private int clockPosition;

        private TimeAndAppointmentsPanel(LayoutManager layout) {
            super(layout);
        }

        public void paint(Graphics g) {
            g = UIUtils.enableAntialiasing(g);
            super.paint(g);
            int x = WeeklyView.this.pnlHours.getWidth() - ImageResources.CLOCK_SMALL.getImage().getWidth(this) / 2;
            int y = this.clockPosition - ImageResources.CLOCK_SMALL.getImage().getHeight(this) / 2;
            g.drawImage(ImageResources.CLOCK_SMALL.getImage(), x, y, null);
            if (y > 0) {
                g.drawImage(ImageResources.CLOCK_SMALL.getImage(), x, y, null);
            }
        }

        public void adjustClock() {
            this.clockPosition = GWCalendarUtils.getClockPosition();
            this.repaint();
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        private void doIt() {
            int daysMax = WeeklyView.this.dayLabels.getWidth() / 35;
            if (WeeklyView.this.dayLabels.getWidth() > 0) {
                Command command;
                while (daysMax < WeeklyView.this.getDaysCount()) {
                    if (WeeklyView.this.getDaysCount() > 1) {
                        WeeklyView.this.decreaseDaysCount();
                        WeeklyView.this.dayLabels.removeLabel();
                        WeeklyView.this.appointmentsPanel.removeBox();
                        WeeklyView.this.tasksBoxesPanel.removeBox();
                        WeeklyView.this.notesBoxesPanel.removeBox();
                        WeeklyView.this.allDayEventsBoxesPanel.removeBox(WeeklyView.this.calendarItemListData.getItemList());
                        command = new Command(1580, BTN_PLUS_ENABLED);
                        command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(WeeklyView.this.getController()));
                        WeeklyView.this.getController().processCommand(command);
                        if (WeeklyView.this.getDaysCount() != 1) continue;
                        Command command2 = new Command(1580, BTN_MINUS_DISABLED);
                        command2.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(WeeklyView.this.getController()));
                        WeeklyView.this.getController().processCommand(command2);
                        continue;
                    }
                    Command command2 = new Command(1580, BTN_MINUS_DISABLED);
                    command2.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(WeeklyView.this.getController()));
                    WeeklyView.this.getController().processCommand(command2);
                    break;
                }
                while (WeeklyView.this.getDaysCount() < daysMax && WeeklyView.this.getDaysCount() < WeeklyView.this.getDisplaySettings().getCalWeekColumnCount()) {
                    WeeklyView.this.fillWithDataAndIncreaseDaysCount();
                }
                if (WeeklyView.this.getDaysCount() < daysMax) {
                    command = new Command(1580, BTN_PLUS_ENABLED);
                    command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(WeeklyView.this.getController()));
                    WeeklyView.this.getController().processCommand(command);
                } else {
                    command = new Command(1580, BTN_PLUS_DISABLED);
                    command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(WeeklyView.this.getController()));
                    WeeklyView.this.getController().processCommand(command);
                }
                if (WeeklyView.this.getDaysCount() < 2) {
                    command = new Command(1580, BTN_MINUS_DISABLED);
                    command.setAttribute((Object)AttributeKey.CALENDAR, ControlsUtils.getParentGWCalendarController(WeeklyView.this.getController()));
                    WeeklyView.this.getController().processCommand(command);
                }
            }
        }

        public void componentResized(ComponentEvent e) {
            this.doIt();
        }
    }
}

