/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcomponent;

import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWCutCopyPasteUndoable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWComponentClipboardAdapter<T extends JTextComponent>
implements GWCutCopyPasteUndoable {
    private T textComponent;
    private UndoManager undoManager;

    public GWComponentClipboardAdapter(T theComponent) {
        this.textComponent = theComponent;
        this.undoManager = new UndoManager();
        this.initComponent();
    }

    private void initComponent() {
        if (this.textComponent != null) {
            ((JTextComponent)this.textComponent).getDocument().addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent evt) {
                    GWComponentClipboardAdapter.this.undoManager.addEdit(evt.getEdit());
                }
            });
            ((JComponent)this.textComponent).getActionMap().put("Undo", new UndoAction());
            ((JComponent)this.textComponent).getInputMap().put(KeyStroke.getKeyStroke(90, OS.isMacOS() ? 256 : 128), "Undo");
            ((JComponent)this.textComponent).getActionMap().put("Redo", new RedoAction());
            ((JComponent)this.textComponent).getInputMap().put(KeyStroke.getKeyStroke(89, OS.isMacOS() ? 256 : 128), "Redo");
        }
    }

    protected void finalize() throws Throwable {
        if (this.undoManager != null) {
            this.undoManager.die();
        }
        super.finalize();
    }

    public T getTextComponent() {
        return this.textComponent;
    }

    @Override
    public void cut() {
        ((JTextComponent)this.textComponent).cut();
    }

    @Override
    public boolean canCut() {
        return this.canCopy() && ((JTextComponent)this.textComponent).isEditable();
    }

    @Override
    public void copy() {
        ((JTextComponent)this.textComponent).copy();
    }

    @Override
    public boolean canCopy() {
        return !Utils.isNullOrEmpty(((JTextComponent)this.textComponent).getSelectedText());
    }

    @Override
    public void paste() {
        ((JTextComponent)this.textComponent).paste();
    }

    @Override
    public boolean canPaste() {
        return ((JTextComponent)this.textComponent).isEditable();
    }

    @Override
    public void undo() {
        this.undoManager.undo();
    }

    @Override
    public boolean canUndo() {
        return this.undoManager.canUndo() && ((JTextComponent)this.textComponent).isEditable();
    }

    @Override
    public void redo() {
        this.undoManager.redo();
    }

    @Override
    public boolean canRedo() {
        return this.undoManager.canRedo() && ((JTextComponent)this.textComponent).isEditable();
    }

    @Override
    public void delete() {
        int startIndex = ((JTextComponent)this.textComponent).getSelectionStart();
        int endIndex = ((JTextComponent)this.textComponent).getSelectionEnd();
        int p0 = Math.min(startIndex, endIndex);
        int p1 = Math.max(startIndex, endIndex);
        try {
            if (p0 != p1) {
                Document doc = ((JTextComponent)this.textComponent).getDocument();
                doc.remove(p0, p1 - p0);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean canDelete() {
        return this.canCut();
    }

    @Override
    public void selectAll() {
        ((JTextComponent)this.textComponent).selectAll();
    }

    private class RedoAction
    extends AbstractAction {
        private RedoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (GWComponentClipboardAdapter.this.canRedo()) {
                GWComponentClipboardAdapter.this.redo();
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        private UndoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (GWComponentClipboardAdapter.this.canUndo()) {
                GWComponentClipboardAdapter.this.undo();
            }
        }
    }
}

