/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.header;

import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.MVCController;
import com.appframework.resources.ImageResources;
import com.novell.gw.folder.FolderEvent;
import com.novell.gw.folder.FolderListener;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.Borders;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.folderstree.GWTree;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.menus.FolderPopupMenu;
import com.novell.gw.jclient.application.controls.menus.ReducedFolderPopupMenu;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import com.novell.gw.jclient.application.plaf.FoldersTreeUI;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class HeaderLabel
extends SkinnableLabel
implements FolderListener {
    private static Logger logger = Logger.getLogger(HeaderLabel.class);
    private static final int ARROW_DISTANCE = 3;
    private boolean mouseOn = false;
    private boolean lineOn = false;
    private JComponent popupContents;
    private JPopupWrapper popupMenu = null;
    private JComponent anchorComponent = null;
    private ImageIcon downArrow = ImageResources.ARROW_DOWN;
    private boolean isEnablePopupFolderList = false;
    private boolean filtered = false;
    private AbstractFolder folder;
    private ChangeListener changeListener;
    private Color labelColor;
    private static final Insets WIDER_INSETS = new Insets(4, 3, 4, 3);

    public HeaderLabel() {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_START_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_BORDER_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
        this.labelColor = null;
        this.init();
    }

    private void init() {
        this.setFocusable(true);
        this.addMouseListener(new HeaderLabelMouseListener());
        this.addPropertyChangeListener("text", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                HeaderLabel.this.lineOn = false;
                HeaderLabel.this.resizeMe();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                HeaderLabel.this.lineOn = true;
                HeaderLabel.this.refresh();
            }

            public void focusLost(FocusEvent e) {
                HeaderLabel.this.lineOn = false;
                HeaderLabel.this.refresh();
            }
        });
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
        this.updateText();
    }

    private void refresh() {
        this.invalidate();
        JPanel p = (JPanel)this.getParent();
        p.updateUI();
        p.repaint();
    }

    public void setTree(GWTree folderTree) {
        if (folderTree != null) {
            folderTree.addMouseListener(new HeaderLabelPopupMouseListener());
        }
    }

    private void resizeMe() {
        if (this.isEnablePopupFolderList) {
            Dimension sz = this.calcSize();
            this.invalidate();
            this.setSize(sz);
            this.validate();
        }
    }

    private Dimension calcSize() {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        Rectangle stringBounds = new Rectangle(0, 0, fm.stringWidth(this.getText()), fm.getHeight());
        Insets i = WIDER_INSETS;
        Icon icon = this.getIcon();
        int w = (icon == null ? 0 : icon.getIconWidth() + this.getIconTextGap()) + stringBounds.width;
        w += i.left;
        if (this.isEnablePopupFolderList) {
            w += 6 + this.downArrow.getIconWidth();
        }
        int h = stringBounds.height + i.top + i.bottom;
        return new Dimension(w += i.right, h);
    }

    public Dimension getPreferredSize() {
        return this.calcSize();
    }

    public Dimension getMinimumSize() {
        return this.calcSize();
    }

    public void setIcon(Icon icon) {
        GWMainAppFrame mainFrame = GWClient.getGWMainAppFrame();
        if (mainFrame.getFolder() instanceof SubCalendarFolder) {
            super.setIcon(com.novell.gw.jclient.application.resources.ImageResources.FLD_FOLDER_OPEN);
        } else {
            super.setIcon(icon);
        }
    }

    private void updateForeground(Color foreColor) {
        super.setForeground(foreColor);
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.labelColor = fg;
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public void setFolder(AbstractFolder folder) {
        if (this.folder != null) {
            this.folder.getNativeFolder().removeFolderListener(this);
        }
        this.folder = folder;
        if (this.folder != null) {
            this.folder.getNativeFolder().addFolderListener(this);
        }
        this.updateText();
    }

    public void paint(Graphics g) {
        if (this.mouseOn && this.isEnablePopupFolderList) {
            this.paintGradient(g);
        } else if (this.labelColor != null) {
            this.updateForeground(this.labelColor);
        } else {
            this.updateForeground(this.getParent().getForeground());
        }
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (this.isEnablePopupFolderList && ltr) {
            g.translate(HeaderLabel.WIDER_INSETS.left, 0);
        }
        super.paint(g);
        Font f = this.getFont();
        Rectangle stringBounds = g.getFontMetrics(f).getStringBounds(this.getText(), g).getBounds();
        Insets i = WIDER_INSETS;
        if (this.lineOn) {
            Icon icon = this.getIcon();
            int x = ltr ? i.left + (icon != null ? icon.getIconWidth() : 0) : i.left + (this.isEnablePopupFolderList ? 6 + this.downArrow.getIconWidth() : -1) + this.getIconTextGap();
            Rectangle r = this.getBounds();
            g.setColor(this.getForeground());
            g.drawLine(x, (r.height - stringBounds.height) / 2 + stringBounds.height, x + stringBounds.width, (r.height - stringBounds.height) / 2 + stringBounds.height);
        }
        if (this.isEnablePopupFolderList) {
            int x;
            if (ltr) {
                Icon icon = this.getIcon();
                x = (icon == null ? 0 : icon.getIconWidth() + this.getIconTextGap()) + stringBounds.width + 3 + HeaderLabel.WIDER_INSETS.left;
                g.translate(-HeaderLabel.WIDER_INSETS.left, 0);
            } else {
                x = i.left + 3;
            }
            g.drawImage(this.downArrow.getImage(), x, (this.getSize().height - this.downArrow.getIconHeight()) / 2, this);
        }
    }

    private void paintGradient(Graphics g) {
        if (this.labelColor == null) {
            this.labelColor = this.getForeground();
        }
        Graphics2D g2D = (Graphics2D)g;
        Color highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
        Color highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
        Color lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
        Color lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
        Color textColor = (Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR);
        Color borderColor = (Color)this.getClientProperty((Object)SkinProperty.HILITE_BORDER_COLOR);
        this.updateForeground(textColor);
        int w = this.getSize().width;
        int h = this.getSize().height;
        GeneralPath border = new GeneralPath();
        border.moveTo(4.0f, 1.0f);
        border.lineTo(3.0f, 1.0f);
        border.lineTo(1.0f, 3.0f);
        border.lineTo(1.0f, 4.0f);
        border.lineTo(0.0f, 5.0f);
        border.lineTo(0.0f, h - 6);
        border.lineTo(1.0f, h - 5);
        border.lineTo(1.0f, h - 4);
        border.lineTo(3.0f, h - 2);
        border.lineTo(4.0f, h - 2);
        border.lineTo(5.0f, h - 1);
        border.lineTo(w - 6, h - 1);
        border.lineTo(w - 5, h - 2);
        border.lineTo(w - 4, h - 2);
        border.lineTo(w - 2, h - 4);
        border.lineTo(w - 2, h - 5);
        border.lineTo(w - 1, h - 6);
        border.lineTo(w - 1, 5.0f);
        border.lineTo(w - 2, 4.0f);
        border.lineTo(w - 2, 3.0f);
        border.lineTo(w - 4, 1.0f);
        border.lineTo(w - 5, 1.0f);
        border.lineTo(w - 6, 0.0f);
        border.lineTo(5.0f, 0.0f);
        GradientPaint paintHigherSegment = new GradientPaint(0.0f, 0.0f, highSegmentColorFrom, 0.0f, (int)((double)this.getHeight() * 0.3), highSegmentColorTo);
        g2D.setPaint(paintHigherSegment);
        g2D.fill(border);
        GradientPaint paintLowerSegment = new GradientPaint(0.0f, (int)((double)this.getHeight() * 0.3), lowSegmentColorFrom, 0.0f, this.getHeight(), lowSegmentColorTo);
        g2D.setPaint(paintLowerSegment);
        g2D.fill(border);
        if (borderColor != null) {
            g2D.setColor(borderColor);
            g2D.draw(border);
        }
    }

    public Insets getInsets() {
        return WIDER_INSETS;
    }

    public void setPopupContents(JComponent popupContents) {
        if (popupContents != null) {
            this.popupContents = popupContents;
        }
    }

    public void setAnchorComponent(JComponent anchorComponent) {
        this.anchorComponent = anchorComponent;
    }

    public boolean isEnablePopupFolderList() {
        return this.isEnablePopupFolderList;
    }

    public void setEnablePopupFolderList(boolean isEnablePopupFolderList) {
        this.isEnablePopupFolderList = isEnablePopupFolderList;
        if (!this.isEnablePopupFolderList && this.popupMenu != null && this.popupMenu.isShowing()) {
            this.hidePopup();
        }
        if (!this.isEnablePopupFolderList) {
            this.labelColor = null;
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void showPopup() {
        if (this.popupContents != null) {
            this.popupMenu = this.createWrapperPopupMenu(this.popupContents);
            this.popupMenu.setBorder(BorderFactory.createEmptyBorder());
            this.popupMenu.setPopupSize(this.popupContents.getSize());
            int popupWidth = this.popupContents.getSize().width;
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof GWMainAppFrame && ((GWMainAppFrame)window).isVisibleFolderListTree()) {
                return;
            }
            JComponent c = this.anchorComponent == null ? this : this.anchorComponent;
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            int x = 0;
            if (!ltr) {
                Rectangle b;
                Rectangle rectangle = b = this.anchorComponent != null ? this.anchorComponent.getBounds() : null;
                if (b != null) {
                    x = b.x + b.width - popupWidth;
                }
            }
            Point p = this.anchorComponent == null ? new Point(x, this.getHeight()) : new Point(x, 0);
            this.popupMenu.setPopupSize(popupWidth, this.anchorComponent.getHeight());
            this.popupContents.setBorder(Borders.getEmptyTextComponentBorder(true));
            this.popupMenu.show(c, p.x, p.y);
        }
    }

    private void removeChangeListener() {
        if (this.changeListener != null) {
            MenuSelectionManager.defaultManager().removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
    }

    public void hidePopup() {
        if (this.popupMenu != null) {
            this.removeChangeListener();
            this.popupMenu.setVisible(false);
        }
    }

    protected JPopupWrapper createWrapperPopupMenu(JComponent component) {
        JPopupWrapper popup = new JPopupWrapper(component);
        component.setVisible(true);
        popup.setPopupSize(component.getSize());
        popup.add(component);
        return popup;
    }

    public void updateText() {
        if (this.folder == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.folder.getName());
        builder.append(this.folder.getDisplayCountString());
        if (this.filtered) {
            builder.append(' ');
            builder.append(StringResources.FILTERED);
            builder.append(' ');
        }
        this.setText(builder.toString());
        this.setIcon(ControlsUtils.getImageForFolder(this.folder));
    }

    public void updateDisplayCount(FolderEvent e) {
        this.updateText();
    }

    private void showFolderPopup(Point p) {
        ApplicationFrame appFrame = (ApplicationFrame)SwingUtilities.getWindowAncestor(this);
        if (this.folder == null) {
            logger.debug((Object)"Null pointer error! Current folder is not set");
        }
        MVCController actionList = appFrame.getController();
        this.showFolderPopup(p, this.folder, (ApplicationFrameActionList)actionList);
    }

    private void showFolderPopup(Point p, AbstractFolder f, ApplicationFrameActionList actionList) {
        ReducedFolderPopupMenu popupMenu = FolderPopupMenu.createReducedFolderPopupMenu(f, actionList);
        popupMenu.show(this, p.x, p.y);
    }

    private class HeaderLabelPopupMouseListener
    extends MouseAdapter {
        private HeaderLabelPopupMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                boolean isLocationInExpandControl = false;
                if (e.getSource() instanceof JTree && ((JTree)e.getSource()).getUI() instanceof FoldersTreeUI) {
                    isLocationInExpandControl = ((FoldersTreeUI)((JTree)e.getSource()).getUI()).isLocationInExpandControl();
                }
                if (!isLocationInExpandControl) {
                    HeaderLabel.this.hidePopup();
                }
            }
        }
    }

    private class HeaderLabelMouseListener
    extends MouseAdapter {
        private HeaderLabelMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            HeaderLabel.this.mouseOn = HeaderLabel.this.isEnablePopupFolderList();
            HeaderLabel.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            HeaderLabel.this.mouseOn = false;
            HeaderLabel.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (HeaderLabel.this.isEnablePopupFolderList() && SwingUtilities.isLeftMouseButton(e)) {
                HeaderLabel.this.showPopup();
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                HeaderLabel.this.grabFocus();
                HeaderLabel.this.showFolderPopup(e.getPoint());
                HeaderLabel.this.lineOn = true;
            }
            HeaderLabel.this.refresh();
        }
    }

    private class JPopupWrapper
    extends GWPopupMenu {
        private JComponent contents;
        private boolean wrapperClose = false;

        public JPopupWrapper(JComponent contents) {
            this.contents = contents;
            HeaderLabel.this.changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    MenuElement[] selection = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (selection.length == 0) {
                        if (JPopupWrapper.this.hasContentsDisabledPopup()) {
                            return;
                        }
                        HeaderLabel.this.removeChangeListener();
                        JPopupWrapper.this.setVisible(false);
                    }
                }
            };
            MenuSelectionManager.defaultManager().addChangeListener(HeaderLabel.this.changeListener);
        }

        private boolean hasContentsDisabledPopup() {
            MainGWFoldersTree tree;
            JScrollPane scroll;
            Component c;
            return this.contents instanceof JScrollPane && (c = (scroll = (JScrollPane)this.contents).getViewport().getView()) instanceof MainGWFoldersTree && (tree = (MainGWFoldersTree)c).isPopupContainerCloseDisabled();
        }

        public void menuSelectionChanged(boolean isIncluded) {
            if (!isIncluded) {
                if (this.hasContentsDisabledPopup()) {
                    return;
                }
                super.menuSelectionChanged(!this.wrapperClose);
            } else {
                super.menuSelectionChanged(isIncluded);
            }
        }
    }
}

