/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.inputverification;

import com.appframework.utils.NetUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class UrlInputVerifier
extends InputVerifier {
    public boolean verify(JComponent input) {
        if (!(input instanceof JTextField)) {
            throw new IllegalArgumentException("unsupported component: " + (input == null ? "null" : input.getClass().getName()));
        }
        String text = ((JTextField)input).getText();
        boolean valid = text.length() == 0 ? true : NetUtils.isUrlValid(text);
        return valid;
    }

    public boolean shouldYieldFocus(JComponent input) {
        boolean valid = this.verify(input);
        if (!valid) {
            Toolkit.getDefaultToolkit().beep();
            if (input instanceof JTextField) {
                ((JTextField)input).setText("");
            }
            JOptionPane.showMessageDialog(input, StringResources.ILLEGAL_URL_ADDRESS_MESSAGE, StringResources.GROUPWISE, 2);
        }
        return true;
    }
}

