/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.Tested;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.itemedit.RecurringItemEditPanelModel;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class AppointmentEditPanelModel
extends RecurringItemEditPanelModel {
    private static Logger logger = Logger.getLogger(AppointmentEditPanelModel.class);
    private boolean allDayEvent = false;
    private boolean durationFreezed = false;
    private TimeDuration duration = new TimeDuration(0, 15);
    private int adeDuration = 0;

    public boolean isAllDayEvent() {
        return this.allDayEvent;
    }

    public boolean isDurationFreezed() {
        return this.durationFreezed;
    }

    public void setDurationFreezed(boolean durationFreezed) {
        this.durationFreezed = durationFreezed;
    }

    public void setAllDayEvent(boolean allDayEvent) {
        this.allDayEvent = allDayEvent;
        this.adeDuration = GWCalendarUtils.convertToAllDayEventDuration(this.duration).getDays();
        if (this.adeDuration == 0) {
            ++this.adeDuration;
        }
    }

    public void setDuration(TimeDuration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("duration is null");
        }
        if (duration.equals(this.duration)) {
            return;
        }
        if (this.allDayEvent) {
            this.adeDuration = duration.getDays();
        } else {
            this.duration = (TimeDuration)duration.clone();
        }
    }

    public TimeDuration getDuration() {
        TimeDuration result = this.allDayEvent ? new TimeDuration(0, this.adeDuration * 1440) : (TimeDuration)this.duration.clone();
        return result;
    }

    public void setEndDate(Calendar endDate) {
        if (endDate == null) {
            throw new IllegalArgumentException("endDate is null");
        }
        if (endDate.equals(this.getEndDate())) {
            return;
        }
        logger.debug((Object)("endDate: " + endDate.getTime()));
        endDate = AppointmentEditPanelModel.cloneAndClearTime(endDate);
        Calendar startDate = this.getStartDates()[0];
        if (this.allDayEvent) {
            if (startDate.compareTo(endDate) >= 0) {
                endDate.add(6, -1);
                this.adeDuration = 1;
                if (this.recurring) {
                    this.startDays[0] = endDate;
                } else {
                    this.startDay = endDate;
                }
            } else {
                this.adeDuration = GWCalendarUtils.calculateDifferenceInDays(startDate, endDate);
            }
            assert (this.adeDuration > 0) : "invalid duration value: " + this.adeDuration;
            logger.debug((Object)("ADE, duration: " + this.adeDuration));
        } else {
            boolean crossDayEvent;
            boolean bl = crossDayEvent = this.duration.getEndMinutes() % 1440 < this.duration.getStartMinutes();
            if (startDate.compareTo(endDate) > 0 || crossDayEvent && GWCalendarUtils.calculateDifferenceInDays(endDate, startDate) == 0) {
                logger.debug((Object)"Updating start date and duration");
                if (crossDayEvent) {
                    startDate = (Calendar)endDate.clone();
                    startDate.add(6, -1);
                    this.setDurationEndDay(1);
                } else {
                    startDate = (Calendar)endDate.clone();
                    this.setDurationEndDay(0);
                }
                if (this.recurring) {
                    this.startDays[0] = startDate;
                } else {
                    this.startDay = startDate;
                }
            } else {
                logger.debug((Object)("extending the duration, end date: " + endDate.getTime()));
                int dayShift = GWCalendarUtils.calculateDifferenceInDays(endDate, startDate);
                logger.debug((Object)("dayShift: " + dayShift));
                this.setDurationEndDay(dayShift);
            }
        }
    }

    public Calendar getEndDate() {
        Calendar endDate = this.getStartDates()[0];
        int endDayShift = this.allDayEvent ? this.adeDuration : this.duration.getEndMinutes() / 1440;
        endDate.add(6, endDayShift);
        return endDate;
    }

    public Calendar getEndDateForView() {
        if (this.allDayEvent) {
            Calendar endDate = this.getStartDates()[0];
            endDate.add(6, this.adeDuration - 1);
            return endDate;
        }
        return this.getEndDate();
    }

    protected void processStartDateChanged(Calendar oldValue, Calendar newValue) {
        logger.debug((Object)("startDate changed: " + oldValue.getTime() + " > " + newValue.getTime()));
        if (this.durationFreezed) {
            return;
        }
        if (this.allDayEvent) {
            Calendar endDay = (Calendar)oldValue.clone();
            endDay.add(6, this.adeDuration);
            this.adeDuration = newValue.compareTo(endDay) >= 0 ? 1 : GWCalendarUtils.calculateDifferenceInDays(endDay, newValue);
            logger.debug((Object)("-- ADE, duration: " + this.adeDuration));
        } else {
            Calendar endDay = (Calendar)oldValue.clone();
            endDay.add(6, this.duration.getEndMinutes() / 1440);
            if (newValue.compareTo(endDay) >= 0) {
                int endMinutes = this.duration.getEndMinutes() % 1440;
                if (endMinutes >= this.duration.getStartMinutes()) {
                    this.setDurationEndDay(0);
                } else {
                    this.setDurationEndDay(1);
                }
            } else {
                this.setDurationEndDay(GWCalendarUtils.calculateDifferenceInDays(endDay, newValue));
            }
        }
    }

    private void setDurationEndDay(int endDay) {
        assert (!this.allDayEvent);
        int endDayMinutesFraction = this.duration.getEndMinutes() % 1440;
        this.duration = new TimeDuration(this.duration.getStartMinutes(), endDay * 1440 + endDayMinutesFraction);
        assert (this.duration.getStartMinutes() <= this.duration.getEndMinutes()) : "Illegal duration: " + this.duration;
    }

    @Tested(completely=false)
    public void setData(boolean allDayEvent, Calendar[] startDates, Calendar endDate) {
        if (endDate == null) {
            throw new IllegalArgumentException("endDate = null");
        }
        if (startDates == null) {
            throw new IllegalArgumentException("startDates = null");
        }
        if (startDates.length == 0) {
            throw new IllegalArgumentException("startDates is empty array");
        }
        logger.debug((Object)("allDayEvent: " + allDayEvent));
        logger.debug((Object)("startDates[0]: " + startDates[0].getTime() + ", length: " + startDates.length));
        logger.debug((Object)("endDate: " + endDate.getTime()));
        if (startDates.length == 1) {
            this.setStartDate(startDates[0]);
        } else {
            this.setStartDates(startDates);
        }
        int startMinutes = startDates[0].get(11) * 60 + startDates[0].get(12);
        int endMinutes = GWCalendarUtils.calculateDifferenceInDays(endDate, startDates[0]) * 1440 + endDate.get(11) * 60 + endDate.get(12);
        logger.debug((Object)("-- startMinutes: " + startMinutes));
        logger.debug((Object)("-- endMinutes: " + endMinutes));
        this.setAllDayEvent(allDayEvent);
        this.setDuration(new TimeDuration(startMinutes, endMinutes));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append('[');
        builder.append(this.getToStringContent());
        builder.append(", allDayEvent: ");
        builder.append(this.allDayEvent);
        builder.append(", duration: ");
        builder.append(this.getDuration());
        builder.append(']');
        return builder.toString();
    }

    protected int getDefaultAppointmentDuration() {
        return (Integer)GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings().getAppointmentDefaultLength().getValue();
    }
}

