/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.resources.ImageResources;
import com.novell.gw.account.Account;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.DiscussionEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.storageswitcher.StorageSwitcher;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromComponent
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(FromComponent.class);
    private ItemEditPanel parentPanel;
    private Account account;
    private IDataStore dataStore;
    private JMenuItem itemAccounts;
    private JMenuItem itemProxy;
    private boolean isParentItemPosted;
    private OrientableButton btnFrom;
    private OrientableLabel lbFrom;

    public FromComponent(ItemEditPanel parentPanel) {
        super(new GridLayout(1, 1));
        if (parentPanel == null) {
            throw new IllegalArgumentException("parentPanel is null");
        }
        this.parentPanel = parentPanel;
        String userGuid = ControlsUtils.getUserGuid(this.parentPanel.getController());
        this.dataStore = GWCommandManager.getInstance(userGuid).getCurrentDataStore();
        this.account = this.dataStore.getGroupWiseAccount();
        this.parentPanel.setFrom(this.dataStore.getUserFullName());
    }

    private MVCController getController() {
        return this.parentPanel.getController();
    }

    private void buildButton() {
        if (this.btnFrom == null) {
            this.btnFrom = new OrientableButton("<html>" + StringResources.FROM_C + "&nbsp;</html>", ImageResources.ARROW_DOWN);
            ActionList actionList = this.parentPanel.getController().getActionList();
            AppAction actionAccounts = actionList.getAction(ActionKey.ACCOUNT_OPTIONS);
            this.itemAccounts = actionAccounts.getMenuItem();
            this.itemAccounts.setIcon(actionAccounts.getIcon());
            this.itemAccounts.setText(StringResources.ACCOUNTS_D);
            AppAction actionProxy = actionList.getAction(ActionKey.PROXY);
            this.itemProxy = actionProxy.getMenuItem();
            this.itemProxy.setIcon(actionProxy.getIcon());
            this.btnFrom.setVerticalTextPosition(0);
            this.btnFrom.setHorizontalTextPosition(10);
            this.btnFrom.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FromComponent.this.performAction();
                }
            });
            this.add(this.btnFrom);
        }
    }

    private void buildLabel() {
        if (this.lbFrom == null) {
            this.lbFrom = new OrientableLabel(StringResources.FROM_C);
            this.add(this.lbFrom);
        }
    }

    public void init() {
        if (this.needAddImapOrPop3Accounts() || this.needAddProxyAccounts()) {
            this.buildButton();
        } else {
            this.buildLabel();
        }
    }

    Account getAccount() {
        return this.account;
    }

    public void setParentItemPosted(boolean isParentItemPosted) {
        this.isParentItemPosted = isParentItemPosted;
    }

    void setAccount(Account account) {
        if (account != null) {
            this.account = account;
            this.parentPanel.setFrom(this.account.getFromText());
        }
    }

    public IDataStore getDataStore() {
        return this.dataStore;
    }

    private boolean needAddImapOrPop3Accounts() {
        boolean isReply = ComposeMode.REPLY.equals((Object)this.parentPanel.getComposeMode());
        String userGuid = ControlsUtils.getUserGuid(this.parentPanel.getController());
        boolean isDiscussion = this.parentPanel instanceof DiscussionEditPanel;
        return GWCommandManager.getInstance(userGuid).canUsePopAndImapAccounts() && (!isReply && !this.parentPanel.isPostedMode() || isReply && !this.isParentItemPosted || isDiscussion);
    }

    private boolean needAddProxyAccounts() {
        boolean isDiscussion = this.parentPanel instanceof DiscussionEditPanel;
        boolean isReply = ComposeMode.REPLY.equals((Object)this.parentPanel.getComposeMode());
        return !this.parentPanel.isPostedMode() && (!isReply || this.isParentItemPosted) && !isDiscussion;
    }

    private JPopupMenu getPopupMenu() {
        GWPopupMenu popup = null;
        if (this.needAddImapOrPop3Accounts()) {
            popup = new GWPopupMenu();
            popup.add(this.itemAccounts);
            List<JMenuItem> accounts = this.getUserAccountsMenuItems();
            for (JMenuItem item : accounts) {
                popup.add(item);
            }
        }
        if (this.needAddProxyAccounts()) {
            if (popup == null) {
                popup = new GWPopupMenu();
            }
            popup.add(this.itemProxy);
            Account userAccount = EngineCommandManager.getUserGroupWiseAccount();
            AccountUserAction action = new AccountUserAction(userAccount);
            JMenuItem menuItem = MenuItemFactory.createCkeckBoxMenuItem(action);
            menuItem.setIcon(com.novell.gw.jclient.application.resources.ImageResources.ICON_ADDRESS_BOOK_USER);
            menuItem.setBorder(StorageSwitcher.SHIFT_BORDER);
            menuItem.setText(userAccount.getFromText());
            menuItem.setSelected(!this.isProxyMode());
            popup.add(menuItem);
            List<JMenuItem> proxyAccounts = this.getProxyMenuItems();
            for (JMenuItem item : proxyAccounts) {
                popup.add(item);
            }
        }
        return popup;
    }

    private void performAction() {
        ControlsUtils.getWindowForComponent(this).getBounds();
        Rectangle bounds = this.getBounds();
        JPopupMenu popup = this.getPopupMenu();
        if (popup != null) {
            Dimension ps = popup.getPreferredSize();
            popup.show(this, bounds.width - ps.width, bounds.height);
        }
    }

    private boolean isProxyMode() {
        return GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).isProxyDataStore();
    }

    private List<JMenuItem> getUserAccountsMenuItems() {
        Account[] accounts;
        boolean proxyMode = this.isProxyMode();
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        for (Account account : accounts = EngineCommandManager.getMailAccounts()) {
            AccountUserAction action = new AccountUserAction(account);
            JMenuItem item = MenuItemFactory.createCkeckBoxMenuItem(action);
            item.setIcon(com.novell.gw.jclient.application.resources.ImageResources.FLD_WORLD_NEW);
            item.setBorder(StorageSwitcher.SHIFT_BORDER);
            if (!proxyMode) {
                item.setSelected(account.getEmailAddress().equals(this.account.getEmailAddress()));
            }
            list.add(item);
        }
        return list;
    }

    private List<JMenuItem> getProxyMenuItems() {
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        ProxyHistoryList proxyUserItems = EngineCommandManager.getProxyHistoryList();
        int size = proxyUserItems.size();
        for (int i = 0; i < size; ++i) {
            ProxyHistoryEntry entry = proxyUserItems.get(i);
            String entryName = entry.getDisplayName();
            String entryGuid = entry.getGuid();
            if (entryGuid.equals(EngineCommandManager.getUserInfo().getGuid())) continue;
            ProxyUserAction entryAction = new ProxyUserAction(entry);
            JMenuItem item = MenuItemFactory.createCkeckBoxMenuItem(entryAction);
            item.setIcon(com.novell.gw.jclient.application.resources.ImageResources.ICON_ADDRESS_BOOK_USER);
            item.setBorder(StorageSwitcher.SHIFT_BORDER);
            String userGuid = ControlsUtils.getUserGuid(this.parentPanel.getController());
            String currentName = GWCommandManager.getInstance(userGuid).getCurrentDataStore().getUserFields().getDisplayName();
            item.setSelected(entryName.equals(currentName));
            list.add(item);
        }
        return list;
    }

    private class AccountUserAction
    extends AbstractAction {
        private Account account;

        public AccountUserAction(Account account) {
            super(account.getName());
            this.account = account;
        }

        public void actionPerformed(ActionEvent e) {
            FromComponent.this.account = this.account;
            FromComponent.this.parentPanel.setSendingAccount(this.account);
            FromComponent.this.parentPanel.setFrom(this.account.getFromText());
            logger.debug((Object)("account set to " + this.account.getName() + ", from set to " + this.account.getFromText()));
            if (!FromComponent.this.isProxyMode()) {
                return;
            }
            logger.debug((Object)"switching DataStore");
            String userGuid = GWCommandManager.getInstance(ControlsUtils.getUserGuid(FromComponent.this.getController())).switchToUserMode();
            Command command = new Command(800, new StorageMode(0, userGuid));
            FromComponent.this.getController().processCommand(command);
            FromComponent.this.getController().getActionList().performAction(ActionKey.REFRESH);
        }
    }

    private class ProxyUserAction
    extends AbstractAction {
        private ProxyHistoryEntry entry;

        public ProxyUserAction(ProxyHistoryEntry theEntry) {
            super(theEntry.getDisplayName());
            this.entry = theEntry;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                IDataStore dataStore = APIFactory.getEngine().getProxyDataStore(this.entry);
                String strID = dataStore.getUserId();
                logger.debug((Object)("DataStore userid is: " + strID));
                Account account = dataStore.getGroupWiseAccount();
                strID = account.getUserId();
                logger.debug((Object)("Account userid is: " + strID));
                strID = account.getEmailAddress();
                logger.debug((Object)("Account email is: " + strID));
                FromComponent.this.account = account;
                FromComponent.this.dataStore = dataStore;
                FromComponent.this.parentPanel.setSendingAccount(account);
                FromComponent.this.parentPanel.setFrom(dataStore.getUserFullName());
                logger.debug((Object)("account set to " + account.getName() + ", from set to " + dataStore.getUserFullName() + ", proxy history entry name: " + this.entry.getDisplayName()));
                logger.debug((Object)"switching DataStore");
                String oldUserGuid = ControlsUtils.getUserGuid(FromComponent.this.getController());
                String userGuid = GWCommandManager.getInstance(oldUserGuid).performProxy(this.entry);
                FromComponent.this.getController().processCommand(new Command(750, userGuid));
                FromComponent.this.getController().getActionList().performAction(ActionKey.REFRESH);
            }
            catch (EngineException ex) {
                JOptionPane.showMessageDialog(FromComponent.this, EngineException.getErrorString((int)ex.getErrorCode()), StringResources.NOVELL_GROUPWISE, 2);
                if (ex.getErrorCode() == 53540) {
                    return;
                }
                logger.error((Object)ex);
                logger.debug((Object)ex, (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }
}

