/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import azcheck.ui.JSpellDialog;
import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.HTMLTextEditor;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.MultipleFieldsDirtyStateManager;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.LocalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.Day;
import com.appframework.utils.OS;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.ComposeAttachmentView;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListChangeListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.FromComponent;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelModel;
import com.novell.gw.jclient.application.controls.itemedit.ItemViewTabbedPane;
import com.novell.gw.jclient.application.controls.itemview.CheckListViewPanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.textcomponent.EditableTextComponent;
import com.novell.gw.jclient.application.frames.options.compose.send.ComposeSendOptionsPanel;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageBodyFormat;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.sendoptions.AbstractSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemEditPanel<T extends ItemEditPanelModel>
extends OrientablePanel
implements MVCView<ItemEditPanelController, AbstractItem> {
    private static Logger logger = Logger.getLogger(ItemEditPanel.class);
    protected static final int DEVIDER_SIZE = 4;
    public static final String FROM = "From";
    public static final String TO = "To";
    public static final String CC = "CC";
    public static final String BC = "BC";
    public static final String LOCATION = "Location";
    public static final String START_DATE = "Start date";
    public static final String CALLER = "Caller";
    public static final String COMPANY = "Company";
    public static final String PHONE = "Phone";
    public static final String DUE_ON = "Due on";
    public static final String TIME = "Time";
    public static final String SUBJECT = "Subject";
    public static final String PRIORITY = "Priority";
    public static final String DURATION = "Duration";
    public static final String MESSAGE = "Message";
    public static final String TELEPHONED = "Telephoned";
    public static final String WILL_CALL_AGAIN = "Will call again";
    public static final String WANT_TO_SEE_YOU = "Want to see you";
    public static final String URGENT = "Urgent";
    public static final String PLEASE_CALL = "Please call";
    public static final String RETURN_YOUR_CALL = "Return your call";
    public static final String COME_TO_SEE_YOU = "Come to see you";
    private ItemEditPanelController controller;
    protected AbstractItem newItem = null;
    protected JPanel contentPanel;
    protected FromComponent compFrom;
    protected JLabel lbCC;
    protected JLabel lbTo;
    protected JLabel lbBC;
    protected JLabel lbStartDate;
    protected JLabel lbDueOn;
    protected JLabel lbSubject;
    protected JTextField tfFrom;
    protected ContactSearchComboField tfCC;
    protected ContactSearchComboField tfTo;
    protected ContactSearchComboField tfBC;
    protected EditableTextComponent etcTo;
    protected EditableTextComponent etcCC;
    protected EditableTextComponent etcBC;
    protected JTextField tfSubject;
    protected JPanel addressPane;
    protected HTMLTextEditor messageEditor;
    private ComposeSendOptionsPanel sendOptionsPanel;
    private JTabbedPane tpMessageOptions;
    protected ItemComposerTraversalPolicy focusTraversalPolicy;
    protected static final int iTop = 10;
    protected static final int iLeft = 10;
    protected static final int iBottom = 10;
    protected static final int iRight = 10;
    protected static final int iSpace = 10;
    protected static final int SPACE_BETWEEN_ROWS = 8;
    protected MultipleFieldsDirtyStateManager dirtyStateManager;
    protected ComposeAttachmentView attachmentList;
    protected boolean postedMode;
    protected JSplitPane messageSplit = new JSplitPane(0);
    protected boolean isSendingFromAddressBook;
    protected ComposeMode composeMode = ComposeMode.NEW;
    private CheckListViewPanel checkListViewPanel;
    private boolean itemInChecklist = false;
    protected T model = this.createModel();
    protected boolean syncingWithModel = false;
    private final boolean isModify;

    public ItemEditPanel(MVCController theParentController, String thePropertyID, ComposeMode composeMode) {
        this(theParentController, thePropertyID, composeMode, false);
    }

    protected ItemEditPanel(MVCController parentController, String thePropertyID, ComposeMode composeMode, boolean isModify) {
        super(new BorderLayout());
        this.isModify = isModify;
        if (composeMode == null) {
            throw new IllegalArgumentException("composeMode is null");
        }
        this.composeMode = composeMode;
        this.messageSplit.setBorder(BorderFactory.createEmptyBorder());
        this.messageSplit.setOneTouchExpandable(false);
        this.messageSplit.setResizeWeight(1.0);
        this.messageSplit.setDividerSize(4);
        this.messageSplit.addPropertyChangeListener(new DividerPositionListener(thePropertyID, this.messageSplit));
        this.setController(this.createController(parentController));
        this.dirtyStateManager = new MultipleFieldsDirtyStateManager(this.controller);
        this.tfTo = new ContactSearchComboField(this.controller, RecipientCopyType.getTo());
        this.tfTo.setName("ItemEditPanel_tfTo");
        this.tfTo.addRecipientListChangeListener(new RecipientListChangeListener(){

            @Override
            public void recipientListChanged(List<? extends IRecipient> recipientList) {
                ApplicationFrame frame = (ApplicationFrame)SwingUtilities.getWindowAncestor(ItemEditPanel.this);
                if (frame != null) {
                    String title = ContactUtils.toString(recipientList);
                    frame.setTitle(frame.getDefaultTitle() + " " + title);
                }
            }
        });
        this.tfCC = new ContactSearchComboField(this.controller, RecipientCopyType.getCc());
        this.tfCC.setName("ItemEditPanel_tfCC");
        this.tfBC = new ContactSearchComboField(this.controller, RecipientCopyType.getBc());
        this.tfBC.setName("ItemEditPanel_tfBC");
        this.tfSubject = new GWTextField();
        this.tfSubject.setName("ItemEditPanel_tfSubject");
        this.tfSubject.getDocument().addUndoableEditListener(new UndoableEditListener(){
            UndoManager undoManager = new UndoManager();

            public void undoableEditHappened(UndoableEditEvent e) {
                this.undoManager.addEdit(e.getEdit());
                ItemEditPanel.this.getController().processCommand(new GlobalCommand(1910, this.undoManager));
            }
        });
        ApplicationOptions appOptions = ApplicationOptions.getInstance();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        boolean spellCheck = (Boolean)dataStoreSettings.getCheckSpellingAsYouType().getValue();
        if (spellCheck) {
            try {
                JSpellDialog.enableAutoCheck((JTextComponent)this.tfSubject, (String)OS.getDictLanguage());
            }
            catch (Exception e) {
                try {
                    JSpellDialog.enableAutoCheck((JTextComponent)this.tfSubject, (String)String.format("%s-%s", Locale.US.getLanguage(), Locale.US.getCountry()));
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)e1, (Throwable)e1);
                }
            }
        }
        this.tfFrom = new GWTextField();
        this.etcTo = new EditableTextComponent(this.tfTo, this.dirtyStateManager);
        this.etcCC = new EditableTextComponent(this.tfCC, this.dirtyStateManager);
        this.etcBC = new EditableTextComponent(this.tfBC, this.dirtyStateManager);
        this.etcTo.setPreferredSize(new Dimension(200, this.etcTo.getPreferredSize().height));
        this.etcCC.setPreferredSize(new Dimension(200, this.etcCC.getPreferredSize().height));
        this.etcBC.setPreferredSize(new Dimension(200, this.etcBC.getPreferredSize().height));
        this.build();
        int mode = HTMLUtils.isDefaultComposeHTML() ? 1 : 3;
        this.setHTMLEditMode(mode);
        this.setItemCompositionTypeHTML(HTMLUtils.isDefaultComposeHTML());
        int pos = appOptions.getInteger(thePropertyID, -1);
        if (pos <= 0) {
            this.messageSplit.resetToPreferredSizes();
        } else {
            this.messageSplit.setDividerLocation(pos);
        }
        AppAction action = this.getController().getActionList().getAction(ActionKey.SAVE_DRAFT);
        action.setEnabled(true);
        this.initListeners();
    }

    protected abstract ItemEditPanelController createController(MVCController var1);

    protected T createModel() {
        return null;
    }

    public ComposeMode getComposeMode() {
        return this.composeMode;
    }

    public void setParentItemPosted(boolean isParentItemPosted) {
        this.compFrom.setParentItemPosted(isParentItemPosted);
    }

    public boolean isPostedMode() {
        return this.postedMode;
    }

    public void hideTFPopups() {
        this.tfTo.hidePopup();
        this.tfCC.hidePopup();
        this.tfBC.hidePopup();
    }

    public HTMLTextEditor getTaMessage() {
        return this.messageEditor;
    }

    public HTMLTextPane getMessageEditor() {
        return this.messageEditor.getHTMLTextPane();
    }

    protected void hideComboFieldPopups() {
        this.tfTo.hidePopup();
        this.tfBC.hidePopup();
        this.tfCC.hidePopup();
    }

    protected void build() {
        this.setPreferredSize(new Dimension(580, 480));
        this.tpMessageOptions = new ItemViewTabbedPane(this.controller.getActionList());
        this.tpMessageOptions.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ItemEditPanel.this.hideComboFieldPopups();
            }
        });
        this.add((Component)this.tpMessageOptions, "Center");
        this.contentPanel = new OrientablePanel();
        this.tpMessageOptions.addTab(StringResources.MESSAGE, this.contentPanel);
        this.messageEditor = new HTMLTextEditor(-1, this.dirtyStateManager);
        this.messageEditor.showHeaderPanel(true);
        this.messageEditor.setEnableShortCuts(true);
        this.messageEditor.setPreferredSize(new Dimension(1, 20));
        this.messageEditor.setDragEnabled(true);
        this.messageEditor.setName(MESSAGE);
        this.sendOptionsPanel = new ComposeSendOptionsPanel(this.controller);
        this.tpMessageOptions.addTab(StringResources.SEND_OPTIONS, new OrientableScrollPane(this.sendOptionsPanel));
        this.attachmentList = new ComposeAttachmentView(this.controller, this.dirtyStateManager);
        this.attachmentList.setPreferredSize(new Dimension(this.attachmentList.getPreferredSize().width, 80));
    }

    protected void initListeners() {
        Level level = LevelManager.getInstance().getGlobalLevel();
        AppEventListener listener = new TOGGLE_BOLD_listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 1780, listener);
        this.controller.addListenerDescriptor(descriptor);
        listener = new TOGGLE_ITALIC_listener();
        descriptor = new AppEventListenerDescriptor(level, 1790, listener);
        this.controller.addListenerDescriptor(descriptor);
        listener = new TOGGLE_NORMAL_listener();
        descriptor = new AppEventListenerDescriptor(level, 1810, listener);
        this.controller.addListenerDescriptor(descriptor);
        listener = new TOGGLE_UNDERLINE_listener();
        descriptor = new AppEventListenerDescriptor(level, 1800, listener);
        this.controller.addListenerDescriptor(descriptor);
    }

    public void switchToPostedMode() {
        this.tfFrom.setEditable(!this.isModify);
        this.etcTo.setEnabled(false);
        this.tfTo.setEditable(false);
        this.etcCC.setEnabled(false);
        this.tfCC.setEditable(false);
        this.etcBC.setEnabled(false);
        this.tfBC.setEditable(false);
        this.addressPane.remove(this.etcTo);
        this.addressPane.remove(this.etcBC);
        this.addressPane.remove(this.etcCC);
        this.addressPane.remove(this.lbTo);
        if (this.lbBC != null) {
            this.addressPane.remove(this.lbBC);
        }
        if (this.lbCC != null) {
            this.addressPane.remove(this.lbCC);
        }
        this.postedMode = true;
        this.focusTraversalPolicy.setPostedMode(true);
    }

    public void setSendingFromAddressBook(boolean sendingFromAddressBook) {
        this.isSendingFromAddressBook = sendingFromAddressBook;
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.focusTraversalPolicy;
    }

    public void setRecipients(AbstractItem newItem) {
        this.tfCC.setRecipients(newItem.getCcRecipients());
        this.tfTo.setRecipients(newItem.getToRecipients());
        this.tfBC.setRecipients(newItem.getBcRecipients());
    }

    public boolean setHTMLEditMode(int htmlMode) {
        logger.debug((Object)("theHTMLMode: " + htmlMode + "(current: " + this.messageEditor.getMode() + ')'));
        if (this.messageEditor.getMode() == htmlMode) {
            return false;
        }
        if (htmlMode == 1) {
            this.messageEditor.showHeaderPanel(true);
            this.messageEditor.setEnableShortCuts(true);
            this.messageEditor.setHTMLButtonsEnabled(true);
        } else {
            this.messageEditor.setHTMLButtonsEnabled(false);
        }
        this.setItemCompositionTypeHTML(htmlMode);
        this.repaint();
        boolean readTextFromApi = (this.composeMode == ComposeMode.REPLY || this.composeMode == ComposeMode.FORWARD) && !this.messageEditor.isTextChangedByUser();
        this.messageEditor.setMode(htmlMode, readTextFromApi);
        MVCController frameActionList = ControlsUtils.getFrameForController(this.controller).getController();
        ((ActionList)frameActionList).getAction(htmlMode == 1 ? ActionKey.HTML_TEXT : ActionKey.PLAIN_TEXT).setSelected(true);
        if (readTextFromApi && this.newItem != null) {
            boolean html = this.messageEditor.getMode() == 1;
            this.messageEditor.setStyledText(GWEngineUtils.validateSuggestedBody(this.newItem.getNativeItem().getSuggestedBody(html)));
        }
        return true;
    }

    private void setItemCompositionTypeHTML(boolean b) {
        if (this.newItem != null) {
            this.newItem.setHTMLMessageComposition(b);
            this.newItem.getMessage().setLastTextFormat(b ? MessageBodyFormat.HTML : MessageBodyFormat.RTF);
        }
    }

    private void setItemCompositionTypeHTML(int theMode) {
        this.setItemCompositionTypeHTML(theMode == 1);
    }

    public AbstractItem getInitialItem() {
        return this.newItem;
    }

    public AbstractItem getGWItemComposition() {
        String realName;
        ComposeItemSendOptions options;
        logger.debug((Object)"getGWItemComposition");
        this.newItem.setAttachments(this.attachmentList.getAttachmentsCompositions());
        if (this.sendOptionsPanel != null && (options = this.sendOptionsPanel.getOptions((IMessage)this.newItem.getNativeItem())) != null) {
            this.newItem.setComposeItemSendOptions(options);
        }
        if (this.newItem.getNativeItem().getSendingAccount() == null) {
            this.newItem.getNativeItem().setSendingAccount(this.compFrom.getAccount());
        }
        String name = this.tfFrom.getText();
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        if (this.compFrom.getAccount().getType() == 3 && !(realName = GWCommandManager.getInstance(ControlsUtils.getUserGuid(this)).getCurrentUserInfo().getFromText()).equals(name)) {
            builder.append(String.format(" (%s)", realName));
        }
        this.newItem.getNativeItem().setFromText(builder.toString());
        this.newItem.setRecipients(this.getRecipientsList());
        if (this.messageEditor.getMode() == 1) {
            this.newItem.getMessage().setHtmlText(this.messageEditor.getStyledText());
        } else {
            this.newItem.getMessage().setRtfText(this.messageEditor.getStyledText());
        }
        return this.newItem;
    }

    public List<IRecipient> getRecipientsList() {
        ArrayList<IRecipient> result = new ArrayList<IRecipient>();
        result.addAll(this.tfTo.getRecipients());
        result.addAll(this.tfCC.getRecipients());
        result.addAll(this.tfBC.getRecipients());
        return result;
    }

    public void setGWItemComposition(AbstractItem theNewItem) {
        boolean isHTMLMode;
        this.newItem = theNewItem;
        this.getController().processCommand(new Command(20, new SelectedItemsInfoImpl(null, theNewItem)));
        if (this.compFrom != null) {
            Account sendingAccount = theNewItem.getNativeItem().getSendingAccount();
            logger.debug((Object)("setting sendingAccount: " + sendingAccount));
            this.compFrom.setAccount(sendingAccount);
            this.compFrom.init();
        }
        this.setHTMLEditMode((isHTMLMode = MessageUtils.isItemComposeModeHtml(theNewItem)) ? 1 : 3);
        this.attachmentList.setItem(this.newItem);
        this.attachmentList.setAttachmentsCompositions(this.newItem.getAttachments());
        this.setItemCompositionTypeHTML(this.messageEditor.getMode());
        if (this.messageEditor.getMode() == 1) {
            String text = this.newItem.getMessage().getHtmlText();
            this.messageEditor.setStyledText(text);
        } else if (this.newItem.getMessage().isRtfMessage()) {
            this.messageEditor.setStyledText(this.newItem.getMessage().getRtfText());
        }
        if (this.newItem.isInChecklist()) {
            this.itemInChecklist = true;
            this.checkListViewPanel = new CheckListViewPanel(this.getController());
            this.checkListViewPanel.setItem(this.newItem);
            this.tpMessageOptions.add(this.checkListViewPanel.getName(), this.checkListViewPanel);
        }
        HTMLTextPane htmlTextPane = (HTMLTextPane)this.messageEditor.getComponent();
        int length = 0;
        if (ItemEditPanel.isCursorBottom(htmlTextPane.getMode())) {
            Document document = htmlTextPane.getDocument();
            length = document.getLength();
            if (OS.isMacOS()) {
                --length;
            }
        }
        htmlTextPane.setCaretPosition(length);
        LocalCommand command = new LocalCommand(2010, isHTMLMode, this.getController().getParentController());
        command.setAttribute((Object)AttributeKey.SOURCE, SwingUtilities.getWindowAncestor(this));
        this.getController().processCommand(command);
        command = new LocalCommand(2020, this.newItem, this.getController().getParentController());
        command.setAttribute((Object)AttributeKey.SOURCE, SwingUtilities.getWindowAncestor(this));
        this.getController().processCommand(command);
    }

    public void setSendOptions(AbstractSendOptions theComposeItemSendOptions) {
        if (this.sendOptionsPanel != null) {
            try {
                this.sendOptionsPanel.setOptions(theComposeItemSendOptions);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setFrom(String theFrom) {
        if (this.tfFrom != null) {
            this.tfFrom.setText(theFrom);
        }
    }

    @Override
    public void setController(ItemEditPanelController theController) {
        this.controller = theController;
    }

    @Override
    public ItemEditPanelController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(AbstractItem theModel) {
        this.setGWItemComposition(theModel);
    }

    private GWAttachment createFileAttachment(File file) {
        String composeID = this.newItem.getID();
        GWAttachment attachmentComposition = new GWAttachment(composeID, file.getName());
        attachmentComposition.setLocalFile(true);
        attachmentComposition.setLocalFilePath(file.getAbsolutePath());
        attachmentComposition.setGwItem(this.newItem);
        attachmentComposition.setSize(file.length());
        attachmentComposition.setFileName(file.getName());
        return attachmentComposition;
    }

    protected EditableTextComponent createEditableTextComponent(JComponent component) {
        return new EditableTextComponent(component, this.dirtyStateManager);
    }

    @Override
    public AbstractItem getMVCModel() {
        return this.getGWItemComposition();
    }

    public JComponent getComponentForFocus() {
        if (ComposeMode.REPLY == this.composeMode) {
            return this.messageEditor.getComponent();
        }
        if (this.postedMode || this.isSendingFromAddressBook) {
            return this.tfSubject;
        }
        return this.tfTo;
    }

    private static boolean isCursorBottom(int composeMode) {
        AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
        switch (composeMode) {
            case 1: {
                AccountSettings.HTMLReplyFormat htmlReplyFormat = accountSettings.getHTMLReplyFormat();
                if (htmlReplyFormat.getReplyType() != 1 || !htmlReplyFormat.isReplyInsertAtBottom()) break;
                return true;
            }
            case 3: {
                AccountSettings.PlainTextReplyFormat plainTextReplyFormat = accountSettings.getPlainTextReplyFormat();
                if (plainTextReplyFormat.getReplyType() == 0 || !plainTextReplyFormat.isReplyInsertAtBottom()) break;
                return true;
            }
        }
        return false;
    }

    public void setTo(List<IRecipient> theRecipients) {
        if (this.tfTo != null) {
            this.tfTo.setRecipients(theRecipients);
        }
    }

    public void setCC(List<IRecipient> theRecipients) {
        if (this.tfCC != null) {
            this.tfCC.setRecipients(theRecipients);
        }
    }

    public void setBC(List<IRecipient> theRecipients) {
        if (this.tfBC != null) {
            this.tfBC.setRecipients(theRecipients);
        }
    }

    public JTextField getSubject() {
        return this.tfSubject;
    }

    public void setSubject(String theSubject) {
        if (this.tfSubject != null) {
            this.tfSubject.setText(theSubject);
        }
    }

    public void setMessage(String theBody) {
        if (this.messageEditor != null) {
            this.messageEditor.setPlainText(theBody);
        }
    }

    public void clearDirtyState() {
        JRootPane rootPane;
        this.dirtyStateManager.clearDirtyState();
        if (OS.isMacOS() && (rootPane = this.getRootPane()) != null) {
            rootPane.putClientProperty("windowModified", Boolean.FALSE);
        }
    }

    public boolean isDirty() {
        return this.dirtyStateManager.isDirty();
    }

    public static JFrame getParentFrame(Component component) {
        Container c = component.getParent();
        if (c instanceof JFrame) {
            return (JFrame)c;
        }
        return ItemEditPanel.getParentFrame(c);
    }

    public ComposeAttachmentView getAttachmentView() {
        return this.attachmentList;
    }

    public boolean isItemInChecklist() {
        return this.itemInChecklist;
    }

    public CheckListViewPanel getCheckListViewPanel() {
        return this.checkListViewPanel;
    }

    public IDataStore getFromDataStore() {
        return this.compFrom.getDataStore();
    }

    void setSendingAccount(Account account) {
        this.newItem.getNativeItem().setSendingAccount(account);
    }

    public void addFileAttachments(List<File> files) {
        ArrayList<GWAttachment> attachments = new ArrayList<GWAttachment>();
        for (File file : files) {
            GWAttachment attachmentComposition = this.createFileAttachment(file);
            attachments.add(attachmentComposition);
        }
        this.attachmentList.addFileAttachments(attachments);
    }

    protected void syncWithModel() {
        if (this.syncingWithModel) {
            return;
        }
        this.syncingWithModel = true;
        this.syncComponentsWithModel();
        this.syncPanelWithModel();
        this.repaint();
        this.syncingWithModel = false;
    }

    protected void syncComponentsWithModel() {
    }

    protected void syncPanelWithModel() {
    }

    protected void handle_START_DAYS_CHANGED(Day[] startDays) {
    }

    protected boolean handle_ACTION_SET_ALL_DAY_EVENT(boolean isSelected) {
        return false;
    }

    public void handle_ACTION_ATTACH_FILE_PERFORMED(AppEvent event) {
        this.addFileAttachments((List)event.getData());
    }

    private class TOGGLE_UNDERLINE_listener
    extends AppEventListener {
        private TOGGLE_UNDERLINE_listener() {
        }

        public void handle(AppEvent theEvent) {
            ItemEditPanel.this.messageEditor.toggleUnderline();
        }
    }

    private class TOGGLE_NORMAL_listener
    extends AppEventListener {
        private TOGGLE_NORMAL_listener() {
        }

        public void handle(AppEvent theEvent) {
            ItemEditPanel.this.messageEditor.makeNormal();
        }
    }

    private class TOGGLE_ITALIC_listener
    extends AppEventListener {
        private TOGGLE_ITALIC_listener() {
        }

        public void handle(AppEvent theEvent) {
            ItemEditPanel.this.messageEditor.toggleItalic();
        }
    }

    private class TOGGLE_BOLD_listener
    extends AppEventListener {
        private TOGGLE_BOLD_listener() {
        }

        public void handle(AppEvent theEvent) {
            ItemEditPanel.this.messageEditor.toggleBold();
        }
    }

    protected static abstract class ItemComposerTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        protected boolean isPostedCompose;

        protected ItemComposerTraversalPolicy() {
        }

        public void setPostedMode(boolean b) {
            this.isPostedCompose = b;
        }
    }
}

