/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.mvc.MVCController;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.DateVerifier;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationDayDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationDayFormat;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.ExtendedDateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.FromComponent;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.itemedit.RecurringItemEditPanel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.textcomponent.EditableTextComponent;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.FocusManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class TaskEditPanel
extends RecurringItemEditPanel {
    private static Logger logger = Logger.getLogger(TaskEditPanel.class);
    private DurationTextField tfDuration;
    private SingleDateSelector dsEndDate;
    private OrientablePanel plnDueOnIn;
    private EditableTextComponent editableEndDate;
    private EditableTextComponent editableDuration;
    protected JLabel lbPriority;
    protected GWTextField tfPriority;
    private static final String DUE_ON_VIEW = "DUE_ON_VIEW";
    private static final String DUE_IN_VIEW = "DUE_IN_VIEW";
    private boolean isPosted;
    private StartEndDateListener startEndDateSynchronizingListener;

    public TaskEditPanel(MVCController theParentController, boolean isPosted, ComposeMode composeMode, boolean isModify) {
        super(theParentController, "ATTACHLIST_SPLITPOS_TASK_EDIT", composeMode, isModify);
        this.isPosted = isPosted;
        this.init();
    }

    protected ItemEditPanelController createController(MVCController parentController) {
        return new ItemEditPanelController<TaskEditPanel>(this, parentController);
    }

    public AbstractItem getGWItemComposition() {
        if (((ExtendedDateTextField)this.rsStartDate.getTextComponent()).isFocusOwner()) {
            ((ExtendedDateTextField)this.rsStartDate.getTextComponent()).commit();
        }
        TaskItem task = (TaskItem)this.newItem;
        task.setTaskPriority(this.tfPriority.getText());
        task.setSubject(this.tfSubject.getText());
        Date[] dates = GWCalendarUtils.CalendarToDate(this.rsStartDate.getDates());
        if (dates.length > 1) {
            if (this.tfDuration.isFocusOwner()) {
                this.tfDuration.commit();
            }
            TimeDuration duration = this.tfDuration.getDuration();
            task.setStartDates(dates);
            task.setEndDate(dates[0]);
            task.changeTimeEnd(duration.getEndMinutes());
            logger.debug((Object)("task.getStartDate: " + task.getStartDate()));
            logger.debug((Object)("task.getEndDate(): " + task.getEndDate()));
        } else {
            if (((Component)this.dsEndDate.getTextComponent()).isFocusOwner()) {
                ((DateTextField)this.dsEndDate.getTextComponent()).commit();
            }
            Calendar today = GWCalendarUtils.getToday();
            GWCalendarUtils.clearTime(today);
            if (dates[0].getTime() >= today.getTimeInMillis()) {
                task.setStartDates(dates);
            }
            if (this.dsEndDate.getDate().getTimeInMillis() < task.getStartDate().getTime()) {
                task.setEndDate(task.getStartDate());
            } else {
                task.setEndDate(this.dsEndDate.getDate().getTime());
            }
        }
        return super.getGWItemComposition();
    }

    public void setGWItemComposition(AbstractItem theNewItem) {
        BasicDateVerifier dateVerifier;
        this.rsStartDate.removeDateChangeListener(this.startEndDateSynchronizingListener);
        this.rsStartDate.removeRecuringDateChangeListener(this);
        this.dsEndDate.removeDateChangeListener(this.startEndDateSynchronizingListener);
        super.setGWItemComposition(theNewItem);
        TaskItem task = (TaskItem)this.newItem;
        this.tfCC.setRecipients(task.getCcRecipients());
        this.tfTo.setRecipients(task.getToRecipients());
        this.tfBC.setRecipients(task.getBcRecipients());
        Calendar endDate = GWCalendarUtils.getToday();
        endDate.setTime(task.getEndDate());
        int endMinutes = GWCalendarUtils.getMinutes(endDate);
        Calendar[] startDates = GWCalendarUtils.DateToCalendar(task.getStartDates());
        GWCalendarUtils.clearTime(endDate);
        for (Calendar dateToFix : startDates) {
            GWCalendarUtils.clearTime(dateToFix);
        }
        this.dsEndDate.setDate(endDate);
        logger.debug((Object)("end date set: " + DateAndTimeFormattingUtils.calendarToLogString(endDate)));
        if (ComposeMode.RESEND.equals((Object)this.composeMode)) {
            ResendStartDateVerifier resendVerifier = new ResendStartDateVerifier(startDates[0]);
            dateVerifier = resendVerifier;
            this.rsStartDate.addDateChangeListener(resendVerifier);
        } else {
            dateVerifier = new BasicDateVerifier();
        }
        this.rsStartDate.setDateVerifier(dateVerifier);
        this.rsStartDate.setDates(startDates);
        logger.debug((Object)("start date set: " + DateAndTimeFormattingUtils.calendarToLogString(startDates[0])));
        Calendar startDate = GWCalendarUtils.getToday();
        startDate.setTime(task.getStartDate());
        int startMinutes = GWCalendarUtils.getMinutes(startDate);
        TimeDuration duration = new TimeDuration(startMinutes, endMinutes);
        logger.debug((Object)("duration: " + duration));
        this.tfDuration.setDuration(duration);
        this.tfSubject.setText(task.getSubject());
        this.tfPriority.setText(task.getTaskPriority());
        this.rsStartDate.addDateChangeListener(this.startEndDateSynchronizingListener);
        this.rsStartDate.addRecuringDateChangeListener(this);
        this.dsEndDate.addDateChangeListener(this.startEndDateSynchronizingListener);
    }

    protected void build() {
        super.build();
        this.contentPanel.setLayout(new BorderLayout());
        this.tfPriority = new GWTextField();
        this.tfPriority.setDocument(new PriorityDocument());
        this.tfPriority.addFocusListener(new PriorityFocusListener());
        this.tfPriority.setName("TaskEditPanel_tfPriority");
        this.rsStartDate = new RecuringDateSelector();
        this.rsStartDate.addRecuringDateChangeListener(this);
        this.startEndDateSynchronizingListener = new StartEndDateListener();
        this.rsStartDate.addDateChangeListener(this.startEndDateSynchronizingListener);
        ((ExtendedDateTextField)this.rsStartDate.getTextComponent()).setName("TaskEditPanel_rsStartDate_dateField");
        this.tfDuration = new DurationTextField(new DurationDayFormat(), new DurationDayDocumentHandler(0));
        this.dsEndDate = new SingleDateSelector();
        this.dsEndDate.addDateChangeListener(this.startEndDateSynchronizingListener);
        this.dsEndDate.setDateVerifier(new BasicDateVerifier());
        ((Component)this.dsEndDate.getTextComponent()).setName("TaskEditPanel_dsEndDate_dateField");
        this.compFrom = new FromComponent(this);
        this.lbCC = new JMnemonicLabel(StringResources.CC_C, this.tfCC);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, this.tfTo);
        this.lbBC = new JMnemonicLabel(StringResources.BC_C, this.tfBC);
        this.lbStartDate = new JMnemonicLabel(StringResources.START_DATE_C, (Component)this.rsStartDate.getTextComponent());
        this.lbDueOn = new JMnemonicLabel(StringResources.DUE_ON_C, (Component)this.dsEndDate.getTextComponent());
        this.editableEndDate = this.createEditableTextComponent(this.dsEndDate);
        this.editableDuration = this.createEditableTextComponent(this.tfDuration);
        this.plnDueOnIn = new OrientablePanel(new CardLayout());
        this.plnDueOnIn.add((Component)this.editableEndDate, DUE_ON_VIEW);
        this.plnDueOnIn.add((Component)this.editableDuration, DUE_IN_VIEW);
        this.lbSubject = new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject);
        this.lbPriority = new JMnemonicLabel(StringResources.PRIORITY_C, this.tfPriority);
        OrientablePanel messagePanel = new OrientablePanel(new BorderLayout());
        messagePanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        messagePanel.add((Component)this.messageEditor, "Center");
        OrientablePanel attachmentsPanel = new OrientablePanel(new BorderLayout());
        attachmentsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        attachmentsPanel.add((Component)this.attachmentList, "Center");
        this.messageSplit.setBottomComponent(attachmentsPanel);
        this.messageSplit.setTopComponent(messagePanel);
        this.createAddressPane();
        this.contentPanel.add((Component)this.addressPane, "North");
        this.contentPanel.add((Component)this.messageSplit, "Center");
    }

    private void createAddressPane() {
        this.addressPane = new OrientablePanel(new GridBagLayout());
        this.addressPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 10);
        this.addressPane.add((Component)this.compFrom, c);
        c.fill = 2;
        c.insets = new Insets(0, 0, 8, 0);
        c.gridx = 1;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.tfFrom, c);
        c.gridx = 2;
        c.insets = new Insets(0, 15, 8, 25);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbCC, c);
        c.gridx = 3;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcCC, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbTo, c);
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcTo, c);
        c.gridx = 2;
        c.insets = new Insets(0, 15, 8, 25);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbBC, c);
        c.gridx = 3;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcBC, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbStartDate, c);
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.createEditableTextComponent(this.rsStartDate), c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbDueOn, c);
        ((CardLayout)this.plnDueOnIn.getLayout()).show(this.plnDueOnIn, DUE_ON_VIEW);
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.plnDueOnIn, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 10);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbSubject, c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 4;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 0;
        this.addressPane.add((Component)this.createSubjectPanel(), c);
    }

    private JPanel createSubjectPanel() {
        OrientablePanel subjectPanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 3.0;
        subjectPanel.add((Component)this.createEditableTextComponent(this.tfSubject), c);
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 15, 0, 25);
        c.weightx = 0.0;
        subjectPanel.add((Component)this.lbPriority, c);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 0.5;
        subjectPanel.add((Component)this.createEditableTextComponent(this.tfPriority), c);
        return subjectPanel;
    }

    private void init() {
        this.focusTraversalPolicy = new TaskFocusPolicy();
    }

    public void setAccessRights(FolderSharedEntry sharedEntry, boolean itemExists) {
        boolean hasEditAccess = sharedEntry.getAccessRights().hasEditAccess();
        if (itemExists) {
            this.tfSubject.setEditable(hasEditAccess);
            this.messageEditor.setEditable(hasEditAccess);
            ((ExtendedDateTextField)this.rsStartDate.getTextComponent()).setEditable(hasEditAccess);
            ((OrientableTextField)this.dsEndDate.getTextComponent()).setEditable(hasEditAccess);
            this.tfPriority.setEditable(hasEditAccess);
        }
    }

    public void switchToPostedMode() {
        super.switchToPostedMode();
        this.addressPane.removeAll();
        TitleValueContainer container = new TitleValueContainer(this.addressPane);
        container.getInsets().bottom = 8;
        container.getInsets().top = 0;
        container.buildRow(this.compFrom, this.tfFrom, 0);
        container.buildRow(this.lbSubject, this.createSubjectPanel(), 1);
        container.buildRow(this.lbStartDate, this.createEditableTextComponent(this.rsStartDate), 2);
        container.buildRow(this.lbDueOn, this.plnDueOnIn, 3);
    }

    public void valueChanged(RecuringDateChangeEvent event) {
        this.rsStartDate.removeDateChangeListener(this.startEndDateSynchronizingListener);
        if (event.isRecuring()) {
            this.lbStartDate.setText(StringResources.AUTO_DATE_C);
            this.lbDueOn.setText(StringResources.DUE_IN_C);
            ((CardLayout)this.plnDueOnIn.getLayout()).show(this.plnDueOnIn, DUE_IN_VIEW);
        } else {
            this.lbStartDate.setText(StringResources.START_DATE_C);
            this.lbDueOn.setText(StringResources.DUE_ON_C);
            ((CardLayout)this.plnDueOnIn.getLayout()).show(this.plnDueOnIn, DUE_ON_VIEW);
        }
        super.valueChanged(event);
        this.rsStartDate.addDateChangeListener(this.startEndDateSynchronizingListener);
    }

    private class ResendStartDateVerifier
    extends BasicDateVerifier
    implements DateValueChangeListener {
        private Calendar initialDate;

        private ResendStartDateVerifier(Calendar initialDate) {
            assert (initialDate != null) : "initialDate is null";
            this.initialDate = initialDate;
        }

        public Calendar verify(Calendar date) {
            if (this.initialDate != null && GWCalendarUtils.isSameDate(this.initialDate, date)) {
                return date;
            }
            return super.verify(date);
        }

        public void valueChanged(DateChangeEvent e) {
            if (this.initialDate != null && !GWCalendarUtils.isSameDate(this.initialDate, e.getDate())) {
                this.initialDate = null;
            }
        }
    }

    private class BasicDateVerifier
    implements DateVerifier {
        private BasicDateVerifier() {
        }

        public Calendar verify(Calendar date) {
            Calendar today = GWCalendarUtils.getTodayWithoutTimeFraction();
            if (date.getTimeInMillis() < today.getTimeInMillis()) {
                return today;
            }
            return date;
        }
    }

    private class StartEndDateListener
    implements DateValueChangeListener {
        private StartEndDateListener() {
        }

        public void valueChanged(DateChangeEvent e) {
            RecuringDateSelector rsStartDate = TaskEditPanel.this.rsStartDate;
            SingleDateSelector dsEndDate = TaskEditPanel.this.dsEndDate;
            if (e.getSource() == rsStartDate) {
                Calendar start = e.getDate();
                Calendar end = dsEndDate.getDate();
                logger.debug((Object)("start date changed to " + DateAndTimeFormattingUtils.calendarToLogString(start)));
                if (end.getTimeInMillis() < start.getTimeInMillis()) {
                    logger.debug((Object)("endDate < startDate, updating end date to: " + DateAndTimeFormattingUtils.calendarToLogString(start)));
                    dsEndDate.setDate(start);
                }
            } else if (e.getSource() == dsEndDate) {
                Calendar start = rsStartDate.getDates()[0];
                Calendar end = e.getDate();
                logger.debug((Object)("end date changed to " + DateAndTimeFormattingUtils.calendarToLogString(end)));
                if (end.getTimeInMillis() < start.getTimeInMillis() && !GWCalendarUtils.isSameDate(end, start)) {
                    logger.debug((Object)("endDate < startDate, updating start date to: " + DateAndTimeFormattingUtils.calendarToLogString(end)));
                    rsStartDate.setDates(new Calendar[]{end});
                }
            } else assert (false);
        }
    }

    private class PriorityFocusListener
    extends FocusAdapter {
        private PriorityFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            String pr = TaskEditPanel.this.tfPriority.getText();
            if (pr != null && pr.length() > 0) {
                StringBuilder sb = new StringBuilder(4);
                if (Character.isLetter(pr.charAt(0))) {
                    sb.append(Character.toUpperCase(pr.charAt(0)));
                } else if (Character.isDigit(pr.charAt(0))) {
                    sb.append(pr.charAt(0));
                }
                if (pr.length() > 1) {
                    boolean foundDigit = false;
                    int nCount = pr.length();
                    for (int i = 1; i < nCount; ++i) {
                        if (Character.isDigit(pr.charAt(i))) {
                            sb.append(pr.charAt(i));
                            foundDigit = true;
                            continue;
                        }
                        if (!Character.isLetter(pr.charAt(i))) continue;
                        if (sb.length() > 0) {
                            if (Character.isDigit(sb.charAt(0))) {
                                sb.insert(0, Character.toUpperCase(pr.charAt(i)));
                            }
                        } else {
                            sb.append(Character.toUpperCase(pr.charAt(i)));
                        }
                        if (foundDigit) break;
                    }
                }
                String val = sb.toString();
                int iVal = 999;
                try {
                    iVal = Integer.parseInt(val);
                    if (iVal > 999) {
                        iVal = 999;
                    }
                    val = Integer.toString(iVal);
                }
                catch (NumberFormatException numex) {
                    iVal = -1;
                }
                TaskEditPanel.this.tfPriority.setText(val);
            }
        }
    }

    private static class PriorityDocument
    extends PlainDocument {
        private PriorityDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str != null) {
                char[] c = str.toCharArray();
                if (this.getLength() + str.length() <= 4) {
                    int nCount = c.length;
                    for (int i = 0; i < nCount; ++i) {
                        if (Character.isDigit(c[i]) || Character.isLetter(c[i]) || c[i] == ',') continue;
                        return;
                    }
                    super.insertString(offs, str, a);
                }
            }
        }
    }

    private class TaskFocusPolicy
    extends ItemEditPanel.ItemComposerTraversalPolicy {
        private TaskFocusPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component component) {
            TaskEditPanel view = TaskEditPanel.this;
            Component focusOwner = FocusManager.getCurrentManager().getPermanentFocusOwner();
            if (!component.hasFocus()) {
                return focusOwner;
            }
            if (component.equals(view.tfTo) || component.equals(view.tfTo.getRecipientList())) {
                return view.rsStartDate.getTextComponent();
            }
            if (component.equals(view.tfPriority) && !this.isPostedCompose || (component.equals(view.dsEndDate.getTextComponent()) || component.equals(view.tfDuration)) && this.isPostedCompose) {
                return view.messageEditor.getComponent();
            }
            if (component.equals(TaskEditPanel.this.messageEditor.getComponent())) {
                return view.attachmentList.getListContent();
            }
            if (component.equals(view.tfCC) || component.equals(view.tfCC.getRecipientList())) {
                return view.tfBC;
            }
            if (component.equals(view.tfBC) || component.equals(view.tfBC.getRecipientList())) {
                return view.tfTo;
            }
            return super.getComponentAfter(focusCycleRoot, component);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            TaskEditPanel view = TaskEditPanel.this;
            if (aComponent.equals(view.tfTo)) {
                return view.tfBC;
            }
            if (aComponent.equals(view.tfBC)) {
                return view.tfCC;
            }
            if (aComponent.equals(view.rsStartDate.getTextComponent())) {
                return this.isPostedCompose ? view.attachmentList.getListContent() : view.tfTo;
            }
            if (ControlsUtils.isComponentInContainer(view.attachmentList, aComponent)) {
                return view.messageEditor.getComponent();
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return TaskEditPanel.this.getComponentForFocus();
        }
    }
}

