/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemlisttable;

import com.novell.gw.jclient.api.impl.APIWrappingConfigurator;
import com.novell.gw.jclient.api.impl.GroupHeaderImpl_Cached;
import com.novell.gw.jclient.api.impl.ItemListImpl_Cached;
import com.novell.gw.jclient.api.impl.message.AppointmentImpl_Cached;
import com.novell.gw.jclient.api.impl.message.MailImpl_Cached;
import com.novell.gw.jclient.api.impl.message.NoteImpl_Cached;
import com.novell.gw.jclient.api.impl.message.TaskImpl_Cached;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IGroupHeader;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IMail;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.api.interfaces.message.ITask;
import com.novell.gw.jclient.application.controls.itemlisttable.FolderListCellRenderer;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListViewCoolPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import tests.api.ApiTestUtils;
import tests.api.IUserLoginCredentials;

public class CoolFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(CoolFrame.class);
    private IDataStore dataStore;
    private ItemListViewCoolPanel itemListView;
    private JList list;

    public CoolFrame(IDataStore dataStore) {
        this.dataStore = dataStore;
        this.init();
        this.buildUI();
    }

    public IFolder[] getFolders() {
        ArrayList<IFolder> folderList = new ArrayList<IFolder>();
        for (IFolder folder : this.dataStore.getRootFolders()[0].getSubFolders()) {
            folderList.add(folder);
            folderList.addAll(Arrays.asList(folder.getSubFolders()));
        }
        return folderList.toArray(new IFolder[folderList.size()]);
    }

    private void init() {
        this.itemListView = new ItemListViewCoolPanel(null);
        this.setTitle("Cool frame with a cool table");
        this.list = new JList<IFolder>(this.getFolders());
        this.list.setCellRenderer(new FolderListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Object element;
                if (!e.getValueIsAdjusting() && e.getFirstIndex() != -1 && (element = CoolFrame.this.list.getSelectedValue()) instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    IViewDisplaySettings displaySettings = folder.getDisplaySettings().asViewDisplaySettings();
                    CoolFrame.this.itemListView.setData(folder, displaySettings, null);
                    CoolFrame.this.itemListView.refresh();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                CoolFrame.this.itemListView.dispose();
                CoolFrame.this.dataStore.dispose();
            }
        });
    }

    private void buildUI() {
        this.add((Component)this.buildLeftPanel(), "Before");
        this.add((Component)this.itemListView.getComponent(), "Center");
        this.add((Component)this.buildButtons(), "Last");
    }

    private JComponent buildLeftPanel() {
        return new JScrollPane(this.list);
    }

    private JComponent buildButtons() {
        JPanel panel = new JPanel();
        JButton details = new JButton(new AbstractAction("Details"){

            public void actionPerformed(ActionEvent e) {
                CoolFrame.this.itemListView.getViewDisplaySettings().setViewMode(1);
                CoolFrame.this.itemListView.refresh();
            }
        });
        panel.add(details);
        JButton tasklist = new JButton(new AbstractAction("TaskList"){

            public void actionPerformed(ActionEvent e) {
                CoolFrame.this.itemListView.getViewDisplaySettings().setViewMode(7);
                CoolFrame.this.itemListView.refresh();
            }
        });
        panel.add(tasklist);
        JButton conversation = new JButton(new AbstractAction("Conversation"){

            public void actionPerformed(ActionEvent e) {
                CoolFrame.this.itemListView.getViewDisplaySettings().setViewMode(5);
                CoolFrame.this.itemListView.refresh();
            }
        });
        panel.add(conversation);
        JButton messagePreview = new JButton(new AbstractAction("Message Preview"){

            public void actionPerformed(ActionEvent e) {
                CoolFrame.this.itemListView.getViewDisplaySettings().setMsgPreview(!CoolFrame.this.itemListView.getViewDisplaySettings().getMsgPreview());
                CoolFrame.this.itemListView.refresh();
            }
        });
        panel.add(messagePreview);
        JButton summary = new JButton(new AbstractAction("Summary"){

            public void actionPerformed(ActionEvent e) {
                CoolFrame.this.itemListView.getViewDisplaySettings().setSummaryView(!CoolFrame.this.itemListView.getViewDisplaySettings().isSummaryView());
                logger.debug((Object)("isSummaryView(): " + CoolFrame.this.itemListView.getViewDisplaySettings().isSummaryView()));
                CoolFrame.this.itemListView.refresh();
            }
        });
        panel.add(summary);
        JButton showGroupHeader = new JButton(new AbstractAction("Group Headers"){

            public void actionPerformed(ActionEvent e) {
                CoolFrame.this.itemListView.getViewDisplaySettings().setShowGroupHeaders(!CoolFrame.this.itemListView.getViewDisplaySettings().showGroupHeaders());
                CoolFrame.this.itemListView.refresh();
            }
        });
        panel.add(showGroupHeader);
        JButton refresh = new JButton(new AbstractAction("Refresh"){

            public void actionPerformed(ActionEvent e) {
                CoolFrame.this.itemListView.refresh();
            }
        });
        panel.add(refresh);
        return panel;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (UnsupportedLookAndFeelException e) {
            logger.error((Object)e);
        }
        Map<Class, Class> map = APIWrappingConfigurator.getImplementationMap();
        map.put(IItemList.class, ItemListImpl_Cached.class);
        map.put(IAppointment.class, AppointmentImpl_Cached.class);
        map.put(IGroupHeader.class, GroupHeaderImpl_Cached.class);
        map.put(IMail.class, MailImpl_Cached.class);
        map.put(INote.class, NoteImpl_Cached.class);
        map.put(ITask.class, TaskImpl_Cached.class);
        ImageResources.init();
        IDataStore dataStore = ApiTestUtils.login((IUserLoginCredentials)ApiTestUtils.getCredentialsFromArguments((String[])args));
        CoolFrame frame = new CoolFrame(dataStore);
        frame.setDefaultCloseOperation(3);
        frame.setSize(1024, 768);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

